#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include "tastiera.h"
#include "colori.h"

#define WX11_VERSION	"1.55"

typedef enum {
    WINBG,WINFG,
    BUTTONBG,BUTTONFG,
    INPUTBG,INPUTFG,
    MENUBG,MENUFG,
    LISTBOXBG,LISTBOXFG
    } ColorInfo_Type;

struct ColorInfo
{
    unsigned int WinBg;
    unsigned int WinFg;

    unsigned int ButtonBg;
    unsigned int ButtonFg;

    unsigned int InputBg;
    unsigned int InputFg;

    unsigned int MenuBg;
    unsigned int MenuFg;

    unsigned int ListCmdBg;
    unsigned int ListCmdFg;

} ColorInfo;

typedef struct SignalInfo
{
    //
    int Tipo;
    int (*CallBack)();	
    void *data;		
    //
}SignalInfo;

typedef struct SignalHeaderInfo
{
    //
    void *Cmd; //struct CmdInfo *Cmd;

    int num_signals;
    SignalInfo ** signals;	

    struct SignalHeaderInfo *Prev;
    struct SignalHeaderInfo *Next;	
    //
}SignalHeaderInfo;

typedef enum { 
    MAIN, BORDO, AREA, LABEL, BUTTON, RADIO_BOX, CHECK_BOX,
    MENU, MENU_ITEM, INPUT, LIST_BOX, COMBO_BOX,
    SCROLL,
    SCROLL_UP, SCROLL_DN, SCROLL_PGUP, SCROLL_PGDN, SCROLL_VCUR,
    SCROLL_SX, SCROLL_DX, SCROLL_PGSX, SCROLL_PGDX, SCROLL_HCUR, 
    } CmdInfo_Type;

typedef struct CmdInfo
{
    //
    // Type Window (see CmdInfo_Type)
    int Tipo;
    //
    // Name (Optional)
    char * Name;
    //
    // Window	
    Window parent;
    Window win;
    //
    // Coordinate relative al parent
    int x;
    int y;
    //
    // Dimensions
    int Width;
    int Height;
    //
    // Colors 24bit
    short int Gradiant;     // 0=None !0=Yes
    unsigned int Bg;
    //
    unsigned int Fg;
    //
    // General Parameters 
    short int Bordo;        // 0=None >0=Rilief

    short int BUpDn;        // 0=Up   !0=Down
    short int MouseOver;    // 0=None !0=MouseOver
    short int Focus;        // 0=None !0=Focus
    short int Stato;        // 0=None !0=Selezionato
    short int Attivo;       // 0=None !0=Attivo
    short int Hidden;       // 0=None !0=Hidden
    short int Lock;         // 0=None !0=Locked
    short int IsButton;     // 0=None !0=Buttoned
    //
    // Scroll Parameters
    short int scroll_tipo;      // 0=None
                                // 1=Vertical
                                // 2=Horizontal
                                // 3=Vertical+Horizontal

    struct CmdInfo * scrollv;  // ptr Cmd Tipo SCROLL V 
    struct CmdInfo * scrollh;	// ptr Cmd Tipo SCROLL H

    int say_x;                  // Used by WX11_Say
    int say_y;                  // Used by WX11_Say
    int scroll_x;               // pos scroll  0=Origin
    int scroll_y;               // pos scroll  0=Origin
    int scroll_max_x;		// max scroll
    int scroll_max_y;		// max scroll
    int input_x;                // Used by input
    //
    // Used Font
    XFontStruct *Font;
    //
    // Scritta da Visualizzare (opzional)
    char * Label;
    //
    // puntatore al GC (opzional)
    GC gc;
    //
    // Image Pixmap (opzional)
    Pixmap pix;
    unsigned int pix_width;
    unsigned int pix_height;
    unsigned int pix_depth;
    unsigned int pix_x;
    unsigned int pix_y;
    //
    // Puntatore ad Eventi 
    struct SignalHeaderInfo *signal;
    //
    // Puntatore alla corrente lista
    struct CmdInfo * Prev;
    struct CmdInfo * Next;
    //
}CmdInfo ;

typedef struct ExitInfo
{
    CmdInfo *Cmd;   // ptr al MAIN

    int (*CallBack)();	
    void *data;		

    struct ExitInfo *Prev;
    struct ExitInfo *Next;	

}ExitInfo;

typedef struct FontInfo
{
    char * FontName;

    XFontStruct *Font;

    struct FontInfo *Prev;
    struct FontInfo *Next;	

}FontInfo;

typedef struct ListCmdInfo
{

    CmdInfo *CmdPar;    // Comando Area Window
                        //
    CmdInfo *CmdOpen;   // Comando Bottone
			// Per il Menu     == bottone
                        // Per la ListBox  == NULL
                        // per la ComboBox == bottone
                        //
    CmdInfo *CmdInput;  // Comando Input
			// Per il Menu     == NULL
                        // Per la ListBox  == NULL
                        // per la ComboBox == input
                        //
    int State;          // 0 == Close
                        // 0 != Open
                        //
    int NumeroItem;     // Quantita'
    int MaxLenItem;     // Dimensione Item piu' lungo
                        //
    int Width;          // Larghezza
    int Height;         // Altezza
                        //
    char * Name;        // Optional Name
			// Per il Menu     = Label
    //
    // Puntatore ad Eventi 
    struct SignalHeaderInfo *signal;
    //
    struct ListCmdItemInfo *PrimoItem;	     // ptr alle liste
    struct ListCmdItemInfo *CorrenteItem;   // relative degli
    struct ListCmdItemInfo *UltimoItem;     // items

    struct ListCmdInfo *Prev;
    struct ListCmdInfo *Next;

}ListCmdInfo;

typedef struct ListCmdItemInfo
{
    CmdInfo *Cmd;   // Comando Aperto
    int Tipo;       // CmdInfo_Type
    char * Buff;    //

    int *select;
    struct ListCmdItemExtraInfo *extra;

    struct ListCmdItemInfo *Prev;
    struct ListCmdItemInfo *Next;	

}ListCmdItemInfo;

typedef struct ListCmdItemExtraInfo
{
    int (*CallBack)();	
    void *data;
    char *hotkey;

}ListCmdItemExtraInfo;

typedef struct Timer
{
    int (*CallBack)();      // La Funzione
    void *data;             // Il Parametro

    struct timeval START; // Tempo Avvio
    struct timeval   TMP; // Tempo Provvisiorio

    int STOP;               // Stop 
    long int INTERVAL;      // Intervallo

    struct Timer * Prev;
    struct Timer * Next;
	
} Timer;

// attualmente in files.c
char *RTrim (char *stringa);
char *Instr (char *s1,char *s2);

// WX11_signals.c
void WX11_SignalFree (CmdInfo *cmd);
void WX11_SignalFreeAll();
SignalInfo *WX11_SignalSearch (SignalHeaderInfo *SignalHead,int Tipo);
void WX11_SetSignalCallBack (void *cmd,int Tipo,int (*CallBack)(),void *data);
int WX11_SignalExecCallBack(CmdInfo *cmd,int Tipo);

// init.c
Display * WX11_OpenDisplay ();
void WX11_CloseDisplay ();
Display * WX11_GetDisplay ();
int WX11_GetDepth ();
int WX11_GetNumScreen ();
int WX11_GetDisplayWidth ();
int WX11_GetDisplayHeight ();
int InitFinestre (int argc, char **argv);
int EndFinestre ();

// gc.c
void WX11_GCFree (GC gc);
void WX11_GCInit ();
GC WX11_GCGet ();
GC WX11_GCNew (Drawable d);

// color.c
void WX11_ColorGradiant (Pixmap pixmap, int width, int hight, int from_color, int to_color);
void WX11_ColorBackgroundSet (CmdInfo *cmd, unsigned int gradient_from, unsigned int gradient_to);
unsigned int WX11_RGB (unsigned int color);
unsigned int WX11_ColorSet (int Where,unsigned int color);
unsigned int WX11_ColorGet (int Where);
void WX11_ColorChange (CmdInfo *cmd);
unsigned int WX11_ColorLight (unsigned int color);
unsigned int WX11_ColorLightSmall(unsigned int color);
unsigned int WX11_ColorDarkSmall(unsigned int colore);
unsigned int WX11_ColorDark(unsigned int color);

// font.c
void WX11_FontFree (FontInfo *font);
void WX11_FontFreeAll ();
XFontStruct * WX11_FontOpen (char *Fontname);
XFontStruct * WX11_FontCurrent ();
int WX11_FontWidth ();
int WX11_FontHeight ();
void WX11_FontSetCmd (CmdInfo *cmd,char *Fontname);

// border.c
void WX11_BorderRelief (CmdInfo *cmd);
void WX11_DrawArrow (CmdInfo *cmd);

// checkbox.c
CmdInfo * WX11_CheckBoxOpen (int Tipo, CmdInfo * cmd_parent, int x, int y, int Width , int Height, unsigned int colorbg , unsigned int colorfg,  int Bordo, char *Descr, int *flag);


CmdInfo * WX11_Print (CmdInfo *cmd,int x,int y,char *Buff);
CmdInfo * WX11_PrintCenter (CmdInfo *cmd,int y,char *Buff);
void WX11_Locate (CmdInfo *comando, int Mode, int *x,int *y);
CmdInfo *WX11_Say (CmdInfo *cmd, const char *fmt, ...);

// print.c
void WX11_ComandoFocus (CmdInfo *cmd, int mode);
void WX11_MapFlush (CmdInfo *cmd);
void WX11_PrintFlush (CmdInfo *cmd);
void WX11_ReliefBorder (CmdInfo *cmd);

// finestre.c
CmdInfo * PrimoComando (int Mode, CmdInfo *comando);
CmdInfo * UltimoComando (int Mode, CmdInfo *comando);
CmdInfo * ApreFinestra (char *Titolo,int x, int y, int larghezza, int altezza);
CmdInfo * ApreFinestraCentrale (char *Titolo, int larghezza, int altezza);
CmdInfo * ApreFinestraFullScreen (char *Titolo);
CmdInfo * ApreArea (CmdInfo *comando,int x,int y, int larghezza, int altezza, int colorbg, int colorfg, int Bordo);
CmdInfo * ApreBottone (CmdInfo *parent,int x, int y, int larghezza, int altezza, char *Buff);
CmdInfo * ApreInput (CmdInfo *parent, int x, int y, char *Buff, int Len,int Size);
int ChiudeFinestra (Window win);
CmdInfo * WX11_Ask (CmdInfo *cmd, char *say, char *Buff, int SizeOfBuff, int width);
int WX11_PrintDimensions (char *Buff,int *width, int *height);

// comandi.c
CmdInfo * WX11_CmdOpen (int Tipo, CmdInfo * cmd_parent, int x, int y, int Width , int Height, unsigned int colorbg, unsigned int colorfg, int Bordo, char *Descr);

int ComandoAccesoSpento (int Focus,Window win);
void FreeCom (CmdInfo *cmd);
void FreeSubCom (Window win);
void xFreeCmd (CmdInfo *cmd);
void xFreeSubCmd (CmdInfo *cmd);
void ChiudeComando (CmdInfo *cmd);
int IsComando (CmdInfo *cmd);
CmdInfo * CercaComando (Window win);
CmdInfo * CercaNomeComando (char *Name);
void AddNomeComando (CmdInfo *cmd,char *Name);
void CambiaLabel (char *Name,char *NewLabel);
void WX11_CmdLabelChange (CmdInfo *db,char *NewLabel);
CmdInfo * GetPrevTopLevelWindow ();
void WX11_DisableTopLevelWindow (CmdInfo *cmd);
void WX11_EnableTopLevelWindow (CmdInfo *cmd);
CmdInfo * Button (CmdInfo * cmd_parent,	int x, int y, char *Descr, int (*Funz)());

// errori.c
void WX11_FatalError (char *msg, ...);

// input.c
int WX11_IsShift (int State);
int WX11_IsCtrl  (int State);
int WX11_IsAlt (int State);
int WX11_IsCapsLock (int State);
int WX11_IsNumLock  (int State);
int WX11_InputKey (CmdInfo *Comando, int State, unsigned int xsym, char Key);

// eventi.c
void WX11_SetClientMessage (CmdInfo *cmd,int (*CallBack)(),void *data);
int WX11_Events (CmdInfo * comando);
CmdInfo * UltimoComandoSelezionato (int Mode, CmdInfo *cmd);

// exit.c
ExitInfo * xphonya_new_exit (CmdInfo * Cmd,int (*CallBack)(),void *data);
void xphonya_free_all_exit ();
void xphonya_free_exit (ExitInfo *exitinfo);
ExitInfo * ExitInfo_search4cmd (CmdInfo *cmd);
ExitInfo * ExitInfo_search4win (Window win);

// timer.c
void GetCurrentTime( struct timeval *tv);
int timeval_add (struct timeval *result, struct timeval *x, struct timeval *y);
int timeval_subtract (struct timeval *result, struct timeval *x, struct timeval *y);
Timer *NewTimer ();
void FreeTimer (Timer *t);
void FreeAllTimer ();
Timer *SetTimerCallBack (int (*Funz)(),void *data,long int interval);
void TimerStart (Timer *t);
struct timeval TimerWatch (Timer *t);
struct timeval TimerStop (Timer *t);
int TimerLook (int *exitcode);

// listcmd.c
ListCmdInfo * WX11_ListCmdFirst (int Mode,ListCmdInfo *ListCmd);
ListCmdInfo * WX11_ListCmdLast (int Mode,ListCmdInfo *ListCmd);
void WX11_ListCmdFreeItem (ListCmdInfo *ListCmd, ListCmdItemInfo *Item);
void WX11_ListCmdFree (ListCmdInfo *ListCmd);
void WX11_ListCmdFreeUnused ();
ListCmdItemInfo *WX11_ListCmdItemAdd (ListCmdInfo *ListCmd, int Tipo,char *Buff);
ListCmdInfo * WX11_ListCmdAdd (char *Name);
void ListCmdMakeSignals (CmdInfo *cmd, SignalHeaderInfo *signalhead);
int IsListCmd (ListCmdInfo * lista);
ListCmdInfo * CercaListCmdInfo (CmdInfo * cmd);
ListCmdInfo * CercaListCmdOpen (CmdInfo * cmd);

ListCmdItemInfo * CercaListCmdItemInfo (ListCmdInfo *ListCmd, Window win);

// scroll.c
int WX11_HandleScroll (int Mode,XEvent event);
int WX11_WheelScroll (CmdInfo *comando,unsigned int Button);
int WX11_ScrollingPage (CmdInfo *comando);
int WX11_ScrollingArea (CmdInfo *comando,int Cols,int Rows);
int WX11_ScrollBar (CmdInfo *finestra,int Tipo);

// listbox.c
int WX11_ListBoxSelectedItem (CmdInfo *comando);
void WX11_ListBox (CmdInfo *cmd,ListCmdInfo *ListCmd, int width, int height, char *say);
int xClearAllListBoxItem (ListCmdInfo *ViewComment);
void WX11_ListBoxRefresh (ListCmdInfo *ListCmd);

// combobox.c
int WX11_ComboBoxSelectedItem (CmdInfo *cmd,XEvent event);
void WX11_ComboBox (CmdInfo *cmd, ListCmdInfo *ListCmd, int width, int height,  char *say, char *input, int SizeOfBuff);

// menu
ListCmdInfo *WX11_MenuFirst (int mode,ListCmdInfo *menu);
ListCmdInfo *WX11_MenuLast (int mode,ListCmdInfo *menu);
ListCmdInfo *WX11_MenuCurrent (int mode,ListCmdInfo *menu);
void WX11_Menu_free ();
int WX11_MenuHotKey (ListCmdInfo *menu,ListCmdItemInfo *menu_item,char *hotkey);
int WX11_MenuCallBack (ListCmdItemInfo *menu_item,int (*CallBack)(),void *data);
int WX11_MenuExec (CmdInfo *cmd,int EventType,ListCmdInfo *menu);
int WX11_MenuOpen (CmdInfo *cmd,int EventType,ListCmdInfo *menu);
void WX11_Menu (CmdInfo *parent,ListCmdInfo *menu[],int nmenu);

// alert.c
int WX11_Alert (char *Messaggio, ...);

// files.c
char * WX11_Files (char *Label,char *CurDir,...);
char * PathEsecuzione (char *eseguibile);
char * FullPath (char *file);

// viewfile.c
int WX11_ViewFile (char *filename,char *title, int LlWin, int HhWin);

// imgjpeg.c
int WX11_ImgBMP (CmdInfo *cmd,char *file);
int WX11_ImgXPM (CmdInfo *cmd,char *file);
int WX11_ImgJPG (CmdInfo *cmd,char *file);

// util.c
Window Select_Window();

// debug.c
void WX11_debug_all_cmd ();
int WX11_debug_cmd (Window win);
void debug_listcmd ();
