/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_DS_SERVER_H_
#define _SML_DS_SERVER_H_

typedef struct SmlDsServer SmlDsServer;
typedef struct SmlDsSession SmlDsSession;

typedef enum {
	SML_DS_UNKNOWN_TYPE = 0,
	SML_DS_SERVER = 1,
	SML_DS_CLIENT = 2
} SmlDsServerType;

typedef SmlErrorType (* SmlDsServerSanCb) (SmlDsServer *dsserver, SmlAlertType type, void *userdata);

typedef void (* SmlDsSessionConnectCb) (SmlDsSession *dsession, void *userdata);
typedef SmlBool (* SmlDsSessionAlertCb) (SmlDsSession *dsession, SmlAlertType type, const char *last, const char *next, void *userdata);
typedef void (* SmlDsSessionSyncCb) (SmlDsSession *dsession, unsigned int numchanges, void *userdata);
typedef SmlBool (* SmlDsSessionChangesCb) (SmlDsSession *dsession, SmlChangeType type, const char *uid, char *data, unsigned int size, const char *contenttype, void *userdata, SmlError **error);
typedef void (* SmlDsSessionWriteCb) (SmlDsSession *dsession, SmlStatus *status, const char *newuid, void *userdata);

SmlDsServer *smlDsServerNew(const char *type, SmlLocation *location, SmlError **error);
SmlDsServer *smlDsClientNew(const char *type, SmlLocation *location, SmlLocation *target, SmlError **error);
void smlDsServerFree(SmlDsServer *server);
SmlBool smlDsServerRegister(SmlDsServer *server, SmlManager *manager, SmlError **error);
SmlBool smlDsServerAddSan(SmlDsServer *server, SmlNotification *san, SmlError **error);
void smlDsServerReset(SmlDsServer *server);
void smlDsServerSetConnectCallback(SmlDsServer *server, SmlDsSessionConnectCb callback, void *userdata);
void smlDsServerSetSanCallback(SmlDsServer *server, SmlDsServerSanCb callback, void *userdata);
const char *smlDsServerGetLocation(SmlDsServer *server);
const char *smlDsServerGetContentType(SmlDsServer *server);
SmlDsSession *smlDsServerSendAlert(SmlDsServer *server, SmlSession *session, SmlAlertType type, const char *last, const char *next, SmlStatusReplyCb callback, void *userdata, SmlError **error);

void smlDsSessionRef(SmlDsSession *dsession);
void smlDsSessionUnref(SmlDsSession *dsession);
void smlDsSessionDispatch(SmlDsSession *dsession);
SmlBool smlDsSessionCheck(SmlDsSession *dsession);
void smlDsSessionGetAlert(SmlDsSession *dsession, SmlDsSessionAlertCb callback, void *userdata);
SmlBool smlDsSessionSendAlert(SmlDsSession *dsession, SmlAlertType type, const char *last, const char *next, SmlStatusReplyCb callback, void *userdata, SmlError **error);
void smlDsSessionGetChanges(SmlDsSession *dsession, SmlDsSessionChangesCb chgCallback, void *userdata);
void smlDsSessionGetSync(SmlDsSession *dsession, SmlDsSessionSyncCb chgCallback, void *userdata);
SmlBool smlDsSessionSendSync(SmlDsSession *dsession, unsigned int num_changes, SmlStatusReplyCb callback, void *userdata, SmlError **error);
SmlBool smlDsSessionQueueChange(SmlDsSession *dsession, SmlChangeType type, const char *uid, const char *data, unsigned int size, const char *contenttype, SmlDsSessionWriteCb callback, void *userdata, SmlError **error);
SmlBool smlDsSessionCloseSync(SmlDsSession *dsession, SmlError **error);
SmlBool smlDsSessionQueueMap(SmlDsSession *dsession, const char *uid, const char *newuid, SmlError **error);
SmlBool smlDsSessionCloseMap(SmlDsSession *dsession, SmlStatusReplyCb callback, void *userdata, SmlError **error);
const char *smlDsSessionGetLocation(SmlDsSession *dsession);
const char *smlDsSessionGetContentType(SmlDsSession *dsession);
SmlDsServer *smlDsSessionGetServer(SmlDsSession *dsession);
SmlLocation *smlDsSessionGetTarget(SmlDsSession *dsession);

#endif //_SML_DS_SERVER_H_
