/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Registry class in which extension packages are registered.
 */

public class SBMLExtensionRegistry {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected SBMLExtensionRegistry(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(SBMLExtensionRegistry obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLExtensionRegistry obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        throw new UnsupportedOperationException("C++ destructor does not have public access");
      }
      swigCPtr = 0;
    }
  }

  
/**
   <p>
   * Returns an instance (singleton) of the {@link SBMLExtensionRegistry} class.
   * This function needs to be invoked when manipulating the {@link SBMLExtensionRegistry} class. 
   <p>
   * @return the instance of the {@link SBMLExtensionRegistry} object.
   */ public
 static SBMLExtensionRegistry getInstance() {
    return new SBMLExtensionRegistry(libsbmlJNI.SBMLExtensionRegistry_getInstance(), false);
  }

  
/**
   * Add the given {@link SBMLExtension} to this {@link SBMLExtensionRegistry}.
   <p>
   * @param ext the {@link SBMLExtension} object to be added.
   <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_PKG_CONFLICT LIBSBML_PKG_CONFLICT }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */ public
 int addExtension(SBMLExtension ext) {
    return libsbmlJNI.SBMLExtensionRegistry_addExtension(swigCPtr, this, SBMLExtension.getCPtr(ext), ext);
  }

  
/**
   * Returns an {@link SBMLExtension} object with the given package URI or package name (string).
   <p>
   * @param package the URI or name of the package extension
   <p>
   * @return a clone of the {@link SBMLExtension} object with the given package URI or name. The returned 
   *         extension is to be freed (i.e.: deleted) by the caller!
   */ public
 SBMLExtension getExtension(String arg0) {
	return libsbml.DowncastExtension(libsbmlJNI.SBMLExtensionRegistry_getExtension(swigCPtr, this, arg0), false);
}

  
/**
   * Remove all L2 Extension namespaces from the namespace list. This will call all 
   * overriden SBMLExtension.removeL2Namespaces methods.
   */ public
 void removeL2Namespaces(XMLNamespaces xmlns) {
    libsbmlJNI.SBMLExtensionRegistry_removeL2Namespaces(swigCPtr, this, XMLNamespaces.getCPtr(xmlns), xmlns);
  }

  
/**
   * adds all L2 Extension namespaces to the namespace list. This will call all 
   * overriden SBMLExtension.addL2Namespaces methods.
   */ public
 void addL2Namespaces(XMLNamespaces xmlns) {
    libsbmlJNI.SBMLExtensionRegistry_addL2Namespaces(swigCPtr, this, XMLNamespaces.getCPtr(xmlns), xmlns);
  }

  
/**
   * Enables all extensions that support serialization / deserialization with
   * SBML Annotations.
   */ public
 void enableL2NamespaceForDocument(SBMLDocument doc) {
    libsbmlJNI.SBMLExtensionRegistry_enableL2NamespaceForDocument(swigCPtr, this, SBMLDocument.getCPtr(doc), doc);
  }

  
/** 
   * Goes through all extensions in the list of plugins of the given document
   * and disables all plugins that are not being used. 
   */ public
 void disableUnusedPackages(SBMLDocument doc) {
    libsbmlJNI.SBMLExtensionRegistry_disableUnusedPackages(swigCPtr, this, SBMLDocument.getCPtr(doc), doc);
  }

  
/**
   * Disables the package with the given URI / name.
   */ public
 static void disablePackage(String arg0) {
    libsbmlJNI.SBMLExtensionRegistry_disablePackage(arg0);
  }

  
/**
   * If the given <code>package</code> is enabled, returns <code>true</code>; otherwise,
   * returns <code>false.</code>
   <p>
   * @return the status (enabled = <b>true</b>, disabled = <b>false</b> of the given package.
   */ public
 static boolean isPackageEnabled(String arg0) {
    return libsbmlJNI.SBMLExtensionRegistry_isPackageEnabled(arg0);
  }

  
/**
   * Enables the package with the given URI / name.
   */ public
 static void enablePackage(String arg0) {
    libsbmlJNI.SBMLExtensionRegistry_enablePackage(arg0);
  }

  
/**
   * Returns the number of {@link SBMLExtension} with the given extension point.
   <p>
   * @param extPoint the {@link SBaseExtensionPoint}
   <p>
   * @return the number of {@link SBMLExtension} with the given extension point.
   */ public
 long getNumExtension(SBaseExtensionPoint extPoint) {
    return libsbmlJNI.SBMLExtensionRegistry_getNumExtension(swigCPtr, this, SBaseExtensionPoint.getCPtr(extPoint), extPoint);
  }

  
/**
   * Enable/disable the package with the given uri.
   <p>
   * @param uri the URI of the target package.
   * @param isEnabled the boolean value corresponding to enabled (true) or 
   * disabled (false)
   <p>
   * @return false will be returned if the given boolean value is false 
   * or the given package is not registered, otherwise true will be
   * returned.
   */ public
 boolean setEnabled(String uri, boolean isEnabled) {
    return libsbmlJNI.SBMLExtensionRegistry_setEnabled(swigCPtr, this, uri, isEnabled);
  }

  
/**
   * Checks if the extension with the given URI is enabled (true) or 
   * disabled (false)
   <p>
   * @param uri the URI of the target package.
   <p>
   * @return false will be returned if the given package is disabled 
   * or not registered, otherwise true will be returned.
   */ public
 boolean isEnabled(String uri) {
    return libsbmlJNI.SBMLExtensionRegistry_isEnabled(swigCPtr, this, uri);
  }

  
/**
   * Checks if the extension with the given URI is registered (true) 
   * or not (false)
   <p>
   * @param uri the URI of the target package.
   <p>
   * @return true will be returned if the package with the given URI
   * is registered, otherwise false will be returned.
   */ public
 boolean isRegistered(String uri) {
    return libsbmlJNI.SBMLExtensionRegistry_isRegistered(swigCPtr, this, uri);
  }

  
/** 
   * Returns the number of registered packages.
   <p>
   * @return the number of registered packages.
   */ public
 static long getNumRegisteredPackages() {
    return libsbmlJNI.SBMLExtensionRegistry_getNumRegisteredPackages();
  }

  
/** 
   * Returns the registered package name at the given index
   <p>
   * @param index zero based index of the package name to return
   <p>
   * @return the package name with the given index or null
   */ public
 static String getRegisteredPackageName(long index) {
    return libsbmlJNI.SBMLExtensionRegistry_getRegisteredPackageName(index);
  }

}
