#include "osl/container/bitXmask.h"
#include <iomanip>
#include <iostream>
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
extern bool isShortTest;

class BoardTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(BoardTest);
  CPPUNIT_TEST(testConversion);
  CPPUNIT_TEST(testOnBoard);
  CPPUNIT_TEST(testPositionForBlack);
  CPPUNIT_TEST(testIsValid);
  CPPUNIT_TEST(testOffsetShow);
  CPPUNIT_TEST(testOffsetSub);
  CPPUNIT_TEST(testOffsetAdd);
  CPPUNIT_TEST(test24);
  CPPUNIT_TEST_SUITE_END();
 public:
  void testConversion();
  void testOnBoard();
  void testPositionForBlack();
  void testIsValid();
  void testOffsetShow();
  void testOffsetSub();
  void testOffsetAdd();
  void test24();
};


CPPUNIT_TEST_SUITE_REGISTRATION(BoardTest);

static bool can_handle(Position pos)
{
  return (pos.index() > 0) && (pos.index() < Position::indexMax());
}

void BoardTest::test24()
{
  CPPUNIT_ASSERT(can_handle(Position(1,1)));
  CPPUNIT_ASSERT(can_handle(Position(0,0)));
  // 24近傍が配列におさまると楽なこともあるけど，現状は違うようだ
  // CPPUNIT_ASSERT(! can_handle(Position(-1,-1)));
}

void BoardTest::testConversion(){
  for(int x=9;x>=1;x--)
    for(int y=1;y<=9;y++){
      Position pos(x,y);
      CPPUNIT_ASSERT(pos.x() == x);
      CPPUNIT_ASSERT(pos.y() == y);
    }
}
void BoardTest::testOnBoard(){
  CPPUNIT_ASSERT(Position::STAND().isOnBoard() ==false);
  for(int i=-(16*16);i<Position::SIZE+(16*16);i++)
    {
    Position pos=Position::nth((unsigned int)i);
    if(i>=0 && i<256 && 1<=pos.x() && pos.x()<=9 && 1<=pos.y() && pos.y()<=9){
      CPPUNIT_ASSERT(pos.isOnBoard() == true);
    }
    else{
      CPPUNIT_ASSERT(pos.isOnBoard() == false);
    }
  }
  CPPUNIT_ASSERT(Position(0, 4).isOnBoard() ==false);
  CPPUNIT_ASSERT(Position(10,5).isOnBoard() ==false);
  CPPUNIT_ASSERT(Position(4, 0).isOnBoard() ==false);
  CPPUNIT_ASSERT(Position(5,10).isOnBoard() ==false);
  for(int x=0;x<=10;x++)
    for(int y=0;y<=10;y++){
      Position pos(x,y);
      if(x==0 || x==10 || y==0 || y==10){
	if(!pos.isEdge()){
	  std::cerr << "position=" << pos << std::endl;
	}
	CPPUNIT_ASSERT(pos.isEdge());
      }
      else{
	if(pos.isEdge()){
	  std::cerr << "position=" << pos << std::endl;
	}
	CPPUNIT_ASSERT(!pos.isEdge());
      }
    }
  CPPUNIT_ASSERT(Position(0, 4).isEdge());
  CPPUNIT_ASSERT(Position(10,5).isEdge());
  CPPUNIT_ASSERT(Position(4, 0).isEdge());
  CPPUNIT_ASSERT(Position(5,10).isEdge());
}

void BoardTest::testPositionForBlack(){
  for(int x=1;x<=9;x++)
    for(int y=1;y<=9;y++){
      Position pos(x,y);
      CPPUNIT_ASSERT(pos.positionForBlack(BLACK)==pos.positionForBlackSlow(BLACK));
      CPPUNIT_ASSERT(pos.positionForBlack(WHITE)==pos.positionForBlackSlow(WHITE));
    }
}

void BoardTest::testIsValid(){
  CPPUNIT_ASSERT(Position::STAND().isValid() ==true);
  for(int x=9;x>0;x--)
    for(int y=1;y<=9;y++){
      Position pos(x,y);
      CPPUNIT_ASSERT(pos.isValid() == true);
    }
  CPPUNIT_ASSERT(Position(0, 4).isValid() ==false);
  CPPUNIT_ASSERT(Position(10,5).isValid() ==false);
  CPPUNIT_ASSERT(Position(4, 0).isValid() ==false);
  CPPUNIT_ASSERT(Position(5,10).isValid() ==false);
}

void BoardTest::testOffsetShow(){
  if (! isShortTest)
  {
    std::cerr << Offset(-3,5) << std::endl;
    std::cerr << Offset(9,9) << std::endl;
  }
}
void BoardTest::testOffsetSub(){
  CPPUNIT_ASSERT(Position(9,9)-Position(7,6)==Offset(2,3));
  CPPUNIT_ASSERT(Position(6,7)-Position(9,9)==Offset(-3,-2));
}
void BoardTest::testOffsetAdd(){
  CPPUNIT_ASSERT(Position(9,9)-Offset(2,3)==Position(7,6));
  CPPUNIT_ASSERT(Position(6,7)+Offset(-3,-2)==Position(3,5));
  Position p=Position(6,7);
  p+=Offset(-2,2);
  CPPUNIT_ASSERT(p==Position(4,9));
  p-=Offset(-5,3);
  CPPUNIT_ASSERT(p==Position(9,6));

}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
