#include "osl/container/pieceVector.h"
#include "osl/eval/pieceEval.h"
#include <boost/foreach.hpp>
#include <algorithm>
#include <iostream>

namespace osl
{
  struct PieceBasicLessThan
  {
    bool operator()(Piece p0,Piece p1){
      const Ptype ptype0=unpromote(p0.ptype());
      const Ptype ptype1=unpromote(p1.ptype());
      return (eval::Ptype_Eval_Table.value(ptype0)
	      < eval::Ptype_Eval_Table.value(ptype1));
    }
  };
  struct PiecePtypeMoreThan
  {
    bool operator()(Piece p0,Piece p1){
      const PtypeO ptypeo0=p0.ptypeO();
      const PtypeO ptypeo1=p1.ptypeO();
      return (abs(eval::Ptype_Eval_Table.captureValue(ptypeo0))
	      > abs(eval::Ptype_Eval_Table.captureValue(ptypeo1)));
    }
  };
} // namespace osl

void osl::container::PieceVector::sortByBasic()
{
  std::sort(begin(),end(),PieceBasicLessThan());
}

void osl::container::PieceVector::sortByPtype()
{
  std::sort(begin(),end(),PiecePtypeMoreThan());
}

#ifndef MINIMAL
std::ostream& osl::container::operator<<(std::ostream& os,PieceVector const& pv)
{
  os << "PieceVector";
  BOOST_FOREACH(Piece p, pv) {
    os << " " << p;
  }
  return os << std::endl;
}
#endif
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
