/* pawnDropCheckmate.h
 */
#ifndef _MOVE_CLASSIFIER_PAWNDROPCHECKMATE_H
#define _MOVE_CLASSIFIER_PAWNDROPCHECKMATE_H

#include "osl/ptype.h"
#include "osl/player.h"
#include "osl/position.h"
#include "osl/direction.h"
#include "osl/piece.h"
#include "osl/effect_util/effectUtil.h"
#include "osl/state/numEffectState.h"
#include "osl/checkmate/king8Info.h"
namespace osl
{
  namespace move_classifier
  {
    /**
     * 打歩詰の判定.
     * @param P 指手(攻撃)側
     */
    template <Player P>
    struct PawnDropCheckmate
    {
      /**
       * kingPosition に居る alt(P)の玉が dir 方向に逃げられるか.
       */
      template <class State>
      static bool canEscape(const State& state, Position kingPosition, 
			    Direction dir, Position dropAt);
      /** 王が前以外に移動可能か */
      template <class State>
      static bool escape7(const State& state, 
			  Position kingPosition, Position to);
      static bool isMember(const NumEffectState& state, 
			   Ptype ptype,Position from,Position to)
      {
	// 打歩
	if (! from.isPieceStand())
	  return false;
	if (ptype != PAWN)
	  return false;
	const Player Opponent = PlayerTraits<P>::opponent;
	const Piece king = state.template getKingPiece<Opponent>();
	const Position king_position = king.position();
	// DirectionPlayerTraits?
	// 玉頭
        if (king_position != (to + DirectionPlayerTraits<U,P>::offset()))
	  return false;
	// 玉で取れない
	if (! state.hasEffectBy(P, to))
	  return false;
	if (King8Info(state.Iking8Info(Opponent)).liberty() != 0)
	  return false;
	// 玉以外の駒で取れない
	if (EffectUtil::template safeCaptureNotByKing<Opponent>
	    (state, to, king)
	    != Piece::EMPTY())
	  return false;
	// どこにも逃げられない
	return escape7(state, king_position, to);
      }
    };
  } // namespace move_classifier
} // namespace osl

template <osl::Player P>
template <class State>
bool osl::move_classifier::PawnDropCheckmate<P>::
canEscape(const State& state, Position kingPosition, 
	  Direction dir, Position dropAt) 
{
  const Player Opponent = PlayerTraits<P>::opponent;
  const Position target 
    = kingPosition + Board_Table.getOffset(Opponent, dir);
  const Piece p = state.getPieceAt(target);
  if (p.isOnBoardByOwner<Opponent>())
    return false;		// 自分の駒がいたら移動不能
  if (target.isEdge())
    return false;
  Piece attacker;
  if (! state.template hasEffectBy<P>(target, attacker))
    return true;		// 利きがない
  if (attacker == Piece::EMPTY())
    return false;		// 攻撃側に複数の利き
  assert(attacker.owner() == P);
  // drop によりふさがれた利きなら逃げられる
  //    -OU
  // XXX+FU+HI
  // の場合のXXXなど．
  const Offset shortOffset
    = Board_Table.getShortOffsetNotKnight(Offset32(target,dropAt));
  if (shortOffset.zero())
    return false;
  const Position attackFrom = attacker.position();
  return shortOffset
    == Board_Table.getShortOffsetNotKnight(Offset32(dropAt,attackFrom));
}

template <osl::Player P>
template <class State>
bool osl::move_classifier::PawnDropCheckmate<P>::
escape7(const State& state, Position king_position, Position to)
{
  // U は歩
  if (canEscape(state, king_position, UL, to))
    return false;
  if (canEscape(state, king_position, UR, to))
    return false;
  if (canEscape(state, king_position, L, to))
    return false;
  if (canEscape(state, king_position, R, to))
    return false;
  if (canEscape(state, king_position, DL, to))
    return false;
  if (canEscape(state, king_position, D, to))
    return false;
  if (canEscape(state, king_position, DR, to))
    return false;
  return true;
}
      

#endif /* _MOVE_CLASSIFIER_PAWNDROPCHECKMATE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
