/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.rmi.iiop;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import mx4j.tools.adaptor.rmi.RMIAdaptor;

/**
 * Adaptor for the IIOP protocol, the CORBA default protocol
 *
 * @version $Revision: 1.3 $
 */
public class IIOPAdaptor extends RMIAdaptor implements IIOPAdaptorMBean
{
   private boolean m_running;

   /**
    * Creates a new IIOP adaptor
    */
   public IIOPAdaptor()
   {
   }

   public void start() throws RemoteException, NamingException
   {
      if (!isRunning())
      {
         installInterceptors();

         PortableRemoteObject.exportObject(this);

         bind(this);

         m_running = true;
      }
   }

   public void stop() throws NoSuchObjectException, NamingException
   {
      if (isRunning())
      {
         PortableRemoteObject.unexportObject(this);

         unbind();

         uninstallInterceptors();

         m_running = false;
      }
   }

   public boolean isRunning()
   {
      return m_running;
   }

   public String getProtocol()
   {
      return "rmi/iiop";
   }
}
