/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package test.mx4j.tools.connector;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;

import mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor;
import mx4j.tools.connector.RemoteStandardMBeanProxy;
import mx4j.tools.connector.rmi.jrmp.JRMPConnector;
import mx4j.tools.naming.NamingService;
import test.MX4JTestCase;

/**
 * @version $Revision: 1.4 $
 * @deprecated
 */
public class RemoteStandardMBeanProxyTest extends MX4JTestCase
{
   private MBeanServer server;
   private MBeanServerConnection remote;
   private JRMPAdaptor adaptor;
   private NamingService naming;
   private ObjectName namingName;
   private ObjectName adaptorName;

   public RemoteStandardMBeanProxyTest(String s)
   {
      super(s);
   }

   protected void setUp() throws Exception
   {
      server = MBeanServerFactory.newMBeanServer();
      namingName = new ObjectName("Naming:type=rmiregistry");
      adaptorName = new ObjectName("Adaptor:type=jrmp");
      naming = new NamingService();
      adaptor = new JRMPAdaptor();

      server.registerMBean(naming, namingName);
      naming.start();
      server.registerMBean(adaptor, adaptorName);
      String jndi = "jrmp";
      adaptor.setJNDIName(jndi);
      System.setProperty(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.rmi.registry.RegistryContextFactory");
      System.setProperty(Context.PROVIDER_URL, "rmi://localhost:1099");

      adaptor.start();

      JRMPConnector connector = new JRMPConnector();
      connector.connect(jndi, null);
      remote = connector.getRemoteMBeanServer();
   }

   protected void tearDown() throws Exception
   {
      adaptor.stop();
      naming.stop();
      server.unregisterMBean(adaptorName);
      server.unregisterMBean(namingName);
   }

   public void testRemoteExceptionWithRemoteInterface() throws Exception
   {
      ObjectName name = new ObjectName("domain:key=value");
      LocalService mbean = new LocalService();
      server.registerMBean(mbean, name);

      RemoteService remoteMBean = (RemoteService)RemoteStandardMBeanProxy.create(RemoteService.class, remote, name);

      // Now stop the adaptor, we should get RemoteException
      adaptor.stop();

      try
      {
         remoteMBean.throwCheckedException();
         fail("Cannot connect");
      }
      catch (NamingException x)
      {
         fail("Cannot connect");
      }
      catch (RemoteException x)
      {
      }
   }

   public void testRemoteExceptionWithLocalInterface() throws Exception
   {
      ObjectName name = new ObjectName("domain:key=value");
      LocalService mbean = new LocalService();
      server.registerMBean(mbean, name);

      LocalServiceMBean remoteMBean = (LocalServiceMBean)RemoteStandardMBeanProxy.create(LocalServiceMBean.class, remote, name);

      // Now stop the adaptor, we should get RemoteException
      adaptor.stop();

      // Now try the local interface
      try
      {
         remoteMBean.throwCheckedException();
         fail();
      }
      catch (NamingException x)
      {
         fail();
      }
      catch (UndeclaredThrowableException x)
      {
         Throwable xx = x.getUndeclaredThrowable();
         if (!(xx instanceof RemoteException)) fail();
      }
   }

   public void testCheckedException() throws Exception
   {
      ObjectName name = new ObjectName("domain:key=value");
      LocalService mbean = new LocalService();
      server.registerMBean(mbean, name);

      LocalServiceMBean remoteMBean = (LocalServiceMBean)RemoteStandardMBeanProxy.create(LocalServiceMBean.class, remote, name);

      try
      {
         remoteMBean.throwCheckedException();
         fail();
      }
      catch (NamingException x)
      {
      }
   }

   public interface LocalServiceMBean
   {
      public void throwCheckedException() throws NamingException;

      public void throwMBeanException() throws MBeanException;

      public void throwNullPointerException();

      public void throwError();
   }

   public interface RemoteService
   {
      public void throwCheckedException() throws NamingException, IOException;

      public void throwMBeanException() throws MBeanException, IOException;

      public void throwNullPointerException() throws IOException;

      public void throwError() throws IOException;
   }

   public class LocalService implements LocalServiceMBean
   {
      public void throwCheckedException() throws NamingException
      {
         throw new NamingException();
      }

      public void throwMBeanException() throws MBeanException
      {
         throw new MBeanException(new Exception());
      }

      public void throwNullPointerException()
      {
         throw new NullPointerException();
      }

      public void throwError()
      {
         throw new Error();
      }
   }

}
