package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;

/**
 * Returns the {@link ExpirationAlgorithm} as the policy's algorithm.
 *
 * @author rosse
 */
public class ExpirationPolicy extends BaseEvictionPolicy
{

   private EvictionAlgorithm algorithm;

   public ExpirationPolicy()
   {
      algorithm = new ExpirationAlgorithm(this);
   }

   public EvictionAlgorithm getEvictionAlgorithm()
   {
      return algorithm;
   }

   public Class<ExpirationConfiguration> getEvictionConfigurationClass()
   {
      return ExpirationConfiguration.class;
   }

   /**
    * Returns true if it's a visit node event.
    */
   @Override
   public boolean canIgnoreEvent(Fqn fqn, NodeEventType eventType)
   {
      return (eventType == NodeEventType.VISIT_NODE_EVENT);
   }
}
