# Perl5 script to make binary search table for width of UCS characters on terminal
# from EastAsianWidth.txt

require 5;

my (@wid, $line, $code, $width, $desc, $i);

while (defined($line = <>)) {
  ($code, $width, $desc) = split(/;/, $line, 3);

  if (defined($desc)) {
    my $i = hex($code) - 0xA0;

    if ($i >= 0xA0) {
      if ($desc =~ /^COMBINING\s/) {
	$wid[$i] = 0;
      }
      elsif ($width =~ /^(F|W|A)$/) {
	$wid[$i] = 2;
      }
      else {
	$wid[$i] = 1;
      }
    }
  }
}

my ($wid, $beg, $end, $code, $twid);

for ($wid = 1, $code = 0 ; $code < @wid ; ++$code) {
  $twid = $wid[$code];
  $twid = $wid if (!defined($twid));

  if ($twid != $wid) {
    printf "{0x%04X,0x%04X,%d},\n", $beg + 0xA0, $end + 0xA0, $wid if ($wid != 1);
    $beg = $end = $code;
    $wid = $twid;
  }
  else {
    $end = $code;
  }
}

printf "{0x%04X,0x%04X,%d},\n", $beg + 0xA0, $end + 0xA0, $wid if ($wid != 1);
exit;
