# Perl5 script to make a mapping table of domestic-ascii characters
# which are not mapped to U+0021 -- U+007E.
# Invoke as:
#   perl notascii.pl /path/to/text-mapping-datas/*.TXT

require 5;

$noa_h = 'notascii.h' if (!defined($noa_h));

require 'ucs-to-iso-lib.pl';
require 'mbbtri.pl';

my $notascii_map;

(undef, $notascii_map) = &make_map;

my $noa = &bt_new;
my ($ucs, @def, $i);

for ($ucs = 0xA0, $pool= 0 ; $ucs < @$notascii_map ; ++$ucs) {
  if (ref($notascii_map->[$ucs]) eq 'HASH') {
    @def = sort {$a->[0] <=> $b->[0]} values %{$notascii_map->[$ucs]};

    for ($i = 0 ; $i < @def ; ++$i) {
      &bt_add($noa, &mb_word_enc(@{$def[$i]}[1, 0]), 1);
    }
  }
}

&bt_optimize($noa);
&bt_make_c_header($noa, $noa_h);

exit;
