#include "cn.h"

static struct big5_to_cns_st {int big5_beg, big5_end, cns_beg, plane;} big5_to_cns[] = {
#include "big5-to-cns.h"
};

void
mb_big5_convg0sl(mb_char_t *ch, mb_info_t *info)
{
  return;
}

void
mb_conv_big5_to_cns(mb_char_t *ch, mb_info_t *info)
{
  int c1, c2, big5, c;
  size_t b, e, i;

  switch (ch->fc & MB_ESC_FC_MASK) {
  case MB_BIG5L_FC & MB_ESC_FC_MASK:
    c1 = ch->c / 0x60;
    c2 = ch->c % 0x60;

    if (c2 < 0x40 - 0x20 || c2 > 0x7E - 0x20)
      return;

    c2 += 0x20;
    goto search;
  case MB_BIG5R_FC & MB_ESC_FC_MASK:
    c1 = ch->c / 0x60;
    c2 = ch->c % 0x60;

    if (c2 < 0xA1 - 0xA0 || c2 > 0xFE - 0xA0)
      return;

    c2 += 0xA0;
  search:
    if (c1 < 0xA1 - 0xA0 || c1 > 0xFE - 0xA0)
      return;

    big5 = ((c1 + 0xA0) << 8) | c2;
    e = sizeof(big5_to_cns) / sizeof(big5_to_cns[0]);

    for (b = 0 ; b < e ;) {
      i = (b + e) / 2;

      if (big5 < big5_to_cns[i].big5_beg)
	e = i;
      else if (big5 > big5_to_cns[i].big5_end)
	b = i + 1;
      else {
	c = (((c1 - (0xA1 - 0xA0)) * (0x7E - 0x40 + 1 + 0xFE - 0xA1 + 1)
	      + (c2 >= 0xA1 ? c2 - 0xA1 + 0x7F - 0x40 : c2 - 0x40))
	     - ((((big5_to_cns[i].big5_beg >> 8) & 0xFF) - 0xA1) * (0x7E - 0x40 + 1 + 0xFE - 0xA1 + 1)
		+ ((big5_to_cns[i].big5_beg & 0xFF) >= 0xA1 ?
		   (big5_to_cns[i].big5_beg & 0xFF) - 0xA1 + 0x7F - 0x40 :
		   (big5_to_cns[i].big5_beg & 0xFF) - 0x40))
	     + ((((big5_to_cns[i].cns_beg >> 8) & 0x7F) - 0x21) * 0x5E + (big5_to_cns[i].cns_beg & 0x7F) - 0x21));
	ch->c = ((c / 0x5E) + 0x21 - 0x20) * 0x60 + c % 0x5E + 0x21 - 0x20;
	ch->set = mb_94x94;
	ch->fc = 0x47 + big5_to_cns[i].plane - 1;
	break;
      }
    }

    if (b < e)
      break;
  default:
    return;
  }

  ch->gn = mb_G0;
  ch->sn = mb_SL;
}

int
mb_big5_enc(int c, mb_info_t *info)
{
  int cc;
  mb_char_t ch;

  if (c >= 0xA1 && c <= 0xFE && (cc = mb_call_getc(info)) != EOF) {
    if (cc >= 0x40 && cc <= 0x7E) {
      ch.c = (c - 0xA0) * 0x60 + cc - 0x20;
      ch.fc = MB_BIG5L_FC;
    }
    else if (cc >= 0xA1 && cc <= 0xFE) {
      ch.c = (c - 0xA0) * 0x60 + cc - 0xA0;
      ch.fc = MB_BIG5R_FC;
    }
    else {
      char temp[1];

      temp[0] = cc;
      mb_fill_inbuf(info, temp, 1);
      goto bad;
    }

    goto end;
  }

bad:
  ch.c = c;
  ch.fc = MB_UNKNOWN_FC;
end:
  ch.set = mb_128;
  ch.gn = mb_G1;
  ch.sn = mb_SR;
  return mb_utf8_badenc(&ch, info);
}

size_t
mb_big5_dec(int c, int fc, char *buf)
{
  size_t e;

  switch (fc) {
  case MB_BIG5L_FC & MB_ESC_FC_MASK:
    buf[0] = c / 0x60 + 0xA0;
    buf[1] = c % 0x60 + 0x20;
    e = 2;
    break;
  case MB_BIG5R_FC & MB_ESC_FC_MASK:
    buf[0] = c / 0x60 + 0xA0;
    buf[1] = c % 0x60 + 0xA0;
    e = 2;
    break;
  default:
    e = 0;
    break;
  }

  return e;
}

size_t
mb_big5_width(mb_char_t *ch)
{
  return 2;
}

void
mb_euctw_convg0sl(mb_char_t *ch, mb_info_t *info)
{
  int fc = ch->fc & MB_ESC_FC_MASK;

  if (fc >= (MB_EUCTWB_FC & MB_ESC_FC_MASK) && fc <= (MB_EUCTWB_FC & MB_ESC_FC_MASK) + 6) {
    ch->set = mb_94x94;
    ch->fc = (fc - (MB_EUCTWB_FC & MB_ESC_FC_MASK)) + 0x47;
  }
}

int
mb_euctw_enc(int c, mb_info_t *info)
{
  int c1;
  char temp[3];
  size_t e = 0;
  mb_char_t ch;

  if (c >= 0xA1 && c <= 0xFE && (c1 = mb_call_getc(info)) != EOF) {
    if (c1 >= 0xA1 && c <= 0xFE) {
      ch.c = (c - 0xA0) * 0x60 + c1 - 0xA0;
      ch.set = mb_128;
      ch.fc = MB_EUCTWB_FC;
      ch.gn = mb_G1;
      ch.sn = mb_SR;
      return mb_utf8_badenc(&ch, info);
    }

    temp[0] = c1;
    e = 1;
  }
  else if (c == 0x8E && (c1 = mb_call_getc(info)) != EOF) {
    int c2;

    if (c1 >= 0xA1 && c1 <= 0xB0 && (c2 = mb_call_getc(info)) != EOF) {
      int c3;

      if (c2 >= 0xA1 && c2 <= 0xB0 && (c3 = mb_call_getc(info)) != EOF) {
	if (c3 >= 0xA1 && c3 <= 0xFE) {
	  ch.c = (c2 - 0xA0) * 0x60 + c3 - 0xA0;
	  ch.set = mb_128;
	  ch.fc = MB_EUCTWB_FC + (c1 - 0xA1);
	  ch.gn = mb_G2;
	  ch.sn = mb_SSR;
	  return mb_utf8_badenc(&ch, info);
	}

	temp[0] = c1;
	temp[1] = c2;
	temp[2] = c3;
	e = 3;
      }
      else {
	temp[0] = c1;
	temp[1] = c2;
	e = 2;
      }
    }
    else {
      temp[0] = c1;
      e = 1;
    }
  }

  if (e)
    mb_fill_inbuf(info, temp, e);

  ch.c = c;
  ch.set = mb_128;
  ch.fc = MB_UNKNOWN_FC;
  ch.gn = mb_G1;
  ch.sn = mb_SR;
  return mb_utf8_badenc(&ch, info);
}

size_t
mb_euctw_dec(int c, int fc, char *buf)
{
  int i = (fc & MB_ESC_FC_MASK) - (MB_EUCTWB_FC & MB_ESC_FC_MASK);

  if (i >= 1 && i <= 0x10) {
    buf[0] = 0x8E;
    buf[1] = 0xA1 + i;
    buf[2] = c / 0x60 + 0xA0;
    buf[3] = c % 0x60 + 0xA0;
    return 4;
  }
  else {
    buf[0] = c / 0x60 + 0xA0;
    buf[1] = c % 0x60 + 0xA0;
    return 2;
  }
}

size_t
mb_euctw_width(mb_char_t *ch)
{
  return 2;
}

void
mb_conv_iso2022cn(mb_char_t *ch, mb_info_t *info)
{
  mb_conv_allg0sl(ch, info);

  switch (ch->set) {
  case mb_94x94:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x41 & MB_ESC_FC_MASK:
    case 0x45 & MB_ESC_FC_MASK:
    case 0x47 & MB_ESC_FC_MASK:
      ch->gn = mb_G1;
      ch->sn = mb_SL;
      break;
    case 0x48 & MB_ESC_FC_MASK:
      ch->gn = mb_G2;
      ch->sn = mb_SSL;
      break;
    case 0x49 & MB_ESC_FC_MASK:
    case 0x4A & MB_ESC_FC_MASK:
    case 0x4B & MB_ESC_FC_MASK:
    case 0x4C & MB_ESC_FC_MASK:
    case 0x4D & MB_ESC_FC_MASK:
      ch->gn = mb_G3;
      ch->sn = mb_SSL;
    default:
      break;
    }
  default:
    break;
  }
}

void
mb_conv_euc_tw(mb_char_t *ch, mb_info_t *info)
{
  int fc;

  switch (ch->set) {
  case mb_94x94:
    switch (fc = ch->fc & MB_ESC_FC_MASK) {
    case 0x47 & MB_ESC_FC_MASK:
      ch->set = mb_128;
      ch->fc = MB_EUCTWB_FC;
      ch->gn = mb_G1;
      ch->sn = mb_SR;
      break;
    case 0x48 & MB_ESC_FC_MASK:
    case 0x49 & MB_ESC_FC_MASK:
    case 0x4A & MB_ESC_FC_MASK:
    case 0x4B & MB_ESC_FC_MASK:
    case 0x4C & MB_ESC_FC_MASK:
    case 0x4D & MB_ESC_FC_MASK:
      ch->set = mb_128;
      ch->fc = MB_EUCTWB_FC + (fc - (0x47 & MB_ESC_FC_MASK));
      ch->gn = mb_G2;
      ch->sn = mb_SSR;
    default:
      break;
    }

    break;
  case mb_94_0:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x42 & MB_ESC_FC_MASK:
      ch->gn = mb_G0;
      ch->sn = mb_SL;
      break;
    }
  default:
    break;
  }
}

void
mb_conv_cn_gb(mb_char_t *ch, mb_info_t *info)
{
  switch (ch->set) {
  case mb_94x94:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x41 & MB_ESC_FC_MASK:
      ch->gn = mb_G1;
      ch->sn = mb_SR;
    default:
      break;
    }

    break;
  case mb_94_0:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x42 & MB_ESC_FC_MASK:
      ch->gn = mb_G0;
      ch->sn = mb_SL;
      break;
    }
  default:
    break;
  }
}

void
mb_conv_cn_gb_isoir165(mb_char_t *ch, mb_info_t *info)
{
  switch (ch->set) {
  case mb_94x94:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x45 & MB_ESC_FC_MASK:
      ch->gn = mb_G1;
      ch->sn = mb_SR;
    default:
      break;
    }

    break;
  case mb_94_0:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x42 & MB_ESC_FC_MASK:
      ch->gn = mb_G0;
      ch->sn = mb_SL;
      break;
    }
  default:
    break;
  }
}

#include "cns-to-big5.h"

struct cns_to_big5_st {int cns_beg, cns_end, big5_beg;};

#ifdef CNS1_TO_BIG5
static struct cns_to_big5_st cns1_to_big5[] = {
#include "cns1-to-big5.h"
};
#endif

#ifdef CNS2_TO_BIG5
static struct cns_to_big5_st cns2_to_big5[] = {
#include "cns2-to-big5.h"
};
#endif

#ifdef CNS3_TO_BIG5
static struct cns_to_big5_st cns3_to_big5[] = {
#include "cns3-to-big5.h"
};
#endif

#ifdef CNS4_TO_BIG5
static struct cns_to_big5_st cns4_to_big5[] = {
#include "cns4-to-big5.h"
};
#endif

#ifdef CNS5_TO_BIG5
static struct cns_to_big5_st cns5_to_big5[] = {
#include "cns5-to-big5.h"
};
#endif

#ifdef CNS6_TO_BIG5
static struct cns_to_big5_st cns6_to_big5[] = {
#include "cns6-to-big5.h"
};
#endif

#ifdef CNS7_TO_BIG5
static struct cns_to_big5_st cns7_to_big5[] = {
#include "cns7-to-big5.h"
};
#endif

static struct {
  struct cns_to_big5_st *tab;
  size_t n;
} cns_to_big5[] = {
#ifdef CNS1_TO_BIG5
  {cns1_to_big5, sizeof(cns1_to_big5) / sizeof(cns1_to_big5[0])},
#endif
#ifdef CNS2_TO_BIG5
  {cns2_to_big5, sizeof(cns2_to_big5) / sizeof(cns2_to_big5[0])},
#endif
#ifdef CNS3_TO_BIG5
  {cns3_to_big5, sizeof(cns3_to_big5) / sizeof(cns3_to_big5[0])},
#endif
#ifdef CNS4_TO_BIG5
  {cns4_to_big5, sizeof(cns4_to_big5) / sizeof(cns4_to_big5[0])},
#endif
#ifdef CNS5_TO_BIG5
  {cns5_to_big5, sizeof(cns5_to_big5) / sizeof(cns5_to_big5[0])},
#endif
#ifdef CNS6_TO_BIG5
  {cns6_to_big5, sizeof(cns6_to_big5) / sizeof(cns6_to_big5[0])},
#endif
#ifdef CNS7_TO_BIG5
  {cns7_to_big5, sizeof(cns7_to_big5) / sizeof(cns7_to_big5[0])},
#endif
};

void
mb_conv_cn_big5(mb_char_t *ch, mb_info_t *info)
{
  int c1 = ch->c / 0x60;
  int c2 = ch->c % 0x60;
  int c;
  struct cns_to_big5_st *tab;
  size_t b, e, i;

  switch (ch->set) {
  case mb_94x94:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x47 & MB_ESC_FC_MASK:
    case 0x48 & MB_ESC_FC_MASK:
    case 0x49 & MB_ESC_FC_MASK:
    case 0x4A & MB_ESC_FC_MASK:
    case 0x4B & MB_ESC_FC_MASK:
    case 0x4C & MB_ESC_FC_MASK:
    case 0x4D & MB_ESC_FC_MASK:
      if (c1 < 0x21 - 0x20 || c1 > 0x7E - 0x20 || c2 < 0x21 - 0x20 || c2 > 0x7E - 0x20)
	break;

      c = ((c1 + 0x20) << 8) | (c2 + 0x20);
      tab = cns_to_big5[(ch->fc & MB_ESC_FC_MASK) - (0x47 & MB_ESC_FC_MASK)].tab;
      e = cns_to_big5[(ch->fc & MB_ESC_FC_MASK) - (0x47 & MB_ESC_FC_MASK)].n;

      for (b = 0 ; b < e ;) {
	i = (b + e) / 2;

	if (c < tab[i].cns_beg)
	  e = i;
	else if (c > tab[i].cns_end)
	  b = i + 1;
	else {
	  c = ((c1 - (0x21 - 0x20)) * 0x5E + (c2 - (0x21 - 0x20))
	       - ((((tab[i].cns_beg >> 8) & 0xFF) - 0x21) * 0x5E + (tab[i].cns_beg & 0xFF) - 0x21)
	       + ((((tab[i].big5_beg >> 8) & 0xFF) - 0xA1) * (0x7E - 0x40 + 1 + 0xFE - 0xA1 + 1)
		  + ((tab[i].big5_beg & 0xFF) >= 0xA1 ?
		     (tab[i].big5_beg & 0xFF) - 0xA1 + 0x7F - 0x40 :
		     (tab[i].big5_beg & 0xFF) - 0x40)));

	  c1 = c / (0x7E - 0x40 + 1 + 0xFE - 0xA1 + 1) + 0xA1;
	  c2 = c % (0x7E - 0x40 + 1 + 0xFE - 0xA1 + 1) + 0x40;

	  if (c2 <= 0x7E) {
	    ch->c = (c1 - 0xA0) * 0x60 + c2 - 0x20;
	    ch->fc = MB_BIG5L_FC;
	  }
	  else {
	    ch->c = (c1 - 0xA0) * 0x60 + c2 - 0x7F + 0xA1 - 0xA0;
	    ch->fc = MB_BIG5R_FC;
	  }

	  ch->set = mb_128;
	  ch->gn = mb_G1;
	  ch->sn = mb_SR;
	  break;
	}
      }
    default:
      break;
    }

    break;
  case mb_94_0:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x42 & MB_ESC_FC_MASK:
      ch->gn = mb_G0;
      ch->sn = mb_SL;
      break;
    }
  default:
    break;
  }
}

void
mb_cs_judge_gb2312(mb_cs_detector_stat_t *p, const char *bag, size_t e)
{
  size_t i;
  int c;

  for (i = p->processed ; i < e ;)
    if ((c = (unsigned char)bag[i++]) & 0x80) {
      if (c >= 0xA1 && c <= 0xFE) {
	if (i < e) {
	  if ((unsigned char)bag[i] >= 0xA1 && (unsigned char)bag[i] <= 0xFE) {
	    switch (c * 0x100 + (unsigned char)bag[i]) {
	    case 0xB5C4: /* Ū */
	    case 0xCAC7: /*  */
	    case 0xD2B2: /*  */
	    case 0xD4DA: /*  */
	      p->by_char += 10;
	    default:
	      break;
	    }

	    p->by_char += 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  goto end_euc;
	}
      }
      else
	p->by_encode -= 1;
    }
end_euc:
  p->processed = i;
}

void
mb_cs_judge_big5(mb_cs_detector_stat_t *p, const char *bag, size_t e)
{
  size_t i;
  int c, cc;

  for (i = p->processed ; i < e ;)
    if ((c = (unsigned char)bag[i++]) & 0x80) {
      if (c >= 0xA1 && c <= 0xFE) {
	if (i < e) {
	  if (((cc = (unsigned char)bag[i]) >= 0x40 && cc <= 0x7E) ||
	      (cc >= 0xA1 && cc <= 0xFE)) {
	    switch (c * 0x100 + cc) {
	    case 0xAABA: /* Ū */
	    case 0xAC4F: /*  */
	    case 0xA662: /*  */
	    case 0xA45D: /*  */
	      p->by_char += 10;
	    default:
	      break;
	    }

	    p->by_char += cc <= 0x7E ? 1 : 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  break;
	}
      }
      else
	p->by_encode -= 1;
    }

  p->processed = i;
}

void
mb_cs_judge_euc_tw(mb_cs_detector_stat_t *p, const char *bag, size_t e)
{
  size_t i;
  int c;

  for (i = p->processed ; i < e ;)
    if ((c = (unsigned char)bag[i++]) & 0x80) {
      if (c >= 0xA1 && c <= 0xFE) {
	if (i < e) {
	  if ((unsigned char)bag[i] >= 0xA1 && (unsigned char)bag[i] <= 0xFE) {
	    switch (c * 0x100 + (unsigned char)bag[i]) {
	    case 0xC4BE: /*  */
	    case 0xC7E3: /*  */
	    case 0xCEFB: /* Ū */
	    case 0xD1D2: /*  */
	      p->by_char += 10;
	    default:
	      break;
	    }

	    p->by_char += 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  goto end_euctw;
	}
      }
      else if (c == 0x8E)
	switch (e - i) {
	case 0:
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  goto end_euctw;
	case 1:
	  if ((unsigned char)bag[i] >= 0xA1 && (unsigned char)bag[i] <= 0xB0) {
	    if (--i <= p->processed) {
	      p->by_encode -= 1;
	      ++i;
	    }
	  }
	  else
	    p->by_encode -= 1;

	  goto end_euctw;
	case 2:
	  if ((unsigned char)bag[i] >= 0xA1 && (unsigned char)bag[i] <= 0xB0 &&
	      (unsigned char)bag[i + 1] >= 0xA1 && (unsigned char)bag[i + 1] <= 0xFE) {
	    if (--i <= p->processed) {
	      p->by_encode -= 1;
	      ++i;
	    }
	  }
	  else
	    p->by_encode -= 1;

	  goto end_euctw;
	default:
	  if ((unsigned char)bag[i] >= 0xA1 && (unsigned char)bag[i] <= 0xB0 &&
	      (unsigned char)bag[i + 1] >= 0xA1 && (unsigned char)bag[i + 1] <= 0xFE &&
	      (unsigned char)bag[i + 2] >= 0xA1 && (unsigned char)bag[i + 2] <= 0xFE) {
	    if ((unsigned char)bag[i] == 0xA1)
	      switch ((unsigned char)bag[i + 1] * 0x100 + (unsigned char)bag[i + 2]) {
	      case 0xC4BE: /*  */
	      case 0xC7E3: /*  */
	      case 0xCEFB: /* Ū */
	      case 0xD1D2: /*  */
		p->by_char += 10;
	      default:
		break;
	      }

	    p->by_char += 4;
	    i += 3;
	  }
	  else
	    p->by_encode -= 1;
	}
      else
	p->by_encode -= 1;
    }
end_euctw:
  p->processed = i;
}

size_t
mb_cs_judge_cn(mb_cs_detector_t *p)
{
  mb_cs_judge_gb2312(&p->stat[mb_cs_detect_cn_EUC], p->bag, p->end);
  mb_cs_judge_big5(&p->stat[mb_cs_detect_cn_BIG5], p->bag, p->end);
  mb_cs_judge_utf8(&p->stat[mb_cs_detect_cn_UTF8], p->bag, p->end);
  mb_cs_judge_euc_tw(&p->stat[mb_cs_detect_cn_EUCTW], p->bag, p->end);
  return MB_CS_DETECT_CHOICEMAX;
}

char *
mb_cs_setup_cn(mb_cs_detector_t *p, size_t i, size_t same)
{
  char *cs = p->private;

  if ((p->stat[i].by_encode || p->stat[i].by_char) && (!same || !cs))
    switch (i) {
    case mb_cs_detect_cn_EUC:
      cs = "cn-gb";
      break;
    case mb_cs_detect_cn_BIG5:
      cs = "cn-big5";
      break;
    case mb_cs_detect_cn_UTF8:
      cs = "utf-8";
      break;
    case mb_cs_detect_cn_EUCTW:
      cs = "x-euc-tw";
    default:
      break;
    }

  mb_charset_to_esc(cs, p->orig);
  return cs;
}

#ifdef USE_UCS

void
mb_conv_ucs_to_big5(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128 && (ch->fc & MB_ESC_FC_MASK) == (0x47 & MB_ESC_FC_MASK)) {
    int *pool = mb_ucs_to_isov(ch->c);

    if (pool) {
      int *p;

      for (p = pool ;; ++p) {
	switch (MB_WORD_DEC_ESC(*p)) {
	case MB_ESC_ENC(mb_128, MB_BIG5L_FC):
	case MB_ESC_ENC(mb_128, MB_BIG5R_FC):
	  ch->c = MB_WORD_DEC_C(*p);
	  ch->set = mb_128;
	  ch->fc = MB_WORD_DEC_FC(*p);
	  ch->gn = mb_G1;
	  ch->sn = mb_SR;
	  return;
	default:
	  break;
	}

	if (MB_U2I_ISLAST(*p))
	  return;
      }
    }
  }
}

void
mb_conv_ucs_to_cn(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128 && (ch->fc & MB_ESC_FC_MASK) == (0x47 & MB_ESC_FC_MASK)) {
    int *pool = mb_ucs_to_isov(ch->c);

    if (pool) {
      int *p;

      for (p = pool ;; ++p) {
	switch (MB_WORD_DEC_ESC(*p)) {
	case MB_ESC_ENC(mb_94x94, 0x47):
	case MB_ESC_ENC(mb_94x94, 0x48):
	case MB_ESC_ENC(mb_94x94, 0x49):
	case MB_ESC_ENC(mb_94x94, 0x4A):
	case MB_ESC_ENC(mb_94x94, 0x4B):
	case MB_ESC_ENC(mb_94x94, 0x4C):
	case MB_ESC_ENC(mb_94x94, 0x4D):
	  ch->c = MB_WORD_DEC_C(*p);
	  ch->set = mb_94x94;
	  ch->fc = MB_WORD_DEC_FC(*p);
	  ch->gn = mb_G0;
	  ch->sn = mb_SL;
	  return;
	default:
	  break;
	}

	if (MB_U2I_ISLAST(*p))
	  for (p = pool ;; ++p) {
	    switch (MB_WORD_DEC_ESC(*p)) {
	    case MB_ESC_ENC(mb_94x94, 0x45):
	    case MB_ESC_ENC(mb_94x94, 0x41):
	      ch->c = MB_WORD_DEC_C(*p);
	      ch->set = mb_94x94;
	      ch->fc = MB_WORD_DEC_FC(*p);
	      ch->gn = mb_G0;
	      ch->sn = mb_SL;
	      return;
	    default:
	      break;
	    }

	    if (MB_U2I_ISLAST(*p)) {
	      mb_ucs_to_isoc(pool, ch);
	      return;
	    }
	  }
      }
    }
  }
}

void
mb_conv_ucs_to_gb(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128 && (ch->fc & MB_ESC_FC_MASK) == (0x47 & MB_ESC_FC_MASK)) {
    int *pool = mb_ucs_to_isov(ch->c);

    if (pool) {
      int *p;

      for (p = pool ;; ++p) {
	switch (MB_WORD_DEC_ESC(*p)) {
	case MB_ESC_ENC(mb_94x94, 0x41):
	  ch->c = MB_WORD_DEC_C(*p);
	  ch->set = mb_94x94;
	  ch->fc = 0x41;
	  ch->gn = mb_G0;
	  ch->sn = mb_SL;
	  return;
	default:
	  break;
	}

	if (MB_U2I_ISLAST(*p))
	  for (p = pool ;; ++p) {
	    switch (MB_WORD_DEC_ESC(*p)) {
	    case MB_ESC_ENC(mb_94x94, 0x45):
	    case MB_ESC_ENC(mb_94x94, 0x47):
	    case MB_ESC_ENC(mb_94x94, 0x48):
	    case MB_ESC_ENC(mb_94x94, 0x49):
	    case MB_ESC_ENC(mb_94x94, 0x4A):
	    case MB_ESC_ENC(mb_94x94, 0x4B):
	    case MB_ESC_ENC(mb_94x94, 0x4C):
	    case MB_ESC_ENC(mb_94x94, 0x4D):
	      ch->c = MB_WORD_DEC_C(*p);
	      ch->set = mb_94x94;
	      ch->fc = MB_WORD_DEC_FC(*p);
	      ch->gn = mb_G0;
	      ch->sn = mb_SL;
	      return;
	    default:
	      break;
	    }

	    if (MB_U2I_ISLAST(*p)) {
	      mb_ucs_to_isoc(pool, ch);
	      return;
	    }
	  }
      }
    }
  }
}

void
mb_conv_ucs_to_gb_isoir165(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128 && (ch->fc & MB_ESC_FC_MASK) == (0x47 & MB_ESC_FC_MASK)) {
    int *pool = mb_ucs_to_isov(ch->c);

    if (pool) {
      int *p;

      for (p = pool ;; ++p) {
	switch (MB_WORD_DEC_ESC(*p)) {
	case MB_ESC_ENC(mb_94x94, 0x45):
	  ch->c = MB_WORD_DEC_C(*p);
	  ch->set = mb_94x94;
	  ch->fc = 0x45;
	  ch->gn = mb_G0;
	  ch->sn = mb_SL;
	  return;
	default:
	  break;
	}

	if (MB_U2I_ISLAST(*p))
	  for (p = pool ;; ++p) {
	    switch (MB_WORD_DEC_ESC(*p)) {
	    case MB_ESC_ENC(mb_94x94, 0x47):
	    case MB_ESC_ENC(mb_94x94, 0x48):
	    case MB_ESC_ENC(mb_94x94, 0x49):
	    case MB_ESC_ENC(mb_94x94, 0x4A):
	    case MB_ESC_ENC(mb_94x94, 0x4B):
	    case MB_ESC_ENC(mb_94x94, 0x4C):
	    case MB_ESC_ENC(mb_94x94, 0x4D):
	    case MB_ESC_ENC(mb_94x94, 0x41):
	      ch->c = MB_WORD_DEC_C(*p);
	      ch->set = mb_94x94;
	      ch->fc = MB_WORD_DEC_FC(*p);
	      ch->gn = mb_G0;
	      ch->sn = mb_SL;
	      return;
	    default:
	      break;
	    }

	    if (MB_U2I_ISLAST(*p)) {
	      mb_ucs_to_isoc(pool, ch);
	      return;
	    }
	  }
      }
    }
  }
}

#endif
