/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*-----------------------------------------------------------------------------
   libgpiv - library for Particle Image Velocimetry

   Copyright (C) 2002, 2003, 2004 Gerber van der Graaf

   This file is part of libgpiv.

   Libgpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  




-------------------------------------------------------------------------------
FILENAME:                back_intface.h
LIBRARY:                 libgpiv
EXTERNAL FUNCTIONS:      
			 
LAST MODIFICATION DATE:  $Id: back_intface.h,v 1.6 2005/01/19 10:13:14 gerber Exp $
 --------------------------------------------------------------------------- */

#ifndef __GPIV_BACKINTERFACE_H__
#define __GPIV_BACKINTERFACE_H__

/*-----------------------------------------------------------------------------
 * Defines for backward compatiblity of the library interface
 */


/*
 * gpiv general
 */
#define SYSTEM_RSC_FILE GPIV_SYSTEM_RSC_FILE
#define HOME_RSC_FILE GPIV_HOME_RSC_FILE
#ifndef MAX_CHARS
#define MAX_CHARS GPIV_MAX_CHARS
#endif
#define MAX_LINES GPIV_MAX_LINES
#define MAX_LINES_C GPIV_MAX_LINES_C
#define MAX_IMG_SIZE GPIV_MAX_IMG_SIZE 
#define MAX_IMG_DEPTH GPIV_MAX_IMG_DEPTH 
#define MIN_INTERR_SIZE GPIV_MIN_INTERR_SIZE 
#define MAX_INTERR_SIZE GPIV_MAX_INTERR_SIZE 
#define NBINS_MAX GPIV_NBINS_MAX
#define NBINS_DEFAULT GPIV_NBINS_DEFAULT
#define SNR_NAN GPIV_SNR_NAN

typedef GpivPivData PivData;
typedef GpivScalarData ScalarData;
typedef GpivBinData BinData;
typedef GpivLinRegData LinRegData;

/*
 * dac
 */
#define TIMING_PARAMETER_FIFO GPIV_FIFO_TIMING_PARAMETER
#define START_COMMAND_FIFO GPIV_FIFO_START_COMMAND
#define STOP_COMMAND_FIFO GPIV_FIFO_STOP_COMMAND
#define ERROR_FIFO GPIV_FIFO_ERROR
#define JITTER_FIFO GPIV_FIFO_JITTER

#define PERIODIC GPIV_TIMING_PERIODIC
#define DURATION GPIV_TIMING_DURATION
#define ONE_SHOT_IRQ GPIV_TIMING_ONE_SHOT_IRQ
#define TRIGGER_IRQ GPIV_TIMING_TRIGGER_IRQ
#define INCREMENT GPIV_TIMING_INCREMENT
#define DOUBLE GPIV_TIMING_DOUBLE
#define SNAPSHOT GPIV_TIMING_SNAPSHOT
#define EXIT GPIV_TIMING_EXIT
/*
 * img
 */
typedef GpivImagePar ImagePar;
 
/*
 * img_proc 
 */
#define FILTER_BLOCK GPIV_FILTER_BLOCK
#define PASS_BLOCK GPIV_PASS_BLOCK
#define ADD_XY GPIV_ADD_XY
#define Roi GpivRoi

#define imgproc_operation GpivImgprocOperation
#define MK_TSTIMG GPIV_MK_TSTIMG
#define FI_SMOOTH  GPIV_FI_SMOOTH 
#define FI_HILO GPIV_FI_HILO
#define FI_CLIP GPIV_FI_CLIP
#define FI_FFT GPIV_FI_FFT
#define FI_INVFFT GPIV_FI_INVFFT
#define FI_CORR GPIV_FI_CORR 
#define FI_CONV GPIV_FI_CONV
#define FI_LOWPASS GPIV_FI_LOWPASS
#define FI_HIGHPASS GPIV_FI_HIGHPASS

#define PT_GETBIT GPIV_PT_GETBIT
#define filter_operator GpivFilterOperator
#define EQUAL GPIV_EQUAL
#define SUBTRACT GPIV_SUBTRACT
#define ADD GPIV_ADD
#define MULTIPLY GPIV_MULTIPLY
#define DIVIDE GPIV_DIVIDE

#define BIT_DEFAULT GPIV_BIT_DEFAULT 
#define DIR_PREFIX_DEFAULT GPIV_DIR_PREFIX_DEFAULT 
#define FILTER_DEFAULT GPIV_FILTER_DEFAULT 
#define FIRST_DIR_DEFAULT GPIV_FIRST_DIR_DEFAULT 
#define LAST_DIR_DEFAULT GPIV_LAST_DIR_DEFAULT 
#define FIRST_FILE_DEFAULT GPIV_FIRST_FILE_DEFAULT 
#define LAST_FILE_DEFAULT GPIV_LAST_FILE_DEFAULT 
#define FILE_PREFIX_DEFAULT GPIV_FILE_PREFIX_DEFAULT 
#define OPERATOR_DEFAULT GPIV_OPERATOR_DEFAULT 
#define THRESHOLD_IMGPROC_DEFAULT GPIV_THRESHOLD_IMGPROC_DEFAULT 
#define WINDOW_DEFAULT GPIV_WINDOW_DEFAULT 

typedef GpivImageProcPar ImageProcPar;

/*
 * eval
 */
#define IFit GpivIFit
#define NONE GPIV_NONE
#define GAUSS GPIV_GAUSS
#define POWER GPIV_POWER
#define GRAVITY GPIV_GRAVITY

#define IntType GpivIntType
#define AOI GPIV_AOI
#define LINE_C GPIV_LINE_C
#define LINE_R GPIV_LINE_R
#define POINT GPIV_POINT

#define ImgIntAr GpivImgIntAr
#define NONE GPIV_NONE
#define LK_WEIGHT GPIV_LK_WEIGHT
#define ZERO_OFF_FORWARD GPIV_ZERO_OFF_FORWARD
#define ZERO_OFF_CENTRAL GPIV_ZERO_OFF_CENTRAL
#define IMG_DEFORM GPIV_IMG_DEFORM

#define MAX_EVAL_SWEEP GPIV_MAX_EVAL_SWEEP
#define ZEROPAD_FACT GPIV_ZEROPAD_FACT
#define DIFF_ISI GPIV_DIFF_ISI
#define SNR_DISABLE GPIV_SNR_DISABLE

#define AUTOKEY_DEFAULT GPIV_EVALPAR_AUTOKEY_DEFAULT
#define INT_GEO_DEFAULT GPIV_EVALPAR_INT_GEO_DEFAULT
#define COL_START_DEFAULT GPIV_EVALPAR_COL_START_DEFAULT
#define COL_END_DEFAUL GPIV_EVALPAR_COL_END_DEFAULT
#define ROW_START_DEFAULT GPIV_EVALPAR_ROW_START_DEFAULT
#define ROW_END_DEFAULT GPIV_EVALPAR_ROW_END_DEFAULT 
#define INT_LINE_ROW_START_DEFAULT GPIV_EVALPAR_INT_LINE_ROW_START_DEFAULT
#define INT_LINE_ROW_END_DEFAULT GPIV_EVALPAR_INT_LINE_ROW_END_DEFAULT 
#define INT_LINE_COL_START_DEFAULT GPIV_EVALPAR_INT_LINE_COL_START_DEFAULT
#define INT_LINE_COL_END_DEFAULT GPIV_EVALPAR_INT_LINE_COL_END_DEFAULT
#define INT_POINT_COL_DEFAULT GPIV_EVALPAR_INT_POINT_COL_DEFAULT
#define INT_POINT_ROW_DEFAULT GPIV_EVALPAR_INT_POINT_ROW_DEFAULT
#define CMPR_DEFAULT GPIV_EVALPAR_CMPR_DEFAULT
#define INT_SIZE_1_DEFAULT GPIV_EVALPAR_INT_SIZE_1_DEFAULT
#define INT_SIZE_2_DEFAULT GPIV_EVALPAR_INT_SIZE_2_DEFAULT
#define INT_SHIFT_DEFAULT GPIV_EVALPAR_INT_SHIFT_DEFAULT
#define PRE_SHIFT_COL_DEFAULT GPIV_EVALPAR_PRE_SHIFT_COL_DEFAULT
#define PRE_SHIFT_ROW_DEFAULT GPIV_EVALPAR_PRE_SHIFT_ROW_DEFAULT
#define AD_INT_DEFAULT GPIV_EVALPAR_AD_INT_DEFAULT
#define IFIT_DEFAULT GPIV_EVALPAR_IFIT_DEFAULT
#define WEIGHT_DEFAULT GPIV_EVALPAR_WEIGHT_DEFAULT
#define PEAK_DEFAULT GPIV_EVALPAR_PEAK_DEFAULT
#define ERO_OFF_DEFAULT GPIV_EVALPAR_ZERO_OFF_DEFAULT
#define CENTRAL_DIFF_DEFAULT GPIV_EVALPAR_CENTRAL_DIFF_DEFAULT
#define PIV_DEFAULT GPIV_EVALPAR_OLD_PIV_DEFAULT

typedef GpivEvalPar PivEvalPar;

/*
 * valid
 */
#define GRADIENT_THRESHOLD GPIV_GRADIENT_THRESHOLD 
#define THRESHOLD_DEFAULT GPIV_THRESHOLD_DEFAULT
 
#define AUTO_THRESH_DEFAULT GPIV_VALIDPAR_AUTO_THRESH_DEFAULT 
#define DATA_YIELD_DEFAULT GPIV_VALIDPAR_DATA_YIELD_DEFAULT 
#define RESIDU_MAX_DEFAULT GPIV_VALIDPAR_RESIDU_MAX_DEFAULT 
#define RES_STATS_DEFAULT GPIV_VALIDPAR_RES_STATS_DEFAULT 
#define RESIDU_TYPE_DEFAULT GPIV_VALIDPAR_RESIDU_TYPE_DEFAULT 
#define SUBST_TYPE_DEFAULT GPIV_VALIDPAR_SUBST_TYPE_DEFAULT 
#define HISTO_TYPE_DEFAULT GPIV_VALIDPAR_HISTO_TYPE_DEFAULT 

typedef GpivValidPar PivValidPar;

/*
 * post
 */
#define differentiation GpivDifferentiation
#define CENTRAL GPIV_CENTRAL
#define LEAST_SQUARES GPIV_LEAST_SQUARES
#define RICHARDSON GPIV_RICHARDSON
#define CIRCULATION GPIV_CIRCULATION

#define operation GpivOperation
#define VORTICITY GPIV_VORTICITY
#define S_STRAIN GPIV_S_STRAIN
#define N_STRAIN GPIV_N_STRAIN

#define operation_manipiv GpivOperationManipiv
#define FAST_Y GPIV_FAST_Y
#define FLIP_X GPIV_FLIP_X
#define FLIP_Y GPIV_FLIP_Y
#define REVERT GPIV_REVERT
#define ROT90 GPIV_ROT90
#define ROT180 GPIV_ROT180

#define OPERATOR_MANIPIV_DEFAULT GPIV_GPIVPOSTPAR_OPERATOR_MANIPIV_DEFAULT
#define SET_DEFAULT GPIV_GPIVPOSTPAR_SET_DEFAULT 
#define SET_DX_DEFAULT GPIV_GPIVPOSTPAR_SET_DX_DEFAULT 
#define SET_DY_DEFAULT GPIV_GPIVPOSTPAR_SET_DY_DEFAULT 
#define SUBTRACT_DEFAULT GPIV_GPIVPOSTPAR_SUBTRACT_DEFAULT 
#define Z_OFF_DX_DEFAULT GPIV_GPIVPOSTPAR_Z_OFF_DX_DEFAULT 
#define Z_OFF_DY_DEFAULT GPIV_GPIVPOSTPAR_Z_OFF_DY_DEFAULT 
#define DIFF_TYPE_DEFAULT GPIV_GPIVPOSTPAR_DIFF_TYPE_DEFAULT 
#define OPERATOR_VORSTRA_DEFAULT GPIV_GPIVPOSTPAR_OPERATOR_VORSTRA_DEFAULT

typedef GpivPostPar PivPostPar;

/*
 * io
 */
#define DataFormat GpivDataFormat
#define RR GPIV_RR
#define DAV GPIV_DAV

#define ASCII_IMG_FMT GPIV_ASCII_IMG_FMT 
#define PIV_FMT GPIV_PIV_FMT 
#define PIV_S_FMT GPIV_PIV_S_FMT 
#define SCALAR_FMT GPIV_SCALAR_FMT 
#define SCALAR_S_FMT GPIV_SCALAR_S_FMT 

#define EXT_HEADER GPIV_EXT_HEADER 
#define EXT_RAW_IMAGE GPIV_EXT_RAW_IMAGE 
#define EXT_RAW_IMAGE_PROC GPIV_EXT_RAW_IMAGE_PROC 
#define EXT_ASCII_IMAGE GPIV_EXT_ASCII_IMAGE 
#define EXT_PAR GPIV_EXT_PAR 

#define EXT_TA GPIV_EXT_TA 
#define EXT_SUBSTR GPIV_EXT_SUBSTR 

#define EXT_GPIV GPIV_EXT_GPIV 
#define EXT_PIV  GPIV_EXT_PIV  
#define EXT_DAVIS GPIV_EXT_DAVIS 
#define EXT_COV_OUT GPIV_EXT_COV_OUT 
#define EXT_INT GPIV_EXT_INT 
#define EXT_OLD GPIV_EXT_OLD 

#define EXT_ERR_PIV GPIV_EXT_ERR_PIV 
#define EXT_ERR_STAT GPIV_EXT_ERR_STAT
#define EXT_PLK  GPIV_EXT_PLK  

#define EXT_VOR GPIV_EXT_VOR 
#define EXT_NSTR GPIV_EXT_NSTR 
#define EXT_SSTR GPIV_EXT_SSTR 
#define EXT_MANI GPIV_EXT_MANI 
#define EXT_SA GPIV_EXT_SA 
#define EXT_SC GPIV_EXT_SC 

#define IMAGE_PAR_KEY GPIV_IMAGE_PAR_KEY 
#define IMAGEPROC_PAR_KEY GPIV_IMAGEPROC_PAR_KEY 
#define EVAL_PAR_KEY GPIV_EVAL_PAR_KEY 
#define VALID_PAR_KEY GPIV_VALID_PAR_KEY 
#define POST_PAR_KEY GPIV_POST_PAR_KEY 

#define DAVIS_IMG_DEPTH GPIV_DAVIS_IMG_DEPTH



#endif /* __GPIV_BACKINTERFACE_H__ */
