/**
 * @file test.c libgnurdf test application
 *
 * $Id: test.c,v 1.10 2001/07/28 08:39:50 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <gnurdf.h>

int
main(int argc, char **argv)
{
	RdfSchema      *rdf;
	RdfDescription *description;
	RdfElement     *element;
	char           *about, *value;
	char           *filename;

	if (argc < 2)
	{
		printf("You must pass a filename containing RDF metadata!\n");
		return 1;
	}

	filename = argv[1];
	
	printf("Loading %s...\n", filename);
	rdf = rdfReadFile(filename);
	
	if (rdf == NULL)
	{
		printf("Unable to load %s!\n", filename);
		return 1;
	}
	
	printf("Looping through descriptions:\n");
	for (description = rdfFirstDescription(rdf);
		 description != NULL;
		 description = rdfNextDescription(description))
	{
		about = rdfGetDescriptionAbout(description);
		
		printf("\tAbout: %s\n", about);

		free(about);

		for (element = rdfFirstProperty(description);
			 element != NULL;
			 element = rdfNextProperty(element))
		{
			value = rdfGetElementValue(element);

			printf("\t\tName:      %s\n", rdfGetElementPropertyName(element));
			printf("\t\tValue:     %s\n", value);
			printf("\t\tNamespace: %s\n\n",
				   rdfGetNamespaceURI(rdfGetElementNamespace(element)));

			free(value);
		}
	}
	
	printf("Destroying schema...\n");
	rdfDestroySchema(rdf);

	rdfCleanupParser();

	printf("Done.\n");
	return 0;
}
