/*******************************************************************************************************************************************
 cmetamoduleimporter.h

 Explicit import of metamodules defined in dynamic linked libraries. The imported definition should derive from CMetaModule and declare
 the DECLARE_METAMODULE_EXPORT macro.

 The application kernel should be compiled as follow :
 	c++ -rdynamic -o exe f1.o f2.o fn.o -ldl

 The application kernel should resolve the cmetaclass.c code section. The modules should not include this code resolution as there must be
 one and only one static metaclasses list in the whole binary target !!!

*******************************************************************************************************************************************/

#ifndef __CMETAMODULEIMPORTER_H__
#define __CMETAMODULEIMPORTER_H__

#include "cmetamodule.h"
#include "cexception.h"

#include <dlfcn.h>
#include <ftw.h>

//------------------------------------------------------------------------------------------------------------------------------------------
// potential exception codes
//------------------------------------------------------------------------------------------------------------------------------------------
DECLARE_EXCEPTION (NOEXPORT, 	3L);	// le point d'entre du module n'est pas dfini
DECLARE_EXCEPTION (NULLEXPORT,	4L);	// le module exporte une API nulle
DECLARE_EXCEPTION (BADEXPORT,	5L);	// le module exporte une API non drive de celle requise par l'importeur

// metamodules list definition
typedef NServices::TBuffer <CMetaModule *> CMetaModules;

//------------------------------------------------------------------------------------------------------------------------------------------
// CMetaModuleImporter class
//------------------------------------------------------------------------------------------------------------------------------------------
class CMetaModuleImporter : public CClass
{
	// instanciation section
	public :

		CMetaModuleImporter 		(const CString &inLibraryPath, 
						 const CMetaClass *inRequestedAPI=__metaclass(CMetaModule)) THROWABLE;
		virtual ~CMetaModuleImporter 	();

	// general importer functions
	public :

		// library handle, its name
		void *				GetLibHandle		() const;
		CString				GetLibName		() const;

	// loaded module access
	public :

		// loaded module metaclass access; do not instanciate the module via the returned metaclass attributes, prefer using
		// the CMetaModuleImporter defined functions to ensure a correct resource freeing when done with it
		const CMetaClass *		GetModuleMetaClass	() const;

		// instanciate the imported metamodule
		CMetaModule *			InstanciateModule	();

		// delete the specified metamodule instance
		void				DeleteModule		(CMetaModule *&);

	// static function
	public :

		// potential librarie names of the specified path
		static CStrings			GetLibNames		(const CString &inPath);

	// protected section
	protected :

		// the loaded library name, its handle and the associated metaclass
		CString				m_LibName;
		void *				m_LibHandle;
		/*const*/ CMetaClass *		m_LibMetaClass;

		// the module instances
		CMetaModules			m_LibMetaModules;
		
		// public capsule description
		SECTION_CAPSULE_METACLASS;
};

//------------------------------------------------------------------------------------------------------------------------------------------
// class tag and metaclass description
//------------------------------------------------------------------------------------------------------------------------------------------
DECLARE_CAPSULE_METACLASS ('mtmi', CMetaModuleImporter, CClass);

#endif
