/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Host.hh,v 1.3 2001/12/19 12:46:34 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef __HOST_HH_FLAG__
#define __HOST_HH_FLAG__

#include <vector>

#include <fwbuilder/FWObject.hh>
#include <fwbuilder/Interface.hh>
#include <fwbuilder/FWOptions.hh>

namespace libfwbuilder
{

class Host : public FWObject 
{
    protected:

    public:

    Host();
    virtual ~Host();

    virtual void fromXML(xmlNodePtr parent);
    virtual xmlNodePtr toXML      (xmlNodePtr parent);


    DECLARE_FWOBJECT_SUBTYPE(Host);

    /*
     * verify whether given object type is approppriate as a child
     */
    virtual bool    validateChild(FWObject *o);

    bool Appropriate(Interface *i);
    void addInterface(Interface *i);
    void removeInterface(Interface *i);

    /**
     *  This method sets default values to the platform-specific
     *  host parameters. It makes changes only to those parameters
     *  which are not defined yet; this makes it safe to call this
     *  method often, for example every time user changes host
     *  platform in the dialog.  Since this method would not reset
     *  those parameters which have already been set, user won't lose
     *  parameters values switching to another platform and then back
     *  again.
     */
    virtual void    setDefaults();

    /**
     *  This method returns reference to the object representing
     *  host's platform-specific options (class HostOptions)
     */
    virtual FWOptions* getOptionsObject();

};

}

#endif
