/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Firewall.cc,v 1.3 2001/12/19 12:46:22 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <fwbuilder/FWObject.hh>
#include <fwbuilder/FWObjectReference.hh>
#include <fwbuilder/FWOptions.hh>

#include <fwbuilder/Firewall.hh>
#include <fwbuilder/Policy.hh>
#include <fwbuilder/NAT.hh>

#include <fwbuilder/XMLTools.hh>

using namespace std;
using namespace libfwbuilder;

const char *Firewall::TYPENAME={"Firewall"};

Firewall::Firewall()
{
    setStr("platform","");   // because it is #REQUIRED
}

Firewall::~Firewall()  {}

void Firewall::fromXML(xmlNodePtr root)
{
    const char *n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("platform")));
    assert(n!=NULL);
    setStr("platform", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("version")));
    if (n!=NULL) setStr("version", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("host_OS")));
    if (n!=NULL) setStr("host_OS", n);

    Host::fromXML(root);
}

xmlNodePtr Firewall::toXML(xmlNodePtr parent)
{
    xmlNodePtr me = FWObject::toXML(parent, false);
    FWObject *o;
    
    o=getFirstByType( NAT::TYPENAME );
    if (o) o->toXML(me);

    o=getFirstByType( Policy::TYPENAME );
    if (o) o->toXML(me);

    vector<FWObject*> ol;
    vector<FWObject*>::iterator j;

    ol=getByType( Interface::TYPENAME );
    for(j=ol.begin(); j!=ol.end(); ++j) 
	if ( (o=(*j))!=NULL )
	    o->toXML(me);

    o=getFirstByType( FirewallOptions::TYPENAME );
    if (o) o->toXML(me);

    return me;
}

FWOptions* Firewall::getOptionsObject()
{
    return FWOptions::cast( getFirstByType(FirewallOptions::TYPENAME) );
}


Policy* Firewall::getPolicy() 
{ 
    return(Policy::cast(getFirstByType(Policy::TYPENAME)));
}

NAT* Firewall::getNAT()    
{ 
    return(NAT::cast(getFirstByType(NAT::TYPENAME)));
}

void Firewall::setDefaults()
{
    FWOptions *fopt=getOptionsObject();

    if (!exists("version"))              setStr("version","");
    if (!exists("snmp_read_community"))  setStr("snmp_read_community" , "public" );
    if (!exists("snmp_write_community")) setStr("snmp_write_community", "private");


    if (getStr("platform")=="ipfilter") {
    }

    if (getStr("platform")=="iptables") {
	if (!fopt->exists("load_modules"))
	    fopt->setBool("load_modules" , true);

	if (!fopt->exists("firewall_is_part_of_any_and_networks"))
	    fopt->setBool("firewall_is_part_of_any_and_networks", true);

	if (!fopt->exists("accept_new_tcp_with_no_syn"))
	    fopt->setBool("accept_new_tcp_with_no_syn", true);

	if (!fopt->exists("accept_established"))
	    fopt->setBool("accept_established", true);

	if (!fopt->exists("manage_virtual_addr"))
	    fopt->setBool("manage_virtual_addr"   , true);

	if (!fopt->exists("log_level"))
	    fopt->setStr( "log_level"    , "info" );

	if (!fopt->exists("log_prefix"))
	    fopt->setStr( "log_prefix"   , "RULE %N -- %A " );

	if (!fopt->exists("limit_value"))
	    fopt->setInt( "limit_value"  , 0 );

    }

    if (getStr("platform")=="cisco") {

    }
}


bool  Firewall::validateChild(FWObject *o)
{ 
    string otype=o->getTypeName();
    return (FWObject::validateChild(o) && 
	    (otype==Interface::TYPENAME  ||
	     otype==Policy::TYPENAME     ||
	     otype==NAT::TYPENAME        ||
	     otype==FirewallOptions::TYPENAME ));
}

