#include <ept/cache/version.h>

#include <ept/tests/test-utils.h>
#include <ept/cache/apt/packages.h>

namespace tut {

using namespace ept;
using namespace configuration::apt;
using namespace cache;

struct cache_version_shar : common {};
TESTGRP( cache_version );

using namespace cache;

template<> template<>
void to::test<1> ()
{
    Package p = apt.index().packageByName( "exim4" );
    Version v = p.versions().head();
    ensure_equals( v.shortDescription(), "An MTA (Mail Transport Agent)" );
}

template<> template<>
void to::test<2> ()
{
    Package p = apt.index().packageByName( "mail-transport-agent" );
    wibble::Range< Version > l = p.versions();
    ensure_equals( p.name(), "mail-transport-agent" );
    ensure( !p.hasVersion() );
    ensure( l.empty() );
}

template<> template<>
void to::test<3> ()
{
    Package p = apt.index().packageByName( "exim4" );
    Package q = apt.index().packageByName( "exim4" );
    Package r = apt.index().packageByName( "exim" );
    Version v = p.versions().head();
    Version w = q.versions().head();
    Version x = r.versions().head();
    ensure( v == w );
    ensure( v != x );
}

// i don't get this test... it's daft or something?
template<> template<>
void to::test<4> ()
{
    Package p = apt.index().packageByName( "g77" );
    wibble::Range< Version > l = p.versions(),
                               v = l,
                               w = l, x = v, y = v;
    y = y.tail();
    w = w.tail();
    ensure( v.begin() != l.end() );
    ensure( w.begin() != l.end() );
    ensure( v.head() != w.head() );
    ensure( x.begin() != l.end() );
    ensure( w.head() != x.head() );
    ensure( y.begin() != l.end() );
    ensure( w.head() == y.head() );
}

template<> template<>
void to::test<5> ()
{
    Package p = apt.index().packageByName( "g77" );
    wibble::Range< Version > l = p.versions(),
                               v = l,
                               w = v;
    w = w.tail();
    ensure( v != w );
    ensure( v.begin() != l.end() );
    ensure( w.begin() != l.end() );
    ensure( v.head() != w.head() );
    v = v.tail();
    ensure( v == w );
    ensure( !v.empty() );
    ensure( !w.empty() );
    ensure( v.head() == w.head() );
}

template<> template<>
void to::test<6> ()
{
    Package p = apt.index().packageByName( "exim4" );
    Version v = p.versions().head();
    ensure( v.package() == p );
}

static void ensure_field ( std::string rec, std::string field, std::string expect ) {
    field += ": ";
    size_t p = rec.find( field );
    ensure( p != string::npos );
    std::string after = rec.substr( p + field.size(), std::string::npos );
    p = after.find( "\n" );
    ensure( p != string::npos );
    // std::cerr << field << after.substr( 0, p ) << std::endl;
    ensure_equals( after.substr( 0, p ), expect );
}

template<> template<>
void to::test<7> ()
// TODO: check for exact field values?
{
    Package pkg = apt.index().packageByName( "exim4" );
    string rec = pkg.anyVersion().completeRecord();

    ensure_field( rec, "Section", "mail" );
    ensure_field( rec, "Maintainer",
                  "Exim4 Maintainers <pkg-exim4-maintainers@lists.alioth.debian.org>" );
    ensure_field( rec, "Architecture", "all" );
    ensure_field( rec, "Version", "4.34-5" );
    ensure_field( rec, "Description", "An MTA (Mail Transport Agent)" );
    ensure_field( rec, "Installed-Size", "32K" );
    ensure_field( rec, "MD5Sum", "2d34984aff22458f8083f7fe21e391cc" );
    ensure_field( rec, "Filename", "pool/main/e/exim4/exim4_4.34-5_all.deb" );
}

template<> template<>
void to::test<8> ()
{
    Version v = apt.index().packageByName( "exim4" ).anyVersion();
    ensure_equals( v.installedSize(), 32768 );
    ensure_equals( v.installedSizeString(), "32K" );
    v = apt.index().packageByName( "exim4-base" ).anyVersion();
    ensure_equals( v.installedSize(), 1264 * 1024 );
    ensure_equals( v.installedSizeString(), "1264K" );
}

}

#include <ept/cache/apt/packages.tcc>
