/** -*- C++ -*-
   @file cache/relation.tcc
   @author Peter Rockai <me@mornfall.net>
*/

#include <ept/cache/relation.h>

#ifndef EPT_CACHE_RELATION_TCC
#define EPT_CACHE_RELATION_TCC
namespace ept {
namespace t {
namespace cache {

template< typename C >
typename Relation< C >::Type Relation< C >::type() const
{
    return static_cast< Type >( firstAtom().d->Type - 1 ); // XXX hack?
}

template< typename C >
std::string Relation< C >::typeString() const
{
    const char *t[] = { "required", "pre-required", "suggested", "recommended",
                        "conflict", "replaces", "obsoletes" };
    if ( type() < sizeof( t ) )
        return std::string( t[ type() ] );
    return std::string( "invalid" );
}

template< typename C >
std::string Relation< C >::format() const {
    return typeString() + ": " + name();
}

template< typename C >
std::string Relation< C >::name() const {
    std::string ret;
    Atom a = firstAtom();
    while ( a.valid() ) {
        ret += a.format();
        if ( a.next().valid() )
            ret += " or ";
        a = a.next();
    }
    return ret;
}

template< typename C >
std::string Relation< C >::Atom::format() const {
    std::string vs;
    switch ( compareOperator() & ~0x10 ) {
    case 0x1: vs += "<="; break;
    case 0x2: vs += ">="; break;
    case 0x3: vs += "<"; break;
    case 0x4: vs += ">"; break;
    case 0x5: vs += "="; break;
    case 0x6: vs += "!="; break;
    }
    if ( vs != "" ) vs = std::string( " " ) + vs + " " + targetVersionString();
    return name() + vs;
}

}
}
}

#endif
