/*******************************************************************************
 * vi:ts=4:sw=4
 *	original Ogasawara Hiroyuki (COR.)
 *  original Atsushi Nakamura
 ******************************************************************************/
#ifdef KANJI

#ifdef MSDOS
#include	<io.h>
#endif
#ifdef NT
# include <windows.h>
# undef DELETE
#endif
#include	"vim.h"
#include	"globals.h"
#include	"proto.h"
#include	"param.h"
#include	"ops.h"
#include	"kanji.h"
#include	"jptab.h"

#define	JP_EUC_G2		0x8e
#define	JP_EUC_G3		0x8f
#define IS_X0212(_c)	(((_c) & 0xf0) == 0xf0)

static int_u	euctosjis		__ARGS((char_u, char_u));
static int_u	euctosjis3		__ARGS((char_u, char_u));
static int_u	sjistoeuc		__ARGS((char_u, char_u, char_u *));
static int_u	sjistoeuc3		__ARGS((char_u, char_u, char_u *));
static char_u *	kanjiin			__ARGS((int));
static char_u *	asciiin			__ARGS((int));
static char_u *	kanain			__ARGS((int));
static char_u *	JPdisp			__ARGS((int *, int, int));
static int		jisx0201rto0208	__ARGS((char_u, char_u, char_u *, char_u *));

static char_u	kanji_map_sjis[]= {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0
};

static char_u	kanji_map_euc[]= {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0
};

static struct {
	char_u		sjis[2];
	char_u		alt[2];
} altconv[] = {
	{{0xFA, 0x40}, {0xEE, 0xEF}}, {{0xFA, 0x41}, {0xEE, 0xF0}},
	{{0xFA, 0x42}, {0xEE, 0xF1}}, {{0xFA, 0x43}, {0xEE, 0xF2}},
	{{0xFA, 0x44}, {0xEE, 0xF3}}, {{0xFA, 0x45}, {0xEE, 0xF4}},
	{{0xFA, 0x46}, {0xEE, 0xF5}}, {{0xFA, 0x47}, {0xEE, 0xF6}},
	{{0xFA, 0x48}, {0xEE, 0xF7}}, {{0xFA, 0x49}, {0xEE, 0xF8}},
	{{0xFA, 0x4A}, {0x87, 0x54}}, {{0xFA, 0x4B}, {0x87, 0x55}},
	{{0xFA, 0x4C}, {0x87, 0x56}}, {{0xFA, 0x4D}, {0x87, 0x57}},
	{{0xFA, 0x4E}, {0x87, 0x58}}, {{0xFA, 0x4F}, {0x87, 0x59}},
	{{0xFA, 0x50}, {0x87, 0x5A}}, {{0xFA, 0x51}, {0x87, 0x5B}},
	{{0xFA, 0x52}, {0x87, 0x5C}}, {{0xFA, 0x53}, {0x87, 0x5D}},
	{{0xFA, 0x54}, {0x81, 0xCA}}, {{0xFA, 0x55}, {0xEE, 0xFA}},
	{{0xFA, 0x56}, {0xEE, 0xFB}}, {{0xFA, 0x57}, {0xEE, 0xFC}},
	{{0xFA, 0x58}, {0x87, 0x8A}}, {{0xFA, 0x59}, {0x87, 0x82}},
	{{0xFA, 0x5A}, {0x87, 0x84}}, {{0xFA, 0x5B}, {0x81, 0xE6}},
	{{0xFA, 0x5C}, {0xED, 0x40}}, {{0xFA, 0x5D}, {0xED, 0x41}},
	{{0xFA, 0x5E}, {0xED, 0x42}}, {{0xFA, 0x5F}, {0xED, 0x43}},
	{{0xFA, 0x60}, {0xED, 0x44}}, {{0xFA, 0x61}, {0xED, 0x45}},
	{{0xFA, 0x62}, {0xED, 0x46}}, {{0xFA, 0x63}, {0xED, 0x47}},
	{{0xFA, 0x64}, {0xED, 0x48}}, {{0xFA, 0x65}, {0xED, 0x49}},
	{{0xFA, 0x66}, {0xED, 0x4A}}, {{0xFA, 0x67}, {0xED, 0x4B}},
	{{0xFA, 0x68}, {0xED, 0x4C}}, {{0xFA, 0x69}, {0xED, 0x4D}},
	{{0xFA, 0x6A}, {0xED, 0x4E}}, {{0xFA, 0x6B}, {0xED, 0x4F}},
	{{0xFA, 0x6C}, {0xED, 0x50}}, {{0xFA, 0x6D}, {0xED, 0x51}},
	{{0xFA, 0x6E}, {0xED, 0x52}}, {{0xFA, 0x6F}, {0xED, 0x53}},
	{{0xFA, 0x70}, {0xED, 0x54}}, {{0xFA, 0x71}, {0xED, 0x55}},
	{{0xFA, 0x72}, {0xED, 0x56}}, {{0xFA, 0x73}, {0xED, 0x57}},
	{{0xFA, 0x74}, {0xED, 0x58}}, {{0xFA, 0x75}, {0xED, 0x59}},
	{{0xFA, 0x76}, {0xED, 0x5A}}, {{0xFA, 0x77}, {0xED, 0x5B}},
	{{0xFA, 0x78}, {0xED, 0x5C}}, {{0xFA, 0x79}, {0xED, 0x5D}},
	{{0xFA, 0x7A}, {0xED, 0x5E}}, {{0xFA, 0x7B}, {0xED, 0x5F}},
	{{0xFA, 0x7C}, {0xED, 0x60}}, {{0xFA, 0x7D}, {0xED, 0x61}},
	{{0xFA, 0x7E}, {0xED, 0x62}}, {{0xFA, 0x80}, {0xED, 0x63}},
	{{0xFA, 0x81}, {0xED, 0x64}}, {{0xFA, 0x82}, {0xED, 0x65}},
	{{0xFA, 0x83}, {0xED, 0x66}}, {{0xFA, 0x84}, {0xED, 0x67}},
	{{0xFA, 0x85}, {0xED, 0x68}}, {{0xFA, 0x86}, {0xED, 0x69}},
	{{0xFA, 0x87}, {0xED, 0x6A}}, {{0xFA, 0x88}, {0xED, 0x6B}},
	{{0xFA, 0x89}, {0xED, 0x6C}}, {{0xFA, 0x8A}, {0xED, 0x6D}},
	{{0xFA, 0x8B}, {0xED, 0x6E}}, {{0xFA, 0x8C}, {0xED, 0x6F}},
	{{0xFA, 0x8D}, {0xED, 0x70}}, {{0xFA, 0x8E}, {0xED, 0x71}},
	{{0xFA, 0x8F}, {0xED, 0x72}}, {{0xFA, 0x90}, {0xED, 0x73}},
	{{0xFA, 0x91}, {0xED, 0x74}}, {{0xFA, 0x92}, {0xED, 0x75}},
	{{0xFA, 0x93}, {0xED, 0x76}}, {{0xFA, 0x94}, {0xED, 0x77}},
	{{0xFA, 0x95}, {0xED, 0x78}}, {{0xFA, 0x96}, {0xED, 0x79}},
	{{0xFA, 0x97}, {0xED, 0x7A}}, {{0xFA, 0x98}, {0xED, 0x7B}},
	{{0xFA, 0x99}, {0xED, 0x7C}}, {{0xFA, 0x9A}, {0xED, 0x7D}},
	{{0xFA, 0x9B}, {0xED, 0x7E}}, {{0xFA, 0x9C}, {0xED, 0x80}},
	{{0xFA, 0x9D}, {0xED, 0x81}}, {{0xFA, 0x9E}, {0xED, 0x82}},
	{{0xFA, 0x9F}, {0xED, 0x83}}, {{0xFA, 0xA0}, {0xED, 0x84}},
	{{0xFA, 0xA1}, {0xED, 0x85}}, {{0xFA, 0xA2}, {0xED, 0x86}},
	{{0xFA, 0xA3}, {0xED, 0x87}}, {{0xFA, 0xA4}, {0xED, 0x88}},
	{{0xFA, 0xA5}, {0xED, 0x89}}, {{0xFA, 0xA6}, {0xED, 0x8A}},
	{{0xFA, 0xA7}, {0xED, 0x8B}}, {{0xFA, 0xA8}, {0xED, 0x8C}},
	{{0xFA, 0xA9}, {0xED, 0x8D}}, {{0xFA, 0xAA}, {0xED, 0x8E}},
	{{0xFA, 0xAB}, {0xED, 0x8F}}, {{0xFA, 0xAC}, {0xED, 0x90}},
	{{0xFA, 0xAD}, {0xED, 0x91}}, {{0xFA, 0xAE}, {0xED, 0x92}},
	{{0xFA, 0xAF}, {0xED, 0x93}}, {{0xFA, 0xB0}, {0xED, 0x94}},
	{{0xFA, 0xB1}, {0xED, 0x95}}, {{0xFA, 0xB2}, {0xED, 0x96}},
	{{0xFA, 0xB3}, {0xED, 0x97}}, {{0xFA, 0xB4}, {0xED, 0x98}},
	{{0xFA, 0xB5}, {0xED, 0x99}}, {{0xFA, 0xB6}, {0xED, 0x9A}},
	{{0xFA, 0xB7}, {0xED, 0x9B}}, {{0xFA, 0xB8}, {0xED, 0x9C}},
	{{0xFA, 0xB9}, {0xED, 0x9D}}, {{0xFA, 0xBA}, {0xED, 0x9E}},
	{{0xFA, 0xBB}, {0xED, 0x9F}}, {{0xFA, 0xBC}, {0xED, 0xA0}},
	{{0xFA, 0xBD}, {0xED, 0xA1}}, {{0xFA, 0xBE}, {0xED, 0xA2}},
	{{0xFA, 0xBF}, {0xED, 0xA3}}, {{0xFA, 0xC0}, {0xED, 0xA4}},
	{{0xFA, 0xC1}, {0xED, 0xA5}}, {{0xFA, 0xC2}, {0xED, 0xA6}},
	{{0xFA, 0xC3}, {0xED, 0xA7}}, {{0xFA, 0xC4}, {0xED, 0xA8}},
	{{0xFA, 0xC5}, {0xED, 0xA9}}, {{0xFA, 0xC6}, {0xED, 0xAA}},
	{{0xFA, 0xC7}, {0xED, 0xAB}}, {{0xFA, 0xC8}, {0xED, 0xAC}},
	{{0xFA, 0xC9}, {0xED, 0xAD}}, {{0xFA, 0xCA}, {0xED, 0xAE}},
	{{0xFA, 0xCB}, {0xED, 0xAF}}, {{0xFA, 0xCC}, {0xED, 0xB0}},
	{{0xFA, 0xCD}, {0xED, 0xB1}}, {{0xFA, 0xCE}, {0xED, 0xB2}},
	{{0xFA, 0xCF}, {0xED, 0xB3}}, {{0xFA, 0xD0}, {0xED, 0xB4}},
	{{0xFA, 0xD1}, {0xED, 0xB5}}, {{0xFA, 0xD2}, {0xED, 0xB6}},
	{{0xFA, 0xD3}, {0xED, 0xB7}}, {{0xFA, 0xD4}, {0xED, 0xB8}},
	{{0xFA, 0xD5}, {0xED, 0xB9}}, {{0xFA, 0xD6}, {0xED, 0xBA}},
	{{0xFA, 0xD7}, {0xED, 0xBB}}, {{0xFA, 0xD8}, {0xED, 0xBC}},
	{{0xFA, 0xD9}, {0xED, 0xBD}}, {{0xFA, 0xDA}, {0xED, 0xBE}},
	{{0xFA, 0xDB}, {0xED, 0xBF}}, {{0xFA, 0xDC}, {0xED, 0xC0}},
	{{0xFA, 0xDD}, {0xED, 0xC1}}, {{0xFA, 0xDE}, {0xED, 0xC2}},
	{{0xFA, 0xDF}, {0xED, 0xC3}}, {{0xFA, 0xE0}, {0xED, 0xC4}},
	{{0xFA, 0xE1}, {0xED, 0xC5}}, {{0xFA, 0xE2}, {0xED, 0xC6}},
	{{0xFA, 0xE3}, {0xED, 0xC7}}, {{0xFA, 0xE4}, {0xED, 0xC8}},
	{{0xFA, 0xE5}, {0xED, 0xC9}}, {{0xFA, 0xE6}, {0xED, 0xCA}},
	{{0xFA, 0xE7}, {0xED, 0xCB}}, {{0xFA, 0xE8}, {0xED, 0xCC}},
	{{0xFA, 0xE9}, {0xED, 0xCD}}, {{0xFA, 0xEA}, {0xED, 0xCE}},
	{{0xFA, 0xEB}, {0xED, 0xCF}}, {{0xFA, 0xEC}, {0xED, 0xD0}},
	{{0xFA, 0xED}, {0xED, 0xD1}}, {{0xFA, 0xEE}, {0xED, 0xD2}},
	{{0xFA, 0xEF}, {0xED, 0xD3}}, {{0xFA, 0xF0}, {0xED, 0xD4}},
	{{0xFA, 0xF1}, {0xED, 0xD5}}, {{0xFA, 0xF2}, {0xED, 0xD6}},
	{{0xFA, 0xF3}, {0xED, 0xD7}}, {{0xFA, 0xF4}, {0xED, 0xD8}},
	{{0xFA, 0xF5}, {0xED, 0xD9}}, {{0xFA, 0xF6}, {0xED, 0xDA}},
	{{0xFA, 0xF7}, {0xED, 0xDB}}, {{0xFA, 0xF8}, {0xED, 0xDC}},
	{{0xFA, 0xF9}, {0xED, 0xDD}}, {{0xFA, 0xFA}, {0xED, 0xDE}},
	{{0xFA, 0xFB}, {0xED, 0xDF}}, {{0xFA, 0xFC}, {0xED, 0xE0}},
	{{0xFB, 0x40}, {0xED, 0xE1}}, {{0xFB, 0x41}, {0xED, 0xE2}},
	{{0xFB, 0x42}, {0xED, 0xE3}}, {{0xFB, 0x43}, {0xED, 0xE4}},
	{{0xFB, 0x44}, {0xED, 0xE5}}, {{0xFB, 0x45}, {0xED, 0xE6}},
	{{0xFB, 0x46}, {0xED, 0xE7}}, {{0xFB, 0x47}, {0xED, 0xE8}},
	{{0xFB, 0x48}, {0xED, 0xE9}}, {{0xFB, 0x49}, {0xED, 0xEA}},
	{{0xFB, 0x4A}, {0xED, 0xEB}}, {{0xFB, 0x4B}, {0xED, 0xEC}},
	{{0xFB, 0x4C}, {0xED, 0xED}}, {{0xFB, 0x4D}, {0xED, 0xEE}},
	{{0xFB, 0x4E}, {0xED, 0xEF}}, {{0xFB, 0x4F}, {0xED, 0xF0}},
	{{0xFB, 0x50}, {0xED, 0xF1}}, {{0xFB, 0x51}, {0xED, 0xF2}},
	{{0xFB, 0x52}, {0xED, 0xF3}}, {{0xFB, 0x53}, {0xED, 0xF4}},
	{{0xFB, 0x54}, {0xED, 0xF5}}, {{0xFB, 0x55}, {0xED, 0xF6}},
	{{0xFB, 0x56}, {0xED, 0xF7}}, {{0xFB, 0x57}, {0xED, 0xF8}},
	{{0xFB, 0x58}, {0xED, 0xF9}}, {{0xFB, 0x59}, {0xED, 0xFA}},
	{{0xFB, 0x5A}, {0xED, 0xFB}}, {{0xFB, 0x5B}, {0xED, 0xFC}},
	{{0xFB, 0x5C}, {0xEE, 0x40}}, {{0xFB, 0x5D}, {0xEE, 0x41}},
	{{0xFB, 0x5E}, {0xEE, 0x42}}, {{0xFB, 0x5F}, {0xEE, 0x43}},
	{{0xFB, 0x60}, {0xEE, 0x44}}, {{0xFB, 0x61}, {0xEE, 0x45}},
	{{0xFB, 0x62}, {0xEE, 0x46}}, {{0xFB, 0x63}, {0xEE, 0x47}},
	{{0xFB, 0x64}, {0xEE, 0x48}}, {{0xFB, 0x65}, {0xEE, 0x49}},
	{{0xFB, 0x66}, {0xEE, 0x4A}}, {{0xFB, 0x67}, {0xEE, 0x4B}},
	{{0xFB, 0x68}, {0xEE, 0x4C}}, {{0xFB, 0x69}, {0xEE, 0x4D}},
	{{0xFB, 0x6A}, {0xEE, 0x4E}}, {{0xFB, 0x6B}, {0xEE, 0x4F}},
	{{0xFB, 0x6C}, {0xEE, 0x50}}, {{0xFB, 0x6D}, {0xEE, 0x51}},
	{{0xFB, 0x6E}, {0xEE, 0x52}}, {{0xFB, 0x6F}, {0xEE, 0x53}},
	{{0xFB, 0x70}, {0xEE, 0x54}}, {{0xFB, 0x71}, {0xEE, 0x55}},
	{{0xFB, 0x72}, {0xEE, 0x56}}, {{0xFB, 0x73}, {0xEE, 0x57}},
	{{0xFB, 0x74}, {0xEE, 0x58}}, {{0xFB, 0x75}, {0xEE, 0x59}},
	{{0xFB, 0x76}, {0xEE, 0x5A}}, {{0xFB, 0x77}, {0xEE, 0x5B}},
	{{0xFB, 0x78}, {0xEE, 0x5C}}, {{0xFB, 0x79}, {0xEE, 0x5D}},
	{{0xFB, 0x7A}, {0xEE, 0x5E}}, {{0xFB, 0x7B}, {0xEE, 0x5F}},
	{{0xFB, 0x7C}, {0xEE, 0x60}}, {{0xFB, 0x7D}, {0xEE, 0x61}},
	{{0xFB, 0x7E}, {0xEE, 0x62}}, {{0xFB, 0x80}, {0xEE, 0x63}},
	{{0xFB, 0x81}, {0xEE, 0x64}}, {{0xFB, 0x82}, {0xEE, 0x65}},
	{{0xFB, 0x83}, {0xEE, 0x66}}, {{0xFB, 0x84}, {0xEE, 0x67}},
	{{0xFB, 0x85}, {0xEE, 0x68}}, {{0xFB, 0x86}, {0xEE, 0x69}},
	{{0xFB, 0x87}, {0xEE, 0x6A}}, {{0xFB, 0x88}, {0xEE, 0x6B}},
	{{0xFB, 0x89}, {0xEE, 0x6C}}, {{0xFB, 0x8A}, {0xEE, 0x6D}},
	{{0xFB, 0x8B}, {0xEE, 0x6E}}, {{0xFB, 0x8C}, {0xEE, 0x6F}},
	{{0xFB, 0x8D}, {0xEE, 0x70}}, {{0xFB, 0x8E}, {0xEE, 0x71}},
	{{0xFB, 0x8F}, {0xEE, 0x72}}, {{0xFB, 0x90}, {0xEE, 0x73}},
	{{0xFB, 0x91}, {0xEE, 0x74}}, {{0xFB, 0x92}, {0xEE, 0x75}},
	{{0xFB, 0x93}, {0xEE, 0x76}}, {{0xFB, 0x94}, {0xEE, 0x77}},
	{{0xFB, 0x95}, {0xEE, 0x78}}, {{0xFB, 0x96}, {0xEE, 0x79}},
	{{0xFB, 0x97}, {0xEE, 0x7A}}, {{0xFB, 0x98}, {0xEE, 0x7B}},
	{{0xFB, 0x99}, {0xEE, 0x7C}}, {{0xFB, 0x9A}, {0xEE, 0x7D}},
	{{0xFB, 0x9B}, {0xEE, 0x7E}}, {{0xFB, 0x9C}, {0xEE, 0x80}},
	{{0xFB, 0x9D}, {0xEE, 0x81}}, {{0xFB, 0x9E}, {0xEE, 0x82}},
	{{0xFB, 0x9F}, {0xEE, 0x83}}, {{0xFB, 0xA0}, {0xEE, 0x84}},
	{{0xFB, 0xA1}, {0xEE, 0x85}}, {{0xFB, 0xA2}, {0xEE, 0x86}},
	{{0xFB, 0xA3}, {0xEE, 0x87}}, {{0xFB, 0xA4}, {0xEE, 0x88}},
	{{0xFB, 0xA5}, {0xEE, 0x89}}, {{0xFB, 0xA6}, {0xEE, 0x8A}},
	{{0xFB, 0xA7}, {0xEE, 0x8B}}, {{0xFB, 0xA8}, {0xEE, 0x8C}},
	{{0xFB, 0xA9}, {0xEE, 0x8D}}, {{0xFB, 0xAA}, {0xEE, 0x8E}},
	{{0xFB, 0xAB}, {0xEE, 0x8F}}, {{0xFB, 0xAC}, {0xEE, 0x90}},
	{{0xFB, 0xAD}, {0xEE, 0x91}}, {{0xFB, 0xAE}, {0xEE, 0x92}},
	{{0xFB, 0xAF}, {0xEE, 0x93}}, {{0xFB, 0xB0}, {0xEE, 0x94}},
	{{0xFB, 0xB1}, {0xEE, 0x95}}, {{0xFB, 0xB2}, {0xEE, 0x96}},
	{{0xFB, 0xB3}, {0xEE, 0x97}}, {{0xFB, 0xB4}, {0xEE, 0x98}},
	{{0xFB, 0xB5}, {0xEE, 0x99}}, {{0xFB, 0xB6}, {0xEE, 0x9A}},
	{{0xFB, 0xB7}, {0xEE, 0x9B}}, {{0xFB, 0xB8}, {0xEE, 0x9C}},
	{{0xFB, 0xB9}, {0xEE, 0x9D}}, {{0xFB, 0xBA}, {0xEE, 0x9E}},
	{{0xFB, 0xBB}, {0xEE, 0x9F}}, {{0xFB, 0xBC}, {0xEE, 0xA0}},
	{{0xFB, 0xBD}, {0xEE, 0xA1}}, {{0xFB, 0xBE}, {0xEE, 0xA2}},
	{{0xFB, 0xBF}, {0xEE, 0xA3}}, {{0xFB, 0xC0}, {0xEE, 0xA4}},
	{{0xFB, 0xC1}, {0xEE, 0xA5}}, {{0xFB, 0xC2}, {0xEE, 0xA6}},
	{{0xFB, 0xC3}, {0xEE, 0xA7}}, {{0xFB, 0xC4}, {0xEE, 0xA8}},
	{{0xFB, 0xC5}, {0xEE, 0xA9}}, {{0xFB, 0xC6}, {0xEE, 0xAA}},
	{{0xFB, 0xC7}, {0xEE, 0xAB}}, {{0xFB, 0xC8}, {0xEE, 0xAC}},
	{{0xFB, 0xC9}, {0xEE, 0xAD}}, {{0xFB, 0xCA}, {0xEE, 0xAE}},
	{{0xFB, 0xCB}, {0xEE, 0xAF}}, {{0xFB, 0xCC}, {0xEE, 0xB0}},
	{{0xFB, 0xCD}, {0xEE, 0xB1}}, {{0xFB, 0xCE}, {0xEE, 0xB2}},
	{{0xFB, 0xCF}, {0xEE, 0xB3}}, {{0xFB, 0xD0}, {0xEE, 0xB4}},
	{{0xFB, 0xD1}, {0xEE, 0xB5}}, {{0xFB, 0xD2}, {0xEE, 0xB6}},
	{{0xFB, 0xD3}, {0xEE, 0xB7}}, {{0xFB, 0xD4}, {0xEE, 0xB8}},
	{{0xFB, 0xD5}, {0xEE, 0xB9}}, {{0xFB, 0xD6}, {0xEE, 0xBA}},
	{{0xFB, 0xD7}, {0xEE, 0xBB}}, {{0xFB, 0xD8}, {0xEE, 0xBC}},
	{{0xFB, 0xD9}, {0xEE, 0xBD}}, {{0xFB, 0xDA}, {0xEE, 0xBE}},
	{{0xFB, 0xDB}, {0xEE, 0xBF}}, {{0xFB, 0xDC}, {0xEE, 0xC0}},
	{{0xFB, 0xDD}, {0xEE, 0xC1}}, {{0xFB, 0xDE}, {0xEE, 0xC2}},
	{{0xFB, 0xDF}, {0xEE, 0xC3}}, {{0xFB, 0xE0}, {0xEE, 0xC4}},
	{{0xFB, 0xE1}, {0xEE, 0xC5}}, {{0xFB, 0xE2}, {0xEE, 0xC6}},
	{{0xFB, 0xE3}, {0xEE, 0xC7}}, {{0xFB, 0xE4}, {0xEE, 0xC8}},
	{{0xFB, 0xE5}, {0xEE, 0xC9}}, {{0xFB, 0xE6}, {0xEE, 0xCA}},
	{{0xFB, 0xE7}, {0xEE, 0xCB}}, {{0xFB, 0xE8}, {0xEE, 0xCC}},
	{{0xFB, 0xE9}, {0xEE, 0xCD}}, {{0xFB, 0xEA}, {0xEE, 0xCE}},
	{{0xFB, 0xEB}, {0xEE, 0xCF}}, {{0xFB, 0xEC}, {0xEE, 0xD0}},
	{{0xFB, 0xED}, {0xEE, 0xD1}}, {{0xFB, 0xEE}, {0xEE, 0xD2}},
	{{0xFB, 0xEF}, {0xEE, 0xD3}}, {{0xFB, 0xF0}, {0xEE, 0xD4}},
	{{0xFB, 0xF1}, {0xEE, 0xD5}}, {{0xFB, 0xF2}, {0xEE, 0xD6}},
	{{0xFB, 0xF3}, {0xEE, 0xD7}}, {{0xFB, 0xF4}, {0xEE, 0xD8}},
	{{0xFB, 0xF5}, {0xEE, 0xD9}}, {{0xFB, 0xF6}, {0xEE, 0xDA}},
	{{0xFB, 0xF7}, {0xEE, 0xDB}}, {{0xFB, 0xF8}, {0xEE, 0xDC}},
	{{0xFB, 0xF9}, {0xEE, 0xDD}}, {{0xFB, 0xFA}, {0xEE, 0xDE}},
	{{0xFB, 0xFB}, {0xEE, 0xDF}}, {{0xFB, 0xFC}, {0xEE, 0xE0}},
	{{0xFC, 0x40}, {0xEE, 0xE1}}, {{0xFC, 0x41}, {0xEE, 0xE2}},
	{{0xFC, 0x42}, {0xEE, 0xE3}}, {{0xFC, 0x43}, {0xEE, 0xE4}},
	{{0xFC, 0x44}, {0xEE, 0xE5}}, {{0xFC, 0x45}, {0xEE, 0xE6}},
	{{0xFC, 0x46}, {0xEE, 0xE7}}, {{0xFC, 0x47}, {0xEE, 0xE8}},
	{{0xFC, 0x48}, {0xEE, 0xE9}}, {{0xFC, 0x49}, {0xEE, 0xEA}},
	{{0xFC, 0x4A}, {0xEE, 0xEB}}, {{0xFC, 0x4B}, {0xEE, 0xEC}},
	{{0x00, 0x00}, {0x00, 0x00}}
};

static struct {
	char_u		sjis[2];
	char_u		ss3[3];
} ss3conv[] = {
	{{0xFA, 0x40}, {0x8F, 0xF3, 0xF3}}, {{0xFA, 0x41}, {0x8F, 0xF3, 0xF4}},
	{{0xFA, 0x42}, {0x8F, 0xF3, 0xF5}}, {{0xFA, 0x43}, {0x8F, 0xF3, 0xF6}},
	{{0xFA, 0x44}, {0x8F, 0xF3, 0xF7}}, {{0xFA, 0x45}, {0x8F, 0xF3, 0xF8}},
	{{0xFA, 0x46}, {0x8F, 0xF3, 0xF9}}, {{0xFA, 0x47}, {0x8F, 0xF3, 0xFA}},
	{{0xFA, 0x48}, {0x8F, 0xF3, 0xFB}}, {{0xFA, 0x49}, {0x8F, 0xF3, 0xFC}},
	{{0xFA, 0x4A}, {0x8F, 0xF3, 0xFD}}, {{0xFA, 0x4B}, {0x8F, 0xF3, 0xFE}},
	{{0xFA, 0x4C}, {0x8F, 0xF4, 0xA1}}, {{0xFA, 0x4D}, {0x8F, 0xF4, 0xA2}},
	{{0xFA, 0x4E}, {0x8F, 0xF4, 0xA3}}, {{0xFA, 0x4F}, {0x8F, 0xF4, 0xA4}},
	{{0xFA, 0x50}, {0x8F, 0xF4, 0xA5}}, {{0xFA, 0x51}, {0x8F, 0xF4, 0xA6}},
	{{0xFA, 0x52}, {0x8F, 0xF4, 0xA7}}, {{0xFA, 0x53}, {0x8F, 0xF4, 0xA8}},
	{{0xFA, 0x54}, {0x00, 0xA2, 0xCC}}, {{0xFA, 0x55}, {0x8F, 0xA2, 0xC3}},
	{{0xFA, 0x56}, {0x8F, 0xF4, 0xA9}}, {{0xFA, 0x57}, {0x8F, 0xF4, 0xAA}},
	{{0xFA, 0x58}, {0x8F, 0xF4, 0xAB}}, {{0xFA, 0x59}, {0x8F, 0xA2, 0xF1}},
	{{0xFA, 0x59}, {0x8F, 0xF4, 0xAC}}, {{0xFA, 0x5A}, {0x8F, 0xF4, 0xAD}},
	{{0xFA, 0x5B}, {0x00, 0xA2, 0xE8}}, {{0xFA, 0x5C}, {0x8F, 0xD4, 0xE3}},
	{{0xFA, 0x5D}, {0x8F, 0xDC, 0xDF}}, {{0xFA, 0x5E}, {0x8F, 0xE4, 0xE9}},
	{{0xFA, 0x5F}, {0x8F, 0xE3, 0xF8}}, {{0xFA, 0x60}, {0x8F, 0xD9, 0xA1}},
	{{0xFA, 0x61}, {0x8F, 0xB1, 0xBB}}, {{0xFA, 0x62}, {0x8F, 0xF4, 0xAE}},
	{{0xFA, 0x63}, {0x8F, 0xC2, 0xAD}}, {{0xFA, 0x64}, {0x8F, 0xC3, 0xFC}},
	{{0xFA, 0x65}, {0x8F, 0xE4, 0xD0}}, {{0xFA, 0x66}, {0x8F, 0xC2, 0xBF}},
	{{0xFA, 0x67}, {0x8F, 0xBC, 0xF4}}, {{0xFA, 0x68}, {0x8F, 0xB0, 0xA9}},
	{{0xFA, 0x69}, {0x8F, 0xB0, 0xC8}}, {{0xFA, 0x6A}, {0x8F, 0xF4, 0xAF}},
	{{0xFA, 0x6B}, {0x8F, 0xB0, 0xD2}}, {{0xFA, 0x6C}, {0x8F, 0xB0, 0xD4}},
	{{0xFA, 0x6D}, {0x8F, 0xB0, 0xE3}}, {{0xFA, 0x6E}, {0x8F, 0xB0, 0xEE}},
	{{0xFA, 0x6F}, {0x8F, 0xB1, 0xA7}}, {{0xFA, 0x70}, {0x8F, 0xB1, 0xA3}},
	{{0xFA, 0x71}, {0x8F, 0xB1, 0xAC}}, {{0xFA, 0x72}, {0x8F, 0xB1, 0xA9}},
	{{0xFA, 0x73}, {0x8F, 0xB1, 0xBE}}, {{0xFA, 0x74}, {0x8F, 0xB1, 0xDF}},
	{{0xFA, 0x75}, {0x8F, 0xB1, 0xD8}}, {{0xFA, 0x76}, {0x8F, 0xB1, 0xC8}},
	{{0xFA, 0x77}, {0x8F, 0xB1, 0xD7}}, {{0xFA, 0x78}, {0x8F, 0xB1, 0xE3}},
	{{0xFA, 0x79}, {0x8F, 0xB1, 0xF4}}, {{0xFA, 0x7A}, {0x8F, 0xB1, 0xE1}},
	{{0xFA, 0x7B}, {0x8F, 0xB2, 0xA3}}, {{0xFA, 0x7C}, {0x8F, 0xF4, 0xB0}},
	{{0xFA, 0x7D}, {0x8F, 0xB2, 0xBB}}, {{0xFA, 0x7E}, {0x8F, 0xB2, 0xE6}},
	{{0xFA, 0x80}, {0x8F, 0xB2, 0xED}}, {{0xFA, 0x81}, {0x8F, 0xB2, 0xF5}},
	{{0xFA, 0x82}, {0x8F, 0xB2, 0xFC}}, {{0xFA, 0x83}, {0x8F, 0xF4, 0xB1}},
	{{0xFA, 0x84}, {0x8F, 0xB3, 0xB5}}, {{0xFA, 0x85}, {0x8F, 0xB3, 0xD8}},
	{{0xFA, 0x86}, {0x8F, 0xB3, 0xDB}}, {{0xFA, 0x87}, {0x8F, 0xB3, 0xE5}},
	{{0xFA, 0x88}, {0x8F, 0xB3, 0xEE}}, {{0xFA, 0x89}, {0x8F, 0xB3, 0xFB}},
	{{0xFA, 0x8A}, {0x8F, 0xF4, 0xB2}}, {{0xFA, 0x8B}, {0x8F, 0xF4, 0xB3}},
	{{0xFA, 0x8C}, {0x8F, 0xB4, 0xC0}}, {{0xFA, 0x8D}, {0x8F, 0xB4, 0xC7}},
	{{0xFA, 0x8E}, {0x8F, 0xB4, 0xD0}}, {{0xFA, 0x8F}, {0x8F, 0xB4, 0xDE}},
	{{0xFA, 0x90}, {0x8F, 0xF4, 0xB4}}, {{0xFA, 0x91}, {0x8F, 0xB5, 0xAA}},
	{{0xFA, 0x92}, {0x8F, 0xF4, 0xB5}}, {{0xFA, 0x93}, {0x8F, 0xB5, 0xAF}},
	{{0xFA, 0x94}, {0x8F, 0xB5, 0xC4}}, {{0xFA, 0x95}, {0x8F, 0xB5, 0xE8}},
	{{0xFA, 0x96}, {0x8F, 0xF4, 0xB6}}, {{0xFA, 0x97}, {0x8F, 0xB7, 0xC2}},
	{{0xFA, 0x98}, {0x8F, 0xB7, 0xE4}}, {{0xFA, 0x99}, {0x8F, 0xB7, 0xE8}},
	{{0xFA, 0x9A}, {0x8F, 0xB7, 0xE7}}, {{0xFA, 0x9B}, {0x8F, 0xF4, 0xB7}},
	{{0xFA, 0x9C}, {0x8F, 0xF4, 0xB8}}, {{0xFA, 0x9D}, {0x8F, 0xF4, 0xB9}},
	{{0xFA, 0x9E}, {0x8F, 0xB8, 0xCE}}, {{0xFA, 0x9F}, {0x8F, 0xB8, 0xE1}},
	{{0xFA, 0xA0}, {0x8F, 0xB8, 0xF5}}, {{0xFA, 0xA1}, {0x8F, 0xB8, 0xF7}},
	{{0xFA, 0xA2}, {0x8F, 0xB8, 0xF8}}, {{0xFA, 0xA3}, {0x8F, 0xB8, 0xFC}},
	{{0xFA, 0xA4}, {0x8F, 0xB9, 0xAF}}, {{0xFA, 0xA5}, {0x8F, 0xB9, 0xB7}},
	{{0xFA, 0xA6}, {0x8F, 0xBA, 0xBE}}, {{0xFA, 0xA7}, {0x8F, 0xBA, 0xDB}},
	{{0xFA, 0xA8}, {0x8F, 0xCD, 0xAA}}, {{0xFA, 0xA9}, {0x8F, 0xBA, 0xE1}},
	{{0xFA, 0xAA}, {0x8F, 0xF4, 0xBA}}, {{0xFA, 0xAB}, {0x8F, 0xBA, 0xEB}},
	{{0xFA, 0xAC}, {0x8F, 0xBB, 0xB3}}, {{0xFA, 0xAD}, {0x8F, 0xBB, 0xB8}},
	{{0xFA, 0xAE}, {0x8F, 0xF4, 0xBB}}, {{0xFA, 0xAF}, {0x8F, 0xBB, 0xCA}},
	{{0xFA, 0xB0}, {0x8F, 0xF4, 0xBC}}, {{0xFA, 0xB1}, {0x8F, 0xF4, 0xBD}},
	{{0xFA, 0xB2}, {0x8F, 0xBB, 0xD0}}, {{0xFA, 0xB3}, {0x8F, 0xBB, 0xDE}},
	{{0xFA, 0xB4}, {0x8F, 0xBB, 0xF4}}, {{0xFA, 0xB5}, {0x8F, 0xBB, 0xF5}},
	{{0xFA, 0xB6}, {0x8F, 0xBB, 0xF9}}, {{0xFA, 0xB7}, {0x8F, 0xBC, 0xE4}},
	{{0xFA, 0xB8}, {0x8F, 0xBC, 0xED}}, {{0xFA, 0xB9}, {0x8F, 0xBC, 0xFE}},
	{{0xFA, 0xBA}, {0x8F, 0xF4, 0xBE}}, {{0xFA, 0xBB}, {0x8F, 0xBD, 0xC2}},
	{{0xFA, 0xBC}, {0x8F, 0xBD, 0xE7}}, {{0xFA, 0xBD}, {0x8F, 0xF4, 0xBF}},
	{{0xFA, 0xBE}, {0x8F, 0xBD, 0xF0}}, {{0xFA, 0xBF}, {0x8F, 0xBE, 0xB0}},
	{{0xFA, 0xC0}, {0x8F, 0xBE, 0xAC}}, {{0xFA, 0xC1}, {0x8F, 0xF4, 0xC0}},
	{{0xFA, 0xC2}, {0x8F, 0xBE, 0xB3}}, {{0xFA, 0xC3}, {0x8F, 0xBE, 0xBD}},
	{{0xFA, 0xC4}, {0x8F, 0xBE, 0xCD}}, {{0xFA, 0xC5}, {0x8F, 0xBE, 0xC9}},
	{{0xFA, 0xC6}, {0x8F, 0xBE, 0xE4}}, {{0xFA, 0xC7}, {0x8F, 0xBF, 0xA8}},
	{{0xFA, 0xC8}, {0x8F, 0xBF, 0xC9}}, {{0xFA, 0xC9}, {0x8F, 0xC0, 0xC4}},
	{{0xFA, 0xCA}, {0x8F, 0xC0, 0xE4}}, {{0xFA, 0xCB}, {0x8F, 0xC0, 0xF4}},
	{{0xFA, 0xCC}, {0x8F, 0xC1, 0xA6}}, {{0xFA, 0xCD}, {0x8F, 0xF4, 0xC1}},
	{{0xFA, 0xCE}, {0x8F, 0xC1, 0xF5}}, {{0xFA, 0xCF}, {0x8F, 0xC1, 0xFC}},
	{{0xFA, 0xD0}, {0x8F, 0xF4, 0xC2}}, {{0xFA, 0xD1}, {0x8F, 0xC1, 0xF8}},
	{{0xFA, 0xD2}, {0x8F, 0xC2, 0xAB}}, {{0xFA, 0xD3}, {0x8F, 0xC2, 0xA1}},
	{{0xFA, 0xD4}, {0x8F, 0xC2, 0xA5}}, {{0xFA, 0xD5}, {0x8F, 0xF4, 0xC3}},
	{{0xFA, 0xD6}, {0x8F, 0xC2, 0xB8}}, {{0xFA, 0xD7}, {0x8F, 0xC2, 0xBA}},
	{{0xFA, 0xD8}, {0x8F, 0xF4, 0xC4}}, {{0xFA, 0xD9}, {0x8F, 0xC2, 0xC4}},
	{{0xFA, 0xDA}, {0x8F, 0xC2, 0xD2}}, {{0xFA, 0xDB}, {0x8F, 0xC2, 0xD7}},
	{{0xFA, 0xDC}, {0x8F, 0xC2, 0xDB}}, {{0xFA, 0xDD}, {0x8F, 0xC2, 0xDE}},
	{{0xFA, 0xDE}, {0x8F, 0xC2, 0xED}}, {{0xFA, 0xDF}, {0x8F, 0xC2, 0xF0}},
	{{0xFA, 0xE0}, {0x8F, 0xF4, 0xC5}}, {{0xFA, 0xE1}, {0x8F, 0xC3, 0xA1}},
	{{0xFA, 0xE2}, {0x8F, 0xC3, 0xB5}}, {{0xFA, 0xE3}, {0x8F, 0xC3, 0xC9}},
	{{0xFA, 0xE4}, {0x8F, 0xC3, 0xB9}}, {{0xFA, 0xE5}, {0x8F, 0xF4, 0xC6}},
	{{0xFA, 0xE6}, {0x8F, 0xC3, 0xD8}}, {{0xFA, 0xE7}, {0x8F, 0xC3, 0xFE}},
	{{0xFA, 0xE8}, {0x8F, 0xF4, 0xC7}}, {{0xFA, 0xE9}, {0x8F, 0xC4, 0xCC}},
	{{0xFA, 0xEA}, {0x8F, 0xF4, 0xC8}}, {{0xFA, 0xEB}, {0x8F, 0xC4, 0xD9}},
	{{0xFA, 0xEC}, {0x8F, 0xC4, 0xEA}}, {{0xFA, 0xED}, {0x8F, 0xC4, 0xFD}},
	{{0xFA, 0xEE}, {0x8F, 0xF4, 0xC9}}, {{0xFA, 0xEF}, {0x8F, 0xC5, 0xA7}},
	{{0xFA, 0xF0}, {0x8F, 0xC5, 0xB5}}, {{0xFA, 0xF1}, {0x8F, 0xC5, 0xB6}},
	{{0xFA, 0xF2}, {0x8F, 0xF4, 0xCA}}, {{0xFA, 0xF3}, {0x8F, 0xC5, 0xD5}},
	{{0xFA, 0xF4}, {0x8F, 0xC6, 0xB8}}, {{0xFA, 0xF5}, {0x8F, 0xC6, 0xD7}},
	{{0xFA, 0xF6}, {0x8F, 0xC6, 0xE0}}, {{0xFA, 0xF7}, {0x8F, 0xC6, 0xEA}},
	{{0xFA, 0xF8}, {0x8F, 0xC6, 0xE3}}, {{0xFA, 0xF9}, {0x8F, 0xC7, 0xA1}},
	{{0xFA, 0xFA}, {0x8F, 0xC7, 0xAB}}, {{0xFA, 0xFB}, {0x8F, 0xC7, 0xC7}},
	{{0xFA, 0xFC}, {0x8F, 0xC7, 0xC3}}, {{0xFB, 0x40}, {0x8F, 0xC7, 0xCB}},
	{{0xFB, 0x41}, {0x8F, 0xC7, 0xCF}}, {{0xFB, 0x42}, {0x8F, 0xC7, 0xD9}},
	{{0xFB, 0x43}, {0x8F, 0xF4, 0xCB}}, {{0xFB, 0x44}, {0x8F, 0xF4, 0xCC}},
	{{0xFB, 0x45}, {0x8F, 0xC7, 0xE6}}, {{0xFB, 0x46}, {0x8F, 0xC7, 0xEE}},
	{{0xFB, 0x47}, {0x8F, 0xC7, 0xFC}}, {{0xFB, 0x48}, {0x8F, 0xC7, 0xEB}},
	{{0xFB, 0x49}, {0x8F, 0xC7, 0xF0}}, {{0xFB, 0x4A}, {0x8F, 0xC8, 0xB1}},
	{{0xFB, 0x4B}, {0x8F, 0xC8, 0xE5}}, {{0xFB, 0x4C}, {0x8F, 0xC8, 0xF8}},
	{{0xFB, 0x4D}, {0x8F, 0xC9, 0xA6}}, {{0xFB, 0x4E}, {0x8F, 0xC9, 0xAB}},
	{{0xFB, 0x4F}, {0x8F, 0xC9, 0xAD}}, {{0xFB, 0x50}, {0x8F, 0xF4, 0xCD}},
	{{0xFB, 0x51}, {0x8F, 0xC9, 0xCA}}, {{0xFB, 0x52}, {0x8F, 0xC9, 0xD3}},
	{{0xFB, 0x53}, {0x8F, 0xC9, 0xE9}}, {{0xFB, 0x54}, {0x8F, 0xC9, 0xE3}},
	{{0xFB, 0x55}, {0x8F, 0xC9, 0xFC}}, {{0xFB, 0x56}, {0x8F, 0xC9, 0xF4}},
	{{0xFB, 0x57}, {0x8F, 0xC9, 0xF5}}, {{0xFB, 0x58}, {0x8F, 0xF4, 0xCE}},
	{{0xFB, 0x59}, {0x8F, 0xCA, 0xB3}}, {{0xFB, 0x5A}, {0x8F, 0xCA, 0xBD}},
	{{0xFB, 0x5B}, {0x8F, 0xCA, 0xEF}}, {{0xFB, 0x5C}, {0x8F, 0xCA, 0xF1}},
	{{0xFB, 0x5D}, {0x8F, 0xCB, 0xAE}}, {{0xFB, 0x5E}, {0x8F, 0xF4, 0xCF}},
	{{0xFB, 0x5F}, {0x8F, 0xCB, 0xCA}}, {{0xFB, 0x60}, {0x8F, 0xCB, 0xE6}},
	{{0xFB, 0x61}, {0x8F, 0xCB, 0xEA}}, {{0xFB, 0x62}, {0x8F, 0xCB, 0xF0}},
	{{0xFB, 0x63}, {0x8F, 0xCB, 0xF4}}, {{0xFB, 0x64}, {0x8F, 0xCB, 0xEE}},
	{{0xFB, 0x65}, {0x8F, 0xCC, 0xA5}}, {{0xFB, 0x66}, {0x8F, 0xCB, 0xF9}},
	{{0xFB, 0x67}, {0x8F, 0xCC, 0xAB}}, {{0xFB, 0x68}, {0x8F, 0xCC, 0xAE}},
	{{0xFB, 0x69}, {0x8F, 0xCC, 0xAD}}, {{0xFB, 0x6A}, {0x8F, 0xCC, 0xB2}},
	{{0xFB, 0x6B}, {0x8F, 0xCC, 0xC2}}, {{0xFB, 0x6C}, {0x8F, 0xCC, 0xD0}},
	{{0xFB, 0x6D}, {0x8F, 0xCC, 0xD9}}, {{0xFB, 0x6E}, {0x8F, 0xF4, 0xD0}},
	{{0xFB, 0x6F}, {0x8F, 0xCD, 0xBB}}, {{0xFB, 0x70}, {0x8F, 0xF4, 0xD1}},
	{{0xFB, 0x71}, {0x8F, 0xCE, 0xBB}}, {{0xFB, 0x72}, {0x8F, 0xF4, 0xD2}},
	{{0xFB, 0x73}, {0x8F, 0xCE, 0xBA}}, {{0xFB, 0x74}, {0x8F, 0xCE, 0xC3}},
	{{0xFB, 0x75}, {0x8F, 0xF4, 0xD3}}, {{0xFB, 0x76}, {0x8F, 0xCE, 0xF2}},
	{{0xFB, 0x77}, {0x8F, 0xB3, 0xDD}}, {{0xFB, 0x78}, {0x8F, 0xCF, 0xD5}},
	{{0xFB, 0x79}, {0x8F, 0xCF, 0xE2}}, {{0xFB, 0x7A}, {0x8F, 0xCF, 0xE9}},
	{{0xFB, 0x7B}, {0x8F, 0xCF, 0xED}}, {{0xFB, 0x7C}, {0x8F, 0xF4, 0xD4}},
	{{0xFB, 0x7D}, {0x8F, 0xF4, 0xD5}}, {{0xFB, 0x7E}, {0x8F, 0xF4, 0xD6}},
	{{0xFB, 0x80}, {0x8F, 0xF4, 0xD7}}, {{0xFB, 0x81}, {0x8F, 0xD0, 0xE5}},
	{{0xFB, 0x82}, {0x8F, 0xF4, 0xD8}}, {{0xFB, 0x83}, {0x8F, 0xD0, 0xE9}},
	{{0xFB, 0x84}, {0x8F, 0xD1, 0xE8}}, {{0xFB, 0x85}, {0x8F, 0xF4, 0xD9}},
	{{0xFB, 0x86}, {0x8F, 0xF4, 0xDA}}, {{0xFB, 0x87}, {0x8F, 0xD1, 0xEC}},
	{{0xFB, 0x88}, {0x8F, 0xD2, 0xBB}}, {{0xFB, 0x89}, {0x8F, 0xF4, 0xDB}},
	{{0xFB, 0x8A}, {0x8F, 0xD3, 0xE1}}, {{0xFB, 0x8B}, {0x8F, 0xD3, 0xE8}},
	{{0xFB, 0x8C}, {0x8F, 0xD4, 0xA7}}, {{0xFB, 0x8D}, {0x8F, 0xF4, 0xDC}},
	{{0xFB, 0x8E}, {0x8F, 0xF4, 0xDD}}, {{0xFB, 0x8F}, {0x8F, 0xD4, 0xD4}},
	{{0xFB, 0x90}, {0x8F, 0xD4, 0xF2}}, {{0xFB, 0x91}, {0x8F, 0xD5, 0xAE}},
	{{0xFB, 0x92}, {0x8F, 0xF4, 0xDE}}, {{0xFB, 0x93}, {0x8F, 0xD7, 0xDE}},
	{{0xFB, 0x94}, {0x8F, 0xF4, 0xDF}}, {{0xFB, 0x95}, {0x8F, 0xD8, 0xA2}},
	{{0xFB, 0x96}, {0x8F, 0xD8, 0xB7}}, {{0xFB, 0x97}, {0x8F, 0xD8, 0xC1}},
	{{0xFB, 0x98}, {0x8F, 0xD8, 0xD1}}, {{0xFB, 0x99}, {0x8F, 0xD8, 0xF4}},
	{{0xFB, 0x9A}, {0x8F, 0xD9, 0xC6}}, {{0xFB, 0x9B}, {0x8F, 0xD9, 0xC8}},
	{{0xFB, 0x9C}, {0x8F, 0xD9, 0xD1}}, {{0xFB, 0x9D}, {0x8F, 0xF4, 0xE0}},
	{{0xFB, 0x9E}, {0x8F, 0xF4, 0xE1}}, {{0xFB, 0x9F}, {0x8F, 0xF4, 0xE2}},
	{{0xFB, 0xA0}, {0x8F, 0xF4, 0xE3}}, {{0xFB, 0xA1}, {0x8F, 0xF4, 0xE4}},
	{{0xFB, 0xA2}, {0x8F, 0xDC, 0xD3}}, {{0xFB, 0xA3}, {0x8F, 0xDD, 0xC8}},
	{{0xFB, 0xA4}, {0x8F, 0xDD, 0xD4}}, {{0xFB, 0xA5}, {0x8F, 0xDD, 0xEA}},
	{{0xFB, 0xA6}, {0x8F, 0xDD, 0xFA}}, {{0xFB, 0xA7}, {0x8F, 0xDE, 0xA4}},
	{{0xFB, 0xA8}, {0x8F, 0xDE, 0xB0}}, {{0xFB, 0xA9}, {0x8F, 0xF4, 0xE5}},
	{{0xFB, 0xAA}, {0x8F, 0xDE, 0xB5}}, {{0xFB, 0xAB}, {0x8F, 0xDE, 0xCB}},
	{{0xFB, 0xAC}, {0x8F, 0xF4, 0xE6}}, {{0xFB, 0xAD}, {0x8F, 0xDF, 0xB9}},
	{{0xFB, 0xAE}, {0x8F, 0xF4, 0xE7}}, {{0xFB, 0xAF}, {0x8F, 0xDF, 0xC3}},
	{{0xFB, 0xB0}, {0x8F, 0xF4, 0xE8}}, {{0xFB, 0xB1}, {0x8F, 0xF4, 0xE9}},
	{{0xFB, 0xB2}, {0x8F, 0xE0, 0xD9}}, {{0xFB, 0xB3}, {0x8F, 0xF4, 0xEA}},
	{{0xFB, 0xB4}, {0x8F, 0xF4, 0xEB}}, {{0xFB, 0xB5}, {0x8F, 0xE1, 0xE2}},
	{{0xFB, 0xB6}, {0x8F, 0xF4, 0xEC}}, {{0xFB, 0xB7}, {0x8F, 0xF4, 0xED}},
	{{0xFB, 0xB8}, {0x8F, 0xF4, 0xEE}}, {{0xFB, 0xB9}, {0x8F, 0xE2, 0xC7}},
	{{0xFB, 0xBA}, {0x8F, 0xE3, 0xA8}}, {{0xFB, 0xBB}, {0x8F, 0xE3, 0xA6}},
	{{0xFB, 0xBC}, {0x8F, 0xE3, 0xA9}}, {{0xFB, 0xBD}, {0x8F, 0xE3, 0xAF}},
	{{0xFB, 0xBE}, {0x8F, 0xE3, 0xB0}}, {{0xFB, 0xBF}, {0x8F, 0xE3, 0xAA}},
	{{0xFB, 0xC0}, {0x8F, 0xE3, 0xAB}}, {{0xFB, 0xC1}, {0x8F, 0xE3, 0xBC}},
	{{0xFB, 0xC2}, {0x8F, 0xE3, 0xC1}}, {{0xFB, 0xC3}, {0x8F, 0xE3, 0xBF}},
	{{0xFB, 0xC4}, {0x8F, 0xE3, 0xD5}}, {{0xFB, 0xC5}, {0x8F, 0xE3, 0xD8}},
	{{0xFB, 0xC6}, {0x8F, 0xE3, 0xD6}}, {{0xFB, 0xC7}, {0x8F, 0xE3, 0xDF}},
	{{0xFB, 0xC8}, {0x8F, 0xE3, 0xE3}}, {{0xFB, 0xC9}, {0x8F, 0xE3, 0xE1}},
	{{0xFB, 0xCA}, {0x8F, 0xE3, 0xD4}}, {{0xFB, 0xCB}, {0x8F, 0xE3, 0xE9}},
	{{0xFB, 0xCC}, {0x8F, 0xE4, 0xA6}}, {{0xFB, 0xCD}, {0x8F, 0xE3, 0xF1}},
	{{0xFB, 0xCE}, {0x8F, 0xE3, 0xF2}}, {{0xFB, 0xCF}, {0x8F, 0xE4, 0xCB}},
	{{0xFB, 0xD0}, {0x8F, 0xE4, 0xC1}}, {{0xFB, 0xD1}, {0x8F, 0xE4, 0xC3}},
	{{0xFB, 0xD2}, {0x8F, 0xE4, 0xBE}}, {{0xFB, 0xD3}, {0x8F, 0xF4, 0xEF}},
	{{0xFB, 0xD4}, {0x8F, 0xE4, 0xC0}}, {{0xFB, 0xD5}, {0x8F, 0xE4, 0xC7}},
	{{0xFB, 0xD6}, {0x8F, 0xE4, 0xBF}}, {{0xFB, 0xD7}, {0x8F, 0xE4, 0xE0}},
	{{0xFB, 0xD8}, {0x8F, 0xE4, 0xDE}}, {{0xFB, 0xD9}, {0x8F, 0xE4, 0xD1}},
	{{0xFB, 0xDA}, {0x8F, 0xF4, 0xF0}}, {{0xFB, 0xDB}, {0x8F, 0xE4, 0xDC}},
	{{0xFB, 0xDC}, {0x8F, 0xE4, 0xD2}}, {{0xFB, 0xDD}, {0x8F, 0xE4, 0xDB}},
	{{0xFB, 0xDE}, {0x8F, 0xE4, 0xD4}}, {{0xFB, 0xDF}, {0x8F, 0xE4, 0xFA}},
	{{0xFB, 0xE0}, {0x8F, 0xE4, 0xEF}}, {{0xFB, 0xE1}, {0x8F, 0xE5, 0xB3}},
	{{0xFB, 0xE2}, {0x8F, 0xE5, 0xBF}}, {{0xFB, 0xE3}, {0x8F, 0xE5, 0xC9}},
	{{0xFB, 0xE4}, {0x8F, 0xE5, 0xD0}}, {{0xFB, 0xE5}, {0x8F, 0xE5, 0xE2}},
	{{0xFB, 0xE6}, {0x8F, 0xE5, 0xEA}}, {{0xFB, 0xE7}, {0x8F, 0xE5, 0xEB}},
	{{0xFB, 0xE8}, {0x8F, 0xF4, 0xF1}}, {{0xFB, 0xE9}, {0x8F, 0xF4, 0xF2}},
	{{0xFB, 0xEA}, {0x8F, 0xF4, 0xF3}}, {{0xFB, 0xEB}, {0x8F, 0xE6, 0xE8}},
	{{0xFB, 0xEC}, {0x8F, 0xE6, 0xEF}}, {{0xFB, 0xED}, {0x8F, 0xE7, 0xAC}},
	{{0xFB, 0xEE}, {0x8F, 0xF4, 0xF4}}, {{0xFB, 0xEF}, {0x8F, 0xE7, 0xAE}},
	{{0xFB, 0xF0}, {0x8F, 0xF4, 0xF5}}, {{0xFB, 0xF1}, {0x8F, 0xE7, 0xB1}},
	{{0xFB, 0xF2}, {0x8F, 0xF4, 0xF6}}, {{0xFB, 0xF3}, {0x8F, 0xE7, 0xB2}},
	{{0xFB, 0xF4}, {0x8F, 0xE8, 0xB1}}, {{0xFB, 0xF5}, {0x8F, 0xE8, 0xB6}},
	{{0xFB, 0xF6}, {0x8F, 0xF4, 0xF7}}, {{0xFB, 0xF7}, {0x8F, 0xF4, 0xF8}},
	{{0xFB, 0xF8}, {0x8F, 0xE8, 0xDD}}, {{0xFB, 0xF9}, {0x8F, 0xF4, 0xF9}},
	{{0xFB, 0xFA}, {0x8F, 0xF4, 0xFA}}, {{0xFB, 0xFB}, {0x8F, 0xE9, 0xD1}},
	{{0xFB, 0xFC}, {0x8F, 0xF4, 0xFB}}, {{0xFC, 0x40}, {0x8F, 0xE9, 0xED}},
	{{0xFC, 0x41}, {0x8F, 0xEA, 0xCD}}, {{0xFC, 0x42}, {0x8F, 0xF4, 0xFC}},
	{{0xFC, 0x43}, {0x8F, 0xEA, 0xDB}}, {{0xFC, 0x44}, {0x8F, 0xEA, 0xE6}},
	{{0xFC, 0x45}, {0x8F, 0xEA, 0xEA}}, {{0xFC, 0x46}, {0x8F, 0xEB, 0xA5}},
	{{0xFC, 0x47}, {0x8F, 0xEB, 0xFB}}, {{0xFC, 0x48}, {0x8F, 0xEB, 0xFA}},
	{{0xFC, 0x49}, {0x8F, 0xF4, 0xFD}}, {{0xFC, 0x4A}, {0x8F, 0xEC, 0xD6}},
	{{0xFC, 0x4B}, {0x8F, 0xF4, 0xFE}}, {{0x00, 0x00}, {0x00, 0x00, 0x00}},
};

	int
ISkanji(code)
int			code;
{
	if (code >= 0x100)
		return 0;
	return(kanji_map_sjis[code & 0xff] & 1);
}

	int
ISkana(code)
int			code;
{
	if (code >= 0x100)
		return 0;
	return(kanji_map_sjis[code & 0xff] & 2);
}

	int
ISdisp(code)
int			code;
{
	if (code >= 0x100)
		return 0;
	return(kanji_map_sjis[code & 0xff]);
}

/* input pos : 1..strlen
   return  0 : not kanji
	   1 : kanji first byte
	   2 : kanji last byte
*/
	int
ISkanjiPosition(ptr, pos)
char_u	*	ptr;
int			pos;
{
	int	kanji = 0;

	for (; *ptr && pos--; ptr++)
	{
		if (kanji == 1)
			kanji= 2;
		else
		{
			if (kanji_map_sjis[*ptr] & 1)
				kanji= 1;
			else
				kanji= 0;
		}
	}
	return(kanji);
}

	int
ISkanjiPointer(ptr, p)
char_u	*	ptr;
char_u	*	p;
{
	return(ISkanjiPosition(ptr, p - ptr + 1));
}

	int
ISkanjiCol(lnum, col)
linenr_t	lnum;
colnr_t		col;
{
	return(ISkanjiPosition(ml_get_buf(curbuf, lnum, FALSE), col + 1));
}


	int
ISkanjiCur()
{
	return(ISkanjiPosition(ml_get_buf(curbuf, curwin->w_cursor.lnum, FALSE),
						curwin->w_cursor.col + 1));
}

	int
ISkanjiFpos(po)
FPOS	*	po;
{
	return(ISkanjiPosition(ml_get_buf(curbuf, po->lnum, FALSE), po->col + 1));
}

	int
vcol2col(wp, lnum, maxcol, wantcol, num, colum)
WIN		*	wp;
linenr_t	lnum;
colnr_t		maxcol;
int		*	wantcol;
int			num;
int			colum;
{
	char_u	*	line;
	char_u	*	ptr;
	char_u		c;
	colnr_t		vcol;

	ptr = line = ml_get_buf(wp->w_buffer, lnum, FALSE);

	vcol = 0;
	if (num)
		vcol = 8;
	while ((c = *ptr) != NUL)
	{
		if (kanji_map_sjis[c] & 1)
		{
			if (colum && ((int)(vcol % colum) == (colum - 1)))
			{
				vcol++;
				if (vcol > maxcol)
				{
					ptr --;
					if (ISkanjiPointer(line, ptr) == 2)
						ptr --;
					break;
				}
			}
			vcol += 2;
			if (vcol > maxcol)
				break;
			ptr += 2;
			continue;
		}
		if (colum && ptr[1] != NUL && c < ' ' && c != TAB
									&& ((int)(vcol % colum) == (colum - 1)))
		{
			vcol += chartabsize(c, vcol);
			ptr ++;
			continue;
		}
		vcol += chartabsize(c, vcol);
		if (vcol > maxcol)
			break;
		ptr ++;
	}
	if (wantcol != NULL)
	{
		if (c == NUL)
			*wantcol = ptr - line;
		else if (kanji_map_sjis[c] & 1)
			*wantcol = ptr - line + 1;
		else
			*wantcol = ptr - line;
	}
	return(ptr - line);
}

/*
 *	Japanese Character;
 */
	int_u
sjistojis(high, low)
char_u		high;
char_u		low;
{
	if (IS_X0212(high))
	{
		int			i;
		char_u		ss3;
		int_u		euc;

		for (i = 0; altconv[i].sjis[0]; i++)
		{
			if (altconv[i].sjis[0] == high && altconv[i].sjis[1] == low)
			{
				high = altconv[i].alt[0];
				low  = altconv[i].alt[1];
				break;
			}
		}
		if (altconv[i].sjis[0] == 0x00)
		{
			if ((euc = sjistoeuc3(high, low, &ss3)) != 0 && ss3 == 0x00)
				return(euc & 0x7f7f);
			else
				return(0x2020);
		}
	}
	if (high <= 0x9f)
		high -= 0x71;
	else
		high -= 0xb1;
	high = high * 2 + 1;
	if (low > 0x7f)
		low--;
	if (low >= 0x9e)
	{
		low -= 0x7d;
		high++;
	}
	else
	{
		low -= 0x1f;
	}
	return(((int_u)high << 8) | (low & 0xff));
}

	static int_u
sjistoeuc(high, low, ss3)
char_u		high;
char_u		low;
char_u	*	ss3;
{
	*ss3 = 0x00;
	if (IS_X0212(high))
		return(sjistoeuc3(high, low, ss3));
	return(sjistojis(high, low) | 0x8080);
}

	static int_u
sjistoeuc3(high, low, ss3)
char_u		high;
char_u		low;
char_u	*	ss3;
{
	int		i;

	for (i = 0; ss3conv[i].sjis[0]; i++)
	{
		if (ss3conv[i].sjis[0] == high && ss3conv[i].sjis[1] == low)
		{
			*ss3 = ss3conv[i].ss3[0];
			high = ss3conv[i].ss3[1];
			low  = ss3conv[i].ss3[2];
			return(((int_u)high << 8) | (low & 0xff));
		}
	}

/* CAUTION! JISX0213 feature is still EXPERIMENTAL. use TOG standard. */
#ifdef	JISX0213
	if (0x40 <= low && low != 0x7f && low <= 0xfc)
	{
		int_u	gr;

		high = (high - 0xe0) * 2 + 1;
		if (low >= 0x7f)
			low--;
		if (low >= 0x9e)
		{
			high++;
			low -= 0x7d;
		}
		else
			low -= 0x1f;

		if (high == 0x22)
			high += 0x06;
		else if (0x26 <= high && high <= 0x29)
			high += 0x06;
		else if (0x2a <= high)
			high += 0x44;

		gr = (int_u)high << 8 | low;
		gr |= 0x8080;

		*ss3 = JP_EUC_G3;
		return(gr);
	}
#endif

	if (high <= 0xf4)
	{
		*ss3 = 0x00;
		high -= 0x05;
		return(sjistojis(high, low) | 0x8080);
	}
	else
	{
		*ss3 = JP_EUC_G3;
		high -= 0x0a;
	}
	return(sjistojis(high, low) | 0x8080);
}

	int_u
jistosjis(high, low)
char_u		high;
char_u		low;
{
	if (high & 1)
		low += 0x1f;
	else
		low += 0x7d;
	if (low >= 0x7f)
		low++;
	high = ((high - 0x21) >> 1) + 0x81;
	if (high > 0x9f)
		high += 0x40;
	return(((int_u)high << 8) | (low & 0xff));
}

	static int_u
euctosjis(high, low)
char_u		high;
char_u		low;
{
	return(jistosjis((char_u)(high & 0x7f), (char_u)(low & 0x7f)));
}

	static int_u
euctosjis3(high, low)
char_u		high;
char_u		low;
{
	int			i;
	int_u		sjis;

	for (i = 0; ss3conv[i].sjis[0]; i++)
	{
		if (ss3conv[i].ss3[0] == JP_EUC_G3
				&& ss3conv[i].ss3[1] == high && ss3conv[i].ss3[2] == low)
		{
			high = ss3conv[i].sjis[0];
			low  = ss3conv[i].sjis[1];
			return(((int_u)high << 8) | (low & 0xff));
		}
	}

#ifdef	JISX0213
	while (0x21 <= (high & 0x7f) && (high & 0x7f) <= 0x7e
							&& 0x21 <= (low & 0x7f) && (low & 0x7f) <= 0x7e)
	{
		high &= 0x7f;
		low  &= 0x7f;

		if (high == 0x21 || 0x23 <= high && high <= 0x25)
			;
		else if (high == 0x28)
			high -= 0x06;
		else if (0x2c <= high && high <= 0x2f)
			high -= 0x06;
		else if (0x6e <= high && high <= 0x7e)
			high -= 0x44;
		else
			break;

		if (high & 0x01)
			low += 0x7e;
		else
		{
			low += 0x1f;
			if (low > 0x7e)
				low++;
		}
		high = high / 2 + 0xe0;
		sjis = (int_u)high << 8 | low;
		return(sjis);
	}
#endif

	sjis = jistosjis((char_u)(high & 0x7f), (char_u)(low & 0x7f));
	if (0xeb40 <= sjis && sjis <= 0xeffc)
		sjis += 0x0a00;
	return(sjis);
}

/*
 * return kanji shift-in string
 */
	static char_u *
kanjiin(code)
	int		code;
{
	switch(code) {
	case JP_JIS:		return "\033$B";
	default:			return "";
	}
}

/*
 * return kanji shift-out string
 */
	static char_u *
asciiin(code)
	int		code;
{
	switch(code) { 
	case JP_JIS:		return "\033(B";
	default:			return "";
	}
}

/*
 * return kana shift-in string
 */
	static char_u *
kanain(code)
	int		code;
{
	switch(code) { 
	case JP_JIS:		return "\033(I";
	default:			return "";
	}
}

	static char_u *
JPdisp(now, mode, code)
	int		*now;
	int		mode;
	int		code;		/* kanji code */
{
	static	char_u	buffer[32];
	char_u			*p;

	buffer[0] = NUL;
	switch (*now) {
	case JP_ASCII:
		switch (mode) {
		case JP_KANJI:
			p = kanjiin(code);
			if (p)
				STRCAT(buffer, p);
			break;
		case JP_KANA:
			p = kanain(code);
			if (p)
				STRCAT(buffer, p);
			break;
		}
		break;
	case JP_KANJI:
		switch (mode) {
		case JP_ASCII:
			p = asciiin(code);
			if (p)
				STRCAT(buffer, p);
			break;
		case JP_KANA:
			p = kanain(code);
			if (p)
				STRCAT(buffer, p);
			break;
		}
		break;
	case JP_KANA:
		switch (mode) {
		case JP_ASCII:
			p = asciiin(code);
			if (p)
				STRCAT(buffer, p);
			break;
		case JP_KANJI:
			p = kanjiin(code);
			if (p)
				STRCAT(buffer, p);
			break;
		}
		break;
	}
	*now = mode;
	return(buffer);
}

/*
 * convert SJIS letter into suitable letter.
 */
	void
kanjito(k1, k2, code)
	char_u	*k1, *k2;
	int		code;
{
	int_u		kanji;
	char_u		ss3;

	switch(code) {
	case JP_JIS:
		kanji = sjistojis(*k1, *k2);
		*k1 = (kanji & 0xff00) >> 8;
		*k2 = kanji & 0xff;
		break;
	case JP_EUC:
		kanji = sjistoeuc(*k1, *k2, &ss3);
		*k1 = (kanji & 0xff00) >> 8;
		*k2 = kanji & 0xff;
	    break;
#ifdef UCODE
	case JP_UTF8:
	case JP_WIDE:
		multi2wide(k1, k2, 2, TRUE);
		break;
#endif
	default:
		break;
	}
}

	void
kanato(k1, k2, code)
	char_u	*k1, *k2;
	int		code;
{
	switch(code) {
	case JP_JIS:
		*k1 &= 0x7f;
		*k2 = NUL;
		break;
	case JP_EUC:
		*k2 = *k1;
		*k1 = JP_EUC_G2;
	    break;
#ifdef UCODE
	case JP_UTF8:
	case JP_WIDE:
		multi2wide(k1, k2, 1, TRUE);
		break;
#endif
	default:
		*k2 = NUL;
		break;
	}
}

/*
 *	Japanese Character class;
 *					Make sure this routine is consistent with search.c:cls().
 *
 * 	for Japanese
 *		3 - alphabet, digits
 *		4 - japanese hiragana
 *		5 - japanese katakana
 *		6 - symbols
 *		7 - other multi-char letter
 */
	int
jpcls(c, k)
char_u		c;
char_u		k;
{
	if (c == ' ' || c == '\t' || c == NUL)
		return 0;
	if (kanji_map_sjis[c] & 1)
	{
		int		ret;
		ret = sjistojis(c, k);
		c = ((int_u)ret & 0xff00) >> 8;
		k =  (int_u)ret & 0xff;
		ret = jptab[c & 0x7f].cls1;
		if (ret == JPC_KIGOU)
			ret = jptab[k & 0x7f].cls2;
		if (ret == JPC_KIGOU2)
			ret = JPC_KIGOU;
		return ret;
	}
	if (kanji_map_sjis[c] & 2)
		return JPC_KANA;
	if (isidchar(c))
		return 1;
	return -1;
}

/* 
 *	isjppunc(c, k) returns whether a kanji character ck necessary KINSOKU
 *	processing or not.
 */
	int
isjppunc(c, k, type)
char_u		c;
char_u		k;
int			type;
{
	int		jis;

	jis = sjistojis(c, k);
	c = ((int_u)jis & 0xff00) >> 8;
	k =  (int_u)jis & 0xff;
	switch(jptab[c & 0x7f].cls1)
	{
	case JPC_KIGOU:
		return type ? jptab[k & 0x7f].punccsym : jptab[k & 0x7f].puncosym;
	case JPC_HIRA:
	case JPC_KATA:
		return type ? jptab[k & 0x7f].puncckana : FALSE;
	default:
		return FALSE;
	}
}

/* 
 *	isaspunc(c, type) returns whether an ascii character ck necessary KINSOKU
 *	processing or not.
 */
	int
isaspunc(c, type)
char_u		c;
int			type;
{
	return(type ? jptab[c & 0x7f].punccasc: jptab[c & 0x7f].puncoasc);
}

/* 
 *	isjsend(*cp) returns whether a JIS character *cp separates
 *	sentences or not.
 */
	int
isjsend(cp)
char_u	*	cp;
{
	int	kanji	= sjistojis(cp[0], cp[1]);
	int	k1		= (kanji & 0xff00) >> 8;
	int	k2		= kanji & 0xff;
	return k1 == '!' && jptab[k2 & 0x7f].stcend;
}

/* 
 *	jptocase(&c, &k, tocase)
 *		modify c & k to case tocase
 *			tocase == UPPER : to upper
 *			tocase == LOWER : to lower
 *			tocase == others : swap case
 */
	void
jptocase(cp, kp, tocase)
char_u	*	cp;
char_u	*	kp;
int			tocase;
{
	char_u		k;
	int_u		kanji = sjistojis(*cp, *kp);

	*cp	= (kanji & 0xff00) >> 8;
	*kp = kanji & 0xff;
	k = *kp & 0x7f;
	switch(jptab[*cp & 0x7f].cls1) {
	case JPC_ALNUM:
		if (tocase != LOWER && islower(k))
			*kp = TO_UPPER(k);
		if (tocase != UPPER && isupper(k))
			*kp = TO_LOWER(k);
		break;
	case JPC_KIGOU:
		if (  (tocase != LOWER && jptab[k & 0x7f].scase == JLOS)
		   || (tocase != UPPER && jptab[k & 0x7f].scase == JUPS))
			*kp = jptab[k & 0x7f].swap;
		break;
	case JPC_KATA:
		if (tocase != -1)
			*cp = JP1_HIRA;
		break;
	case JPC_HIRA:
		if (tocase != 1)
			*cp = JP1_KATA;
		break;
	default:
		break;
	}
	kanji = jistosjis(*cp, *kp);
	*cp	= (kanji & 0xff00) >> 8;
	*kp = kanji & 0xff;
}

/* 
 *	isspace(c, k) returns whether a kanji character ck space
 */
	int
isjpspace(c, k)
char_u		c;
char_u		k;
{
	int		jis;

	jis = sjistojis(c, k);
	c = ((int_u)jis & 0xff00) >> 8;
	k =  (int_u)jis & 0xff;
	switch(jptab[c & 0x7f].cls1)
	{
	case JPC_KIGOU:
		return jptab[k & 0x7f].cls2 == 0 ? TRUE : FALSE;
	default:
		return FALSE;
	}
}

/*
 *
 *
 */
#ifdef UCODE
	static int
judge_sjis_euc(ptr)
char_u	*	ptr;
{
	if (((0xa1 <= ptr[0] && ptr[0] <= 0xfe)
				&& (0xa1 <= ptr[1] && ptr[1] <= 0xfe))
			|| (ptr[0] == 0x8e && (0xa1 <= ptr[1] && ptr[1] <= 0xdf))
			|| (ptr[0] == 0x8f && (0xa1 <= ptr[1] && ptr[1] <= 0xfe)))
		return(TRUE);/* EUC */
	else if ((((0x81 <= ptr[0] && ptr[0] <= 0x9f)
					|| (0xe0 <= ptr[0] && ptr[0] <= 0xef))
				&& ((0x40 <= ptr[1] && ptr[1] <= 0x7e)
					|| (0x80 <= ptr[1] && ptr[1] <= 0xfc)))
			|| (0xa1 <= ptr[0] && ptr[0] <= 0xdf))
		return(TRUE);/* SJIS */
	return(FALSE);
}

	static int
judge_ucs(ptr)
char_u	*	ptr;
{
	short_u	ucs;
	char_u	dst[2];

	if (ptr[0] < 0xe0)
		ucs = ((ptr[0] & 0x1f) << 6) | (ptr[1] & 0x3f);
	else
		ucs = ((ptr[0] & 0x0f) << 12) | ((ptr[1] & 0x3f) << 6) | (ptr[2] & 0x3f);
	dst[1] = ucs & 255;
	dst[0] = ucs >> 8;
	if (wide2multi(dst, 2, TRUE, FALSE) == 1 && dst[0] == '?')
		return(FALSE);
	return(TRUE);
}
#endif

/*
 *
 *
 */
	int
judge_jcode(origcode, ubig, ptr, size)
char_u	*	origcode;
int		*	ubig;
char_u	*	ptr;
long		size;
{
	char	code;
	int		i;
	int		bfr  = FALSE;	/* Kana Moji */
	int		bfk  = 0;		/* EUC Kana */
	int		sjis = 0;
	int		euc  = 0;
#ifdef UCODE
	int		utf8 = 0;
	int		bfu  = 0;
#endif

	code = '\0';
#ifdef UCODE
	if ((ptr[0] == 0xff && ptr[1] == 0xfe)
							|| (ptr[0] == 0xfe && ptr[1] == 0xff))
	{
		if (ptr[0] == 0xfe && ptr[1] == 0xff)
			*ubig = TRUE;
		else
			*ubig = FALSE;
		code = 'U';		/* UNICODE */
		goto breakBreak;
	}
	if (ptr[0] == 0xef && ptr[1] == 0xbb && ptr[2] == 0xbf)
	{
		code = 'T';		/* MS UTF8 */
		goto breakBreak;
	}
	if (*origcode == 'U')
		*origcode = 'S';

	/* valid UTF-8 or not */
	i = 0;
	while (i < size)
	{
		if (ptr[i] < 0x80)
			i++;
		else if (ptr[i] < 0xc0)
		{
			/* malformed */
			utf8 = 0;
			break;
		}
		else if (ptr[i] < 0xe0)
		{
			if (size - i > 1)
			{
				if (ptr[i + 1] >= 0x80 && ptr[i + 1] < 0xc0)
				{
					if (judge_sjis_euc(&ptr[i]))
						;
					else if (judge_ucs(&ptr[i]))
						utf8++;
				}
				else
				{
					/* malformed */
					utf8 = 0;
					break;
				}
			}
			i += 2;
		}
		else if (ptr[i] < 0xf0)
		{
			if (size - i > 2)
			{
				if (ptr[i + 1] >= 0x80 && ptr[i + 1] < 0xc0
						&& ptr[i + 2] >= 0x80 && ptr[i + 2] < 0xc0)
				{
					if (judge_sjis_euc(&ptr[i]))
						;
					else if (judge_ucs(&ptr[i]))
						utf8++;
				}
				else
				{
					/* malformed */
					utf8 = 0;
					break;
				}
			}
			i += 3;
		}
		else if (ptr[i] < 0xf8)
		{
			/* valid but not supported */
			if (size - i > 3)
			{
				if (!(ptr[i + 1] >= 0x80 && ptr[i + 1] < 0xc0
						&& ptr[i + 2] >= 0x80 && ptr[i + 2] < 0xc0
						&& ptr[i + 3] >= 0x80 && ptr[i + 3] < 0xc0))
				{
					/* malformed */
					utf8 = 0;
					break;
				}
			}
			i += 4;
		}
		else if (ptr[i] < 0xfc)
		{
			/* valid but not supported */
			if (size - i > 4)
			{
				if (!(ptr[i + 1] >= 0x80 && ptr[i + 1] < 0xc0
						&& ptr[i + 2] >= 0x80 && ptr[i + 2] < 0xc0
						&& ptr[i + 3] >= 0x80 && ptr[i + 3] < 0xc0
						&& ptr[i + 4] >= 0x80 && ptr[i + 4] < 0xc0))
				{
					/* malformed */
					utf8 = 0;
					break;
				}
			}
			i += 5;
		}
		else if (ptr[i] < 0xfe)
		{
			/* valid but not supported */
			if (size - i > 5)
			{
				if (!(ptr[i + 1] >= 0x80 && ptr[i + 1] < 0xc0
						&& ptr[i + 2] >= 0x80 && ptr[i + 2] < 0xc0
						&& ptr[i + 3] >= 0x80 && ptr[i + 3] < 0xc0
						&& ptr[i + 4] >= 0x80 && ptr[i + 4] < 0xc0
						&& ptr[i + 5] >= 0x80 && ptr[i + 5] < 0xc0))
				{
					/* malformed */
					utf8 = 0;
					break;
				}
			}
			i += 6;
		}
		else
		{
			/* malformed */
			utf8 = 0;
			break;
		}
	}
	if (utf8 > 1)
	{
		code = 'T';
		goto breakBreak;
	}
#endif /* UCODE */

	i = 0;
	while (i < size)
	{
		if (ptr[i] == '\033' && (size - i >= 3))
		{
			if ((ptr[i+1] == '$' && ptr[i+2] == 'B')
						 || (ptr[i+1] == '(' && ptr[i+2] == 'B'))
			{
				code = 'J';
#ifdef USE_OPT
				if (!(p_opt & OPT_NO_JIS))
					i += 3;
				else
#endif
				goto breakBreak;
			}
			else if ((ptr[i+1] == '$' && ptr[i+2] == '@')
						 || (ptr[i+1] == '(' && ptr[i+2] == 'J'))
			{
				code = 'J';
#ifdef USE_OPT
				if (!(p_opt & OPT_NO_JIS))
					i += 3;
				else
#endif
				goto breakBreak;
			}
			else if (ptr[i+1] == '(' && ptr[i+2] == 'I')
			{
				code = 'J';
				i += 3;
			}
			else if (ptr[i+1] == ')' && ptr[i+2] == 'I')
			{
				code = 'J';
				i += 3;
			}
			else
				i++;
			bfr = FALSE;
			bfk = 0;
		}
		else
		{
			if (ptr[i] < 0x20)
			{
#ifndef UCODE
				if (bfr == TRUE)
				{
					code = 'S';
					goto breakBreak;
				}
#endif
				bfr = FALSE;
				bfk = 0;
				/* ?? check kudokuten ?? && ?? hiragana ?? */
				if ((i >= 2) && (ptr[i-2] == 0x81)
						&& (0x41 <= ptr[i-1] && ptr[i-1] <= 0x49))
				{
					code = 'S';
					sjis += 100;	/* kudokuten */
				}
				else if ((i >= 2) && (ptr[i-2] == 0xa1)
						&& (0xa2 <= ptr[i-1] && ptr[i-1] <= 0xaa))
				{
					code = 'E';
					euc  += 100;	/* kudokuten */
				}
				else if ((i >= 2) && (ptr[i-2] == 0x82) && (0xa0 <= ptr[i-1]))
					sjis += 40;		/* hiragana */
				else if ((i >= 2) && (ptr[i-2] == 0xa4) && (0xa0 <= ptr[i-1]))
					euc  += 40;		/* hiragana */
#ifdef UCODE
				else if ((0xa1 <= ptr[i-2] && ptr[i-2] <= 0xfe)
								&& (0xa1 <= ptr[i-1] && ptr[i-1] <= 0xfe))
					;	/* EUC */
				else if (0x8e == ptr[i-2]
								&& (0xa1 <= ptr[i-1] && ptr[i-1] <= 0xdf))
					;	/* EUC */
				else if (((0x81 <= ptr[i-2] && ptr[i-2] <= 0x9f)
								|| (0xe0 <= ptr[i-2] && ptr[i-2] <= 0xef))
						&& ((0x40 <= ptr[i-1] && ptr[i-1] <= 0x7e)
								|| (0x80 <= ptr[i-1] && ptr[i-1] <= 0xfc)))
					;	/* SJIS */
				else if ((i >= 3) && (ptr[i-3] & 0xf0) == 0xe0
											&& (ptr[i-2] & 0xc0) == 0x80
											&& (ptr[i-1] & 0xc0) == 0x80)
				{
					code = 'T';
					utf8  += 30;
				}
				else if ((i >= 2) && (ptr[i-2] & 0xe0) == 0xc0
											&& (ptr[i-1] & 0xc0) == 0x80)
				{
					code = 'T';
					utf8  += 10;
				}
#endif
			}
			else
			{
				/* ?? check hiragana or katana ?? */
				if ((size - i > 1) && (ptr[i] == 0x82) && (0xa0 <= ptr[i+1]))
					sjis++;	/* hiragana */
				else if ((size - i > 1) && (ptr[i] == 0x83)
						&& (0x40 <= ptr[i+1] && ptr[i+1] <= 0x9f))
					sjis++;	/* katakana */
				else if ((size - i > 1) && (ptr[i] == 0xa4) && (0xa0 <= ptr[i+1]))
					euc++;	/* hiragana */
				else if ((size - i > 1) && (ptr[i] == 0xa5) && (0xa0 <= ptr[i+1]))
					euc++;	/* katakana */
#ifdef UCODE
				if (bfu)
					bfu--;
				else
#endif
				if (bfr == TRUE)
				{
					if ((i >= 1) && (0x40 <= ptr[i] && ptr[i] <= 0xa0) && ISkanji(ptr[i-1]))
					{
						code = 'S';
						goto breakBreak;
					}
					else if ((i >= 1) && (0x81 <= ptr[i-1] && ptr[i-1] <= 0x9f) && ((0x40 <= ptr[i] && ptr[i] < 0x7e) || (0x7e < ptr[i] && ptr[i] <= 0xfc)))
					{
						code = 'S';
						goto breakBreak;
					}
					else if ((i >= 1) && (0xfd <= ptr[i] && ptr[i] <= 0xfe) && (0xa1 <= ptr[i-1] && ptr[i-1] <= 0xfe))
					{
						code = 'E';
						goto breakBreak;
					}
					else if ((i >= 1) && (0xfd <= ptr[i-1] && ptr[i-1] <= 0xfe) && (0xa1 <= ptr[i] && ptr[i] <= 0xfe))
					{
						code = 'E';
						goto breakBreak;
					}
					else if ((i >= 1) && (ptr[i] < 0xa0 || 0xdf < ptr[i]) && (0x8e == ptr[i-1]))
					{
						code = 'S';
						goto breakBreak;
					}
					else if (ptr[i] <= 0x7f)
					{
						code = 'S';
						goto breakBreak;
					}
					else
					{
						if (0xa1 <= ptr[i] && ptr[i] <= 0xa6)
							euc++;	/* sjis hankaku kana kigo */
						else if (0xa1 <= ptr[i] && ptr[i] <= 0xdf)
							;	/* sjis hankaku kana */
						else if (0xa1 <= ptr[i] && ptr[i] <= 0xfe)
							euc++;
						else if (0x8e == ptr[i])
							euc++;
						else if (0x20 <= ptr[i] && ptr[i] <= 0x7f)
							sjis++;
						bfr = FALSE;
						bfk = 0;
					}
				}
#ifdef UCODE
				else if ((size - i > 3) && (ptr[i] & 0xf0) == 0xe0
											&& (ptr[i+1] & 0xc0) == 0x80
											&& (ptr[i+2] & 0xc0) == 0x80
										&& ((ptr[i+3] & 0x80) == 0x00
											|| (ptr[i+3] & 0xf0) == 0xe0
											|| (ptr[i+3] & 0xe0) == 0xc0)
						&& !((0xa1 <= ptr[i] && ptr[i] <= 0xfe)
								&& (0xa1 <= ptr[i+1] && ptr[i+1] <= 0xfe)
								&& (0xa1 <= ptr[i+2] && ptr[i+2] <= 0xfe)))
				{
					utf8++;
					bfu = 2;
					bfk = 0;
				}
				else if ((size - i > 2) && (ptr[i] & 0xe0) == 0xc0
											&& (ptr[i+1] & 0xc0) == 0x80
										&& ((ptr[i+2] & 0x80) == 0x00
											|| (ptr[i+2] & 0xf0) == 0xe0
											|| (ptr[i+2] & 0xe0) == 0xc0)
						&& !((0xa1 <= ptr[i] && ptr[i] <= 0xfe)
								&& (0xa1 <= ptr[i+1] && ptr[i+1] <= 0xfe)))
				{
					utf8++;
					bfu = 1;
					bfk = 0;
				}
#endif
				else if (0x8e == ptr[i])
				{
					if (size - i <= 1)
						;
					else if (0xa1 <= ptr[i+1] && ptr[i+1] <= 0xdf)
					{
						/* EUC KANA or SJIS KANJI */
						if (bfk == 1)
							euc += 100;
						bfk++;
						i++;
					}
					else
					{
						/* SJIS only */
						code = 'S';
						goto breakBreak;
					}
				}
				else if (0x8f == ptr[i])
				{
					if (size - i <= 2)
						;
					else if ((0xa1 <= ptr[i+1] && ptr[i+1] <= 0xfe)
							&& (0xa1 <= ptr[i+2] && ptr[i+2] <= 0xfe))
					{
						euc += 10;
						i += 2;
					}
					else
					{
						/* SJIS only */
						code = 'S';
						goto breakBreak;
					}
				}
				else if (0x81 <= ptr[i] && ptr[i] <= 0x9f)
				{
					/* SJIS only */
					code = 'S';
					if ((size - i >= 1)
							&& ((0x40 <= ptr[i+1] && ptr[i+1] <= 0x7e)
								|| (0x80 <= ptr[i+1] && ptr[i+1] <= 0xfc)))
						goto breakBreak;
				}
				else if (0xfd <= ptr[i] && ptr[i] <= 0xfe)
				{
					/* EUC only */
					code = 'E';
					if ((size - i >= 1)
								&& (0xa1 <= ptr[i+1] && ptr[i+1] <= 0xfe))
						goto breakBreak;
				}
				else if (ptr[i] <= 0x7f)
					;
				else
				{
					bfr = TRUE;
					bfk = 0;
				}
			}
			i++;
		}
	}
	if (code == '\0')
	{
		code = *origcode;
#ifdef UCODE
		if (utf8 > sjis && utf8 > euc)
			code = 'T';
		else
#endif
		if (sjis > euc)
			code = 'S';
		else if (sjis < euc)
			code = 'E';
	}
breakBreak:
	return(code);
}

	int				/* return the length of dst */
kanjiconvsfrom(ptr, ptrlen, dst, dstlen, tail, code, charsetp)
	char_u	*ptr;
	int		ptrlen;
	char_u	*dst;
	int		dstlen;
	char	*tail;
	char	code;
	int		*charsetp;
{
	char_u	*dtop;
	int		c;
	int		charset;

	dtop = dst;
	if (tail)
		tail[0] = NUL;

	switch (code) {
	case JP_EUC:
	case JP_SJIS:
	case JP_JIS:
#ifdef UCODE
	case JP_UTF8:
#endif
		if (charsetp)
			charset = *charsetp;
		else
			charset = JP_ASCII;
		while (ptrlen) {
			if (dst - dtop >= dstlen)
				return -1;
			ptrlen --;

			if (*ptr & 0x80)
			{
				charset = JP_ASCII;
				switch (code) {
				case JP_EUC:
					switch (kanji_map_euc[*ptr]) {
					case 1:		/* kanji */
						if (ptrlen >= 1 && ptr[1] != NUL)
						{					/* JIS0208 char. */
							*dst++ = (euctosjis(ptr[0], ptr[1]) & 0xff00) >> 8;
							*dst++ = euctosjis(ptr[0], ptr[1]) & 0xff;
							if (dst[-1] == '\0')
								dst[-2] = dst[-1] = ' ';
							ptr += 2;
							ptrlen --;
						}
						else if (tail && ptrlen == 0)
						{					/* not completed  */
							tail[0] = *ptr;
							tail[1] = NUL;
						}
						else
						{					/* Illegal char  */
							*(dst - 1) &= 0x7f;
						}
						continue;
					case 3:		/* kanji */
						if (ptrlen >= 2 && ptr[2] != NUL)
						{					/* JIS0208 char. */
							*dst++ = (euctosjis3(ptr[1], ptr[2]) & 0xff00) >> 8;
							*dst++ = euctosjis3(ptr[1], ptr[2]) & 0xff;
							if (dst[-1] == '\0')
								dst[-2] = dst[-1] = ' ';
							ptr += 3;
							ptrlen -= 2;
						}
						else if (tail && ptrlen < 1)
						{					/* not completed  */
							tail[0] = ptr[0];
							tail[1] = (ptrlen == 0 ? NUL : ptr[1]);
							tail[2] = NUL;
						}
						else
						{					/* Illegal char  */
							*(dst - 1) &= 0x7f;
						}
						continue;
					case 2:
						if (ptr[1] != NUL)
						{
							if (p_jkc && ISkana(ptr[1]))
							{
								char_u c1 = NUL;
								char_u c2 = NUL;

								if ((ptrlen >= 3) && (ptr[2] == JP_EUC_G2))
								{
									if (jisx0201rto0208(ptr[1], ptr[3], &c1, &c2))
									{
										ptr += 4;
										*dst++ = c1;
										*dst++ = c2;
										ptrlen -= 3;
									}
									else
									{
										ptr += 2;
										*dst++ = c1;
										*dst++ = c2;
										ptrlen --;
									}
								}
								else
								{
									(void)jisx0201rto0208(ptr[1], NUL, &c1, &c2);
									ptr += 2;
									*dst++ = c1;
									*dst++ = c2;
									ptrlen --;
								}
							}
							else
							{
								*dst++  = * ++ptr;
								ptr++;
								ptrlen --;
							}
							continue;
						}
						if (tail && ptrlen == 0)
						{					/* not completed  */
							tail[0] = *ptr;
							tail[1] = NUL;
							continue;
						}
						break;
					default:
						if (!kanji_map_sjis[*ptr])
							*dst ++ = *ptr ++;
						else
						{
							*dst = *ptr & 0x7f;
							ptr++;
							dst++;
						}
						break;
					}
					break;
				case JP_SJIS:
					c = *dst ++ = *ptr ++;
					if (kanji_map_sjis[c] & 1)
					{
						if (ptrlen >= 1 && *ptr != NUL)
						{
							* dst++ = * ptr++;
							if (dst[-1] == '\0')
								dst[-2] = dst[-1] = ' ';
							ptrlen --;
						}
						else if (tail && ptrlen == 0)
						{
							tail[0] = c;
							tail[1] = NUL;
							dst--;
						}
						else
						{
							*(dst - 1) &= 0x7f;
						}
						continue;
					}
					else if (p_jkc && ISkana(c))
					{					/* JIS X 0201R 8bit encoding */
						char_u c1 = NUL;

						if (jisx0201rto0208((char_u)c, (char_u)(ptrlen ? *ptr : NUL), &dst[-1], &c1))
						{	/* 2 characters -> double byte character. */
							* dst++ = c1;
							ptr ++;
							ptrlen --;
						}
						else if (c1)
							* dst++ = c1;
						continue;
					}
					break;
#ifdef UCODE
				case JP_UTF8:
					c = *ptr++;
					if (c < 0xc0)
					{ /* malformed */
						*dst++ = '?';
					}
					else if (c < 0xe0 && ptrlen >= 1)
					{
						short_u ucs = ((c & 0x1f) << 6) | (ptr[0] & 0x3f);
						int len;
						dst[1] = ucs & 255;
						dst[0] = ucs >> 8;
						len = wide2multi(dst, 2, TRUE, FALSE);
						dst += len;
						ptr += 1;
						ptrlen--;
					}
					else if (c < 0xf0 && ptrlen >= 2)
					{
						short_u ucs = ((c & 0x0f) << 12) |
							((ptr[0] & 0x3f) << 6) | (ptr[1] & 0x3f);
						int len;
						dst[1] = ucs & 255;
						dst[0] = ucs >> 8;
						len = wide2multi(dst, 2, TRUE, FALSE);
						dst += len;
						ptr += 2;
						ptrlen -= 2;
					}
					else if (c < 0xf8 && ptrlen >= 3)
					{
						ptr += 3;
						ptrlen -= 3;
						*dst++ = '?';
					}
					else if (c < 0xfc  && ptrlen >= 4)
					{
						ptr += 4;
						ptrlen -= 4;
						*dst++ = '?';
					}
					else if (c < 0xfe  && ptrlen >= 5)
					{
						ptr += 5;
						ptrlen -= 5;
						*dst++ = '?';
					}
					else
					{ /* malformed */
						*dst++ = '?';
					}
					if (tail && ptrlen == 0)
					{					/* not completed  */
						tail[0] = *ptr;
						tail[1] = NUL;
						continue;
					}
					break;
#endif /* UCODE */
				default:
					if (!kanji_map_sjis[*ptr])
						*dst ++ = *ptr ++;
					else
					{
						*dst = *ptr & 0x7f;
						dst++;
						ptr++;
					}
					break;
				}
			}
			else
			{
				c = *dst ++ = *ptr ++;
#ifdef USE_OPT
				if (c == ESC && (code == JP_JIS || !(p_opt & OPT_NO_JIS)))
#else
				if (c == ESC)
#endif
				{
					dst --;

					if (ptrlen == 0)
					{
						if (tail && code == JP_JIS)
						{
							tail[0] = c;
							tail[1] = NUL;
						}
						else
							dst++;
						continue;
					}

					if (*ptr == '(')
					{
						ptrlen --;
						ptr ++;

						if (ptrlen == 0)
						{
							if (tail && code == JP_JIS)
							{
								tail[0] = c;
								tail[1] = '(';
								tail[2] = NUL;
							}
							else
							{
								dst ++;
								* dst++ = '(';
							}
							continue;
						}

						if (*ptr == 'I')
						{						/* JIS X 0201R ISO2022 encoding */
							charset = JP_KANA;
							ptr ++;
							ptrlen --;
							continue;
						}
						else if (*ptr == 'J' || *ptr == 'H' || *ptr == 'B')
						{						/* ASCII/JIS In */
							charset = JP_ASCII;
							ptr ++;
							ptrlen --;
							continue;
						}
						else
						{
							dst ++;
							* dst++ = '(';
							continue;
						}
					}

					if (*ptr == '$')
					{
						ptrlen --;
						ptr ++;

						if (ptrlen == 0)
						{
							if (tail && code == JP_JIS)
							{
								tail[0] = c;
								tail[1] = '$';
								tail[2] = NUL;
							}
							else
							{
								dst ++;
								* dst++ = '$';
							}
							continue;
						}

						if (*ptr == '@' || *ptr == 'B')		/* Kanji In */
						{
							charset = JP_KANJI;
							ptrlen --;
							ptr ++;
							continue;
						}
						else
						{
							dst ++;
							* dst ++ = '$';
							continue;
						}
					}
					else
						dst++;
				}
				switch (charset)
				{
					case JP_ASCII:
						break;

					case JP_KANA:
						if (p_jkc)
						{					/* JIS X 0201R 8bit encoding */
							char_u c1 = NUL;

							if (jisx0201rto0208((char_u)c, (char_u)(ptrlen ? *ptr : NUL), &dst[-1], &c1))
							{	/* 2 characters -> double byte character. */
								* dst++ = c1;
								ptr ++;
								ptrlen --;
							}
							else if (c1)
								* dst++ = c1;
							continue;
						}
						else
						{
							dst[-1] |= 0x80;
						}
						break;

					default: /* JP_KANJI */
						if (ptrlen == 0)
						{
							if (tail && code == JP_JIS)
							{
								tail[0] = c;
								tail[1] = NUL;
								dst --;
							}
						}
						else if (c > ' ' && *ptr > ' ')
						{
							ptrlen --;
							dst[-1] = (jistosjis(ptr[-1], ptr[0]) & 0xff00) >> 8;
							dst[0]  = jistosjis(ptr[-1], ptr[0]) & 0xff;
							if (dst[0] == '\0')
								dst[-1] = dst[0] = ' ';
							dst++;
							ptr++;
						}
						else if (c == NUL || c == '\n' || c == '\r')
							charset = JP_ASCII;
				}
			}
		}
		if (charsetp)
			*charsetp = charset;
		break; /* return dst - dtop; */
#ifdef UCODE
	case JP_WIDE:		/* UNICODE */
#endif
	default:
		while (ptrlen)
		{
			*dst ++ = *ptr ++;
			ptrlen --;
			if (dst - dtop > dstlen)
				return -1;
		}
		break; /* return dst - dtop; */
	}
	return dst - dtop;
}

#ifdef UCODE
# define TO_UTF8(ucs, ptr) \
				if (ucs < 0x80) { *ptr ++ = ucs; } \
				else if (ucs < 0x800) { \
					*ptr ++ = (ucs >> 6) | 0xc0; \
					*ptr ++ = (ucs & 0x3f) | 0x80; \
				} else { \
					*ptr ++ = (ucs >> 12) | 0xe0; \
					*ptr ++ = ((ucs >> 6) & 0x3f) | 0x80; \
					*ptr ++ = (ucs & 0x3f) | 0x80; }
#endif

	char_u *
kanjiconvsto(ptr, code, ubig)
	char_u	*ptr;
	int		code;
	int		ubig;
{
	char_u	*top, *ptr2;
	char_u	*cp;
	char_u	ss3;
	int_u	kanji;
	int		nshift;
	int		mode;

	if (ptr == NULL)
		return ptr;

	top = ptr;

	switch (code) {
	case JP_SJIS:
		nshift = STRLEN(ptr) + 1;
		top = alloc(nshift);
		memcpy((char *)top, (char *)ptr, nshift);
		top[nshift - 1] = '\0';
		return top;
#ifdef UCODE
	case JP_UTF8:
		for(nshift = 0; *ptr; ptr++)
		{
			switch (kanji_map_sjis[*ptr]) {
			case 1:
				nshift += 2;
				ptr++;
				break;
			case 2:
				nshift += 2;
				break;
			}
		}
		ptr = top;
		top = ptr2 = alloc(STRLEN(top) + nshift + 1);
		while (*ptr)
		{
			char_u buf[2];
			switch (kanji_map_sjis[*ptr]) {
			case 1:		/* kanji */
				buf[0] = ptr[0];
				buf[1] = ptr[1];
				multi2wide(buf, buf + 1, 2, TRUE);
				kanji = buf[1] | (buf[0] << 8);
				TO_UTF8(kanji, ptr2);
				ptr += 2;
				break;
			case 2:		/* kana */
				buf[0] = ptr[0];
				buf[1] = '\0';
				multi2wide(buf, buf + 1, 1, TRUE);
				kanji = buf[1] | (buf[0] << 8);
				TO_UTF8(kanji, ptr2);
				ptr += 1;
				break;
			default:	/* ascii */
				*ptr2 ++ = *ptr ++;
				break;
			}
		}
		*ptr2 = NUL;
		return top;
	case JP_WIDE:		/* UNICODE */
		for (nshift = 0; *ptr; ptr++)
		{
			switch (kanji_map_sjis[*ptr]) {
			case 1:
				ptr++;
				break;
			default:
				nshift++;
				break;
			}
		}
		ptr = top;
		top = ptr2 = alloc(STRLEN(top) + nshift + 2);
		while (*ptr)
			switch (kanji_map_sjis[*ptr]) {
			case 1:		/* kanji */
				ptr2[0] = ptr[0];
				ptr2[1] = ptr[1];
				multi2wide(&ptr2[0], &ptr2[1], 2, ubig);
				ptr  += 2;
				ptr2 += 2;
				break;
			default:
				ptr2[0] = ptr[0];
				ptr2[1] = 0;
				multi2wide(&ptr2[0], &ptr2[1], 1, ubig);
				ptr  += 1;
				ptr2 += 2;
				break;
			}
		ptr2[0] = ptr[0];
		ptr2[1] = 0;
		multi2wide(&ptr2[0], &ptr2[1], 1, ubig);
		return top;
#endif /* UCODE */
	case JP_EUC:
		for(nshift = 0; *ptr; ptr++)
		{
			switch (kanji_map_sjis[*ptr]) {
			case 1:
				if (IS_X0212(*ptr))
					nshift++;
				ptr++;
				break;
			case 2:
				nshift++;
				break;
			}
		}
		ptr = top;
		top = ptr2 = alloc(STRLEN(top) + nshift + 1);
		while (*ptr)
			switch (kanji_map_sjis[*ptr]) {
			case 1:		/* kanji */
				kanji = sjistoeuc(ptr[0], ptr[1], &ss3);
				if (ss3)
					*ptr2 ++ = ss3;
				*ptr2 ++ = (kanji & 0xff00) >> 8;
				*ptr2 ++ = kanji & 0xff;
				ptr += 2;
				break;
			case 2:		/* kana */
				*ptr2 ++ = JP_EUC_G2;
				*ptr2 ++ = *ptr ++;
				break;
			default:	/* ascii */
				*ptr2 ++ = *ptr ++;
				break;
			}
		*ptr2 = NUL;
		return top;
	case JP_JIS:
		kanji = 0;
		for(nshift = 0; *ptr; ptr++)
		{
			switch (kanji_map_sjis[*ptr]) {
			case 1:
				ptr++;
				if (kanji != 1)
					nshift++;
				kanji = 1;
				break;
			case 2:
				if (kanji != 2)
					nshift++;
				kanji = 2;
				break;
			default:
				if (kanji != 0)
					nshift++;
				kanji = 0;
				break;
			}
		}
		if (nshift)
			nshift++;		/* eol code */

		ptr = top;
		top = ptr2 = alloc(STRLEN(top) + (nshift * 3 * 2/*safe*/) + 1);
		mode = JP_ASCII;
		while (*ptr)
		{
			switch (kanji_map_sjis[*ptr]) {
			case 1:		/* kanji */
				cp = JPdisp(&mode, JP_KANJI, code);
				for(; *cp;)
					*ptr2++ = *cp++;
				kanji = sjistojis(ptr[0], ptr[1]);
				*ptr2 ++ = (kanji & 0xff00) >> 8;
				*ptr2 ++ = kanji & 0xff;
				ptr += 2;
				break;
			case 2:		/* kana */
				cp = JPdisp(&mode, JP_KANA, code);
				for(; *cp;)
					*ptr2++ = *cp++;
				*ptr2 ++ = *ptr & 0x7f;
				ptr ++;
				break;
			default:	/* ascii */
				cp = JPdisp(&mode, JP_ASCII, code);
				for(; *cp;)
					*ptr2++ = *cp++;
				*ptr2 ++ = *ptr ++;
				break;
			}
		}
		cp = JPdisp(&mode, JP_ASCII, code);
		for(; *cp;)
			*ptr2++ = *cp++;
		*ptr2 = NUL;
		return top;
	}
	return top;
}

	char *
fileconvsfrom(org)
	char_u	*org;
{
	static char_u	fnamebuf[2][MAXPATHL];
	static int		cnt = 0;
	char_u		*	fname;
	int				jkc = p_jkc;
#ifdef MSDOS
	char_u		*	p;
	char_u		*	t;
	int				cygnus = FALSE;
#endif

	if (org == NULL)
		return(NULL);
	p_jkc = FALSE;
	fname = &fnamebuf[++cnt & 1][0];
	fname[kanjiconvsfrom(org, strlen(org),
					fname, MAXPATHL, NULL, (char)toupper(JP_SYS), NULL)] = NUL;
#ifdef MSDOS
	t = p = (char_u *)fname;
	if (p[0] == '/' && p[1] == '/' && isalpha(p[2]) && p[3] == '/')
	{
		cygnus = TRUE;
		t[0] = p[2];
		t[1] = ':';
		t[2] = '/';
		memmove(&t[3], &p[4], strlen(p) - 3);
	}
	else if (strnicmp("/cygdrive/", p, 10) == 0 && isalpha(p[10]) && p[11] == '/')
	{
		cygnus = TRUE;
		t[0] = p[10];
		t[1] = ':';
		t[2] = '/';
		memmove(&t[3], &p[12], strlen(p) - 11);
	}
	while (*p)
	{
		if (ISkanji(*p))
		{
			*t++ = *p++;
			*t++ = *p++;
		}
		else if (cygnus && p[0] == '\\')
			p++;
		else if (p != (char_u *)fname && p[0] == '\\' && p[1] == '\\')
			p++;
		else
			*t++ = *p++;
	}
	*t = '\0';
#endif
	p_jkc = jkc;
	return(fname);
}

	char *
fileconvsto(org)
	char_u	*org;
{
	static char		fnamebuf[2][MAXPATHL];
	static int		cnt = 0;
	char		*	fname;
	char_u		*	p;
#ifdef MSDOS
	char_u		*	t;
	int				cygnus = FALSE;
#endif

	if (org == NULL)
		return(NULL);
	fname = &fnamebuf[++cnt & 1][0];
#ifdef MSDOS
	strcpy(fname, org);
	t = p = (char_u *)fname;
	if (p[0] == '/' && p[1] == '/' && isalpha(p[2]) && p[3] == '/')
	{
		cygnus = TRUE;
		t[0] = p[2];
		t[1] = ':';
		t[2] = '/';
		memmove(&t[3], &p[4], strlen(p) - 3);
	}
	while (*p)
	{
		if (ISkanji(*p))
		{
			*t++ = *p++;
			*t++ = *p++;
		}
		else if (cygnus && p[0] == '\\')
			p++;
		else if (p != (char_u *)fname && p[0] == '\\' && p[1] == '\\')
			p++;
		else
			*t++ = *p++;
	}
	*t = '\0';
	org = fname;
#endif
	p = kanjiconvsto(org, (char_u)toupper(JP_SYS), TRUE);
	strcpy(fname, p);
	free(p);
	return(fname);
}

	void
binaryconvsfrom(lnum, code, tail, ptr, len, dst)
	linenr_t lnum;
	char	code;
	int		*tail;
	char_u	*ptr;
	int		len;
	char_u	*dst;
{
	char_u	*wk = ptr;
	int		i;

	memset(dst, '\0', 81);
	sprintf(dst, "%08lx: ", lnum * 16);
	dst += 10;

	for (i = 0; i < 16; ++i)
	{
		if (len <= i)
		{
			*dst++ = ' ';
			*dst++ = ' ';
		}
		else
		{
			sprintf(dst, "%02x", *wk);
			dst += 2;
			++wk;
		}
		if (i & 1)
			*dst++ = ' ';
	}
	*dst++ = ';';
	for (i = 0; i < len;)
	{
		if (*tail)
		{
			*tail = FALSE;
			goto normal;
		}
		switch (code) {
		case JP_EUC:
			if ((kanji_map_euc[*ptr] & 1) && (0xa1 <= ptr[1] && ptr[1] <= 0xfe))
			{
				*dst++ = (euctosjis(ptr[0], ptr[1]) & 0xff00) >> 8;
				*dst++ = euctosjis(ptr[0], ptr[1]) & 0xff;
				ptr += 2;
				i += 2;
				if (i > len)
					*tail = TRUE;
			}
			else if ((kanji_map_euc[*ptr] & 2) && (0xa1 <= ptr[1] && ptr[1] <= 0xdf))
			{
				*dst++ = '.';
				*dst++ = ptr[1];
				ptr += 2;
				i += 2;
				if (i > len)
					*tail = TRUE;
			}
			else
				goto normal;
			break;
		case JP_SJIS:
			if ((kanji_map_sjis[*ptr] & 1)
					&& ((0x40 <= ptr[1] && ptr[1] <= 0x7e) || (0x80 <= ptr[1] && ptr[1] <= 0xfc)))
			{
				*dst++ = *ptr++;
				*dst++ = *ptr++;
				i += 2;
				if (i > len)
					*tail = TRUE;
			}
			else if (kanji_map_sjis[*ptr] & 2)
			{
				*dst++ = *ptr++;
				i += 1;
			}
			else
				goto normal;
			break;
#ifdef NT
		case JP_WIDE:		/* UNICODE */
			{
				int			wlen;
				char_u		buf[2];
				int			nochar;

				if (ptr[0] == 0xfe && ptr[1] == 0xff)
				{
					*tail = TRUE;
					goto normal;
				}
				wlen = WideCharToMultiByte(p_cpage, WC_COMPOSITECHECK, (LPCWSTR)ptr, 1, (LPSTR)buf, 2, NULL, &nochar);
				if (nochar)
					goto normal;
				if (wlen == 2)
				{
					*dst++ = buf[0];
					*dst++ = buf[1];
				}
				else if (buf[0] < ' ')
				{
					*dst++ = '.';
					*dst++ = '.';
				}
				else
				{
					*dst++ = buf[0];
					*dst++ = '.';
				}
				ptr += 2;
				i += 2;
				if (i > len)
					*tail = TRUE;
			}
			break;
#endif
		default:
normal:
			if (*ptr < ' ' || 0x7f <= *ptr)
				*dst++ = '.';
			else
				*dst++ = *ptr;
			ptr++;
			i++;
			break;
		}
	}
}

	char_u *
binaryconvsto(code, ptr, len, ubig)
	char	code;
	char_u	*ptr;
	int		*len;
	int		ubig;
{
	char_u				value = 0;
	int					cnt = 0;
	char_u				*top;
	int					quote = FALSE;

	*len = 0;
	if ((strchr(ptr, ':') > strchr(ptr, '"')) && strchr(ptr, '"') != NULL)
		;
	else if ((top = strchr(ptr, ':')) != NULL)
		ptr = top + 1;
	top = alloc(STRLEN(ptr) + 1);

	while (*ptr)
	{
		if (quote)
		{
			if (*ptr == '"')
				quote = FALSE;
			else if (ptr[0] == '\\' && ptr[1] == '"')
			{
				top[(*len)++] = '"';
				ptr++;
			}
			else if (code == JP_JIS)
				top[(*len)++] = *ptr;
			else
			{
				char_u		buf[3];
				char_u		*tmpptr;
				char_u		*p;

				if (ISkanji(*ptr))
				{
					buf[0] = ptr[0];
					buf[1] = ptr[1];
					buf[2] = NUL;
					p = tmpptr = kanjiconvsto(buf, code, ubig);
					while (*p)
						top[(*len)++] = *p++;
					free(tmpptr);
					ptr++;
				}
				else if (ISkana(*ptr))
				{
					buf[0] = ptr[0];
					buf[1] = NUL;
					p = tmpptr = kanjiconvsto(buf, code, ubig);
					while (*p)
						top[(*len)++] = *p++;
					free(tmpptr);
				}
				else
					top[(*len)++] = *ptr;
			}
		}
		else
		{
			switch (*ptr) {
			case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': case '9':
				value = (value << 4) + (*ptr - '0');
				cnt++;
				break;
			case 'a': case 'A':
				value = (value << 4) + 10
								+ (*ptr == 'a' ? *ptr - 'a' : *ptr - 'A');
				cnt++;
				break;
			case 'b': case 'B':
				value = (value << 4) + 10
								+ (*ptr == 'b' ? *ptr - 'a' : *ptr - 'A');
				cnt++;
				break;
			case 'c': case 'C':
				value = (value << 4) + 10
								+ (*ptr == 'c' ? *ptr - 'a' : *ptr - 'A');
				cnt++;
				break;
			case 'd': case 'D':
				value = (value << 4) + 10
								+ (*ptr == 'd' ? *ptr - 'a' : *ptr - 'A');
				cnt++;
				break;
			case 'e': case 'E':
				value = (value << 4) + 10
								+ (*ptr == 'e' ? *ptr - 'a' : *ptr - 'A');
				cnt++;
				break;
			case 'f': case 'F':
				value = (value << 4) + 10
								+ (*ptr == 'f' ? *ptr - 'a' : *ptr - 'A');
				cnt++;
				break;
			case ';':
				if (cnt == 1)
				{
					top[(*len)++] = value;
					cnt = 0;
					value = 0;
				}
				return(top);
			case '"':
				if (cnt == 1)
				{
					top[(*len)++] = value;
					cnt = 0;
					value = 0;
				}
				quote = TRUE;
				break;
			case ' ':
			case '\t':
			case '\n':
			case '\r':
			default:
				if (cnt == 1)
				{
					top[(*len)++] = value;
					cnt = 0;
					value = 0;
				}
				break;
			}
			if (cnt == 2)
			{
				top[(*len)++] = value;
				cnt = 0;
				value = 0;
			}
		}
		ptr++;
	}
	return(top);
}

/*
 * JIS X 0201 Right hand set(hankaku kana) <-> JIS X 0208(zenkaku)
 *
 */
	static int
jisx0201rto0208(src0, src1, dst0, dst1)
	char_u src0, src1, *dst0, *dst1;
{
	char_u	c, y;
	char_u	*x0201p, z;
	int		conv;

	src0 |= 0x80;
	src1 |= 0x80;
	c = (char_u)src0;
	x0201p = (char_u *)jisx0201r + 2 * (c - 0xa0);

	if (! ISkanji(y = *x0201p))
	{
		*dst0 = y;
		*dst1 = NUL;
		return FALSE;
	}

	z = *(x0201p + 1);
	conv = FALSE;
	if		((char_u)src1 == 0xdf &&		/* maru */
				(c >= 0xca && c <= 0xce))	/* ha - ho */
	{
		z += 2;
		conv = TRUE;
	}
	else if ((char_u)src1 == 0xde)			/* dakuten */
	{
		conv = TRUE;
		if (   (c >= 0xb6 && c <= 0xc4)		/* ka - to */
			|| (c >= 0xca && c <= 0xce) )	/* ha - ho */
			z ++;
		else if (c == 0xb3)					/* u -> vu*/
			z = 0x94;
		else
			conv = FALSE;
	}

	*dst0 = y;
	*dst1 = z;

	return conv ? TRUE : FALSE;
}

/*
 * compare two strings, ignoring case
 * return 0 for match, 1 for difference
 */
	int
jp_strnicmp(s1, s2, len)
	char_u	*s1;
	char_u	*s2;
	size_t	len;
{
	char_u	*	str[2];
	char_u		wrk[2][2];
	int			slen[2];
	char_u	*	s;
	char_u	*	w;
	int		*	l;
	size_t		wlen;
	int			i;
	int			class;
	int			flg = TRUE;
	size_t		tlen = len;

	wlen = len;
	s = s1;
	w = s2;
	while (wlen)
	{
		if ((*s == '\t' && *w == ' ') || (*s == ' ' && *w == '\t'))
			;
		else if (TO_UPPER(*s) != TO_UPPER(*w))
		{
			flg = FALSE;
			break;
		}
		if (*s == NUL)
			break;
		++s;
		++w;
		--wlen;
	}
	if (flg)
		return tlen;						/* strings match */
	str[0]	= s1;
	str[1]	= s2;
	tlen	= 0;
	while (len > 0)
	{
		if (*str[1] == NUL)
			return tlen;
		if (*str[0] == NUL)
			return 0;
		for (i = 0; i < 2; i++)
		{
			s = str[i];
			w = &wrk[i][0];
			l = &slen[i];
			*l = 1;
			if (ISkanji(*s))
			{
				*l = 2;
				w[0] = *s;
				w[1] = *(s + 1);
			}
			else if (ISkana(*s))
			{
				if (jisx0201rto0208(*s, *(s + 1), &w[0], &w[1]))
					*l = 2;
			}
			else if (isalpha(*s))
			{
				if (islower(*s))
				{
					w[0] = 0x82;
					w[1] = 0x60 + (*s - 'a');
				}
				else
				{
					w[0] = 0x82;
					w[1] = 0x60 + (*s - 'A');
				}
			}
			else if (isdigit(*s))
			{
				w[0] = 0x82;
				w[1] = 0x4f + (*s - '0');
			}
			else
			{
				char_u	**	cnv = (char_u **)Asconv;
				char	*	c;

				while (*cnv[0])
				{
					c = *cnv;
					if (c[0] == *s)
					{
						w[0] = c[1];
						w[1] = c[2];
						break;
					}
					cnv++;
				}
			}
			class = jpcls(w[0], w[1]);
			if (class == JPC_HIRA || class == JPC_ALNUM)
				jptocase(&w[0], &w[1], UPPER);
		}
		if (!(wrk[0][0] == wrk[1][0] && wrk[0][1] == wrk[1][1]))
			return 0;
		str[0] += slen[0];
		str[1] += slen[1];
		len -= slen[1];
		tlen += slen[0];
	}
	return tlen;							/* strings match */
}

#ifdef UCODE
int ucs2sjis __ARGS((unsigned short ucs, unsigned char* sjis));
void sjis2ucs __ARGS((unsigned char* sjis, int len, unsigned char* ucs));

	int
wide2multi(ptr, size, ubig, first)
	char_u	*	ptr;
	int			size;
	int			ubig;
	int			first;
{
	char_u	*	p = ptr;
	char_u		buf[2];
	int			len;
	int			total = 0;
	int			i;

	if (first)
	{
		p += 2;
		size -= 2;
	}
	for (i = 0; i < size; i += 2)
	{
		if (ubig)
		{
			buf[0]	= p[0];
			p[0]	= p[1];
			p[1]	= buf[0];
		}
#ifdef NT
		len = WideCharToMultiByte(p_cpage, WC_COMPOSITECHECK, (LPCWSTR)p, 1, (LPSTR)buf, 2, NULL, NULL);
#else
		len = ucs2sjis((*(p+1) << 8) | *p, buf);
#endif
		memmove((char *)&ptr[total], buf, len);
		p += 2;
		total += len;
	}
	return(total);
}

	void
multi2wide(k1, k2, len, ubig)
	char_u	*	k1;
	char_u	*	k2;
	int			len;
	int			ubig;
{
	char_u	buf[2];
	char_u	wbuf[2/*sizeof(WCHAR)*/];

	buf[0] = *k1;
	buf[1] = *k2;
#ifdef NT
	MultiByteToWideChar(p_cpage, MB_PRECOMPOSED, (LPSTR)buf, len, (LPWSTR)wbuf, 1);
#else
	sjis2ucs(buf, len, wbuf);
#endif
	if (ubig)
	{
		*k1 = wbuf[1];
		*k2 = wbuf[0];
	}
	else
	{
		*k1 = wbuf[0];
		*k2 = wbuf[1];
	}
}
#endif /* UCODE */
#endif	/* KANJI */
