
/*
 * mpg123.C -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MPG123_C
#define MPG123_C

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "dialogs/typedefs.h"
#include "dialogs/dialogs.h"

#include "mpg123/mpg123.h"
#include "mpg123/utils.h"
#include "mpg123/describe.h"

#include "typedefs.h"
#include "mpg123.h"

void MPG123Dialog::clrlines (WINDOW *win,int from,int to)
{
   int x,y;
   if (from > to)
	 {
		x = to;
		to = from;
		from = to;
	 }
   for (y = from; y <= to; y++)
	 {
		wmove (win,y,2);
		for (x = 2; x < 70; x++) waddch (win,' ');
	 }
}

#if 0
void MPG123Dialog::showversion (WINDOW *win)
{
   /* WARNING: This is actually wrong, because mvwprintw discards the "volatile" which could lead to race conditions */
   mvwprintw (win,xx,2,"Player: MPG123 %s",mpg123_poll_status.version);
}

void MPG123Dialog::showcurtrack (WINDOW *win)
{
   /* WARNING: This is actually wrong, because mvwprintw discards the "volatile" which could lead to race conditions */
   clrlines (xx,xx);
   mvwprintw (win,xx,2,"Current track: %s",mpg123_poll_status.curtrack);	/* WARNING: Watch length */
}
#endif

#define TAG(a,b) (mpg123_poll_status.status.has_id3tag ? (a) : mpg123_poll_status.status.has_desc ? (b) : "")
void MPG123Dialog::showstatus (WINDOW *win)
{
   clrlines (win,4,11);
   if (mpg123_poll_status.status.has_id3tag)
	 mvwprintw (win,4,2,"filename:");
   else
	 {
		char tmp[70];
		int len;
		for (len = 0; mpg123_poll_status.status.info.filename[len] != '\0'; len++) ;
		if (len < 68)
		  safe_strcpy2 (tmp,mpg123_poll_status.status.info.filename);
		else
		  {
			 int i;
			 for (i = 0; i < 33; i++)
			   {
				  tmp[i] = mpg123_poll_status.status.info.filename[i];
				  tmp[i + 34] = mpg123_poll_status.status.info.filename[i + len - 33];
			   }
			 tmp[33] = '~';
			 tmp[67] = '\0';
		  }
		mvwprintw (win,4,2,"filename: %s",tmp);
	 }
   /* WARNING: This is actually wrong, because mvwprintw discards the "volatile" which could lead to race conditions */
   mvwprintw (win,6,2,"  title: %s",TAG ((const char *) mpg123_poll_status.status.info.tag.title,(const char *) mpg123_poll_status.status.song.title));
   mvwprintw (win,7,2," artist: %s",TAG ((const char *) mpg123_poll_status.status.info.tag.artist,(const char *) mpg123_poll_status.status.song.artist));
   mvwprintw (win,8,2,"  album: %s",TAG ((const char *) mpg123_poll_status.status.info.tag.album,(const char *) mpg123_poll_status.status.song.album));
   mvwprintw (win,9,2,"   year: %s",mpg123_poll_status.status.has_id3tag ? (const char *) mpg123_poll_status.status.info.tag.year : "");
   mvwprintw (win,10,2,"comment: %s",mpg123_poll_status.status.has_id3tag ? (const char *) mpg123_poll_status.status.info.tag.comment : "");
   mvwprintw (win,11,2,"  genre: %s",mpg123_poll_status.status.has_id3tag ? (const char *) mpg123_poll_status.status.info.tag.genre : "");
}
#undef TAG

void MPG123Dialog::showstream (WINDOW *win)
{
   clrlines (win,13,15);
   /* WARNING: This is actually wrong, because mvwprintw discards the "volatile" which could lead to race conditions */
   mvwprintw (win,13,2,"MPEG %s Layer %d, Freq: %dHz, Mode: %s, modext: %d",
			  mpg123_poll_status.stream.mpegtype,
			  mpg123_poll_status.stream.layer,
			  mpg123_poll_status.stream.freq,
			  mpg123_poll_status.stream.mode,
			  mpg123_poll_status.stream.mode_ext);
   mvwprintw (win,14,2,"BPF: %d, Channels: %d, Copyright: %s, CRC: %s, Emphasis: %d",
			  mpg123_poll_status.stream.framesize,
			  mpg123_poll_status.stream.stereo,
			  mpg123_poll_status.stream.copyright ? "Yes" : "No",
			  mpg123_poll_status.stream.errprot ? "Yes" : "No",
			  mpg123_poll_status.stream.emphasis);
   mvwprintw (win,15,2,"Bitrate: %d KBits/s, Extension value: %d",
			  mpg123_poll_status.stream.bitrate,
			  mpg123_poll_status.stream.extension);
}

void MPG123Dialog::showplaystat (WINDOW *win)
{
   const char *str[] =
	 {
		"playing stopped    ",
		"playing paused     ",
		"playing unpaused   ",
		"end of song reached",
		"busy playing       "
	 };
   mvwprintw (win,17,2,"Status: %s",str[mpg123_poll_status.playstat]);
}

void MPG123Dialog::showframe (WINDOW *win,recv_t *recv)
{
   /* WARNING: This is actually wrong, because mvwprintw discards the "volatile" which could lead to race conditions */
   mvwprintw (win,19,2,"Frame: %d [%d], Time: %02u:%02u.%02u [%02u:%02u.%02u]           ",
			  recv->data.frame.framecount,
			  recv->data.frame.framesleft,
			  (unsigned int) recv->data.frame.secs / 60,
			  (unsigned int) recv->data.frame.secs % 60,
			  (unsigned int) (recv->data.frame.secs * 100) % 100,
			  (unsigned int) recv->data.frame.secsleft / 60,
			  (unsigned int) recv->data.frame.secsleft % 60,
			  (unsigned int) (recv->data.frame.secsleft * 100) % 100);
}

inline void MPG123Dialog::hide (WINDOW *win)
{
   clrlines (win,4,19);
}

void MPG123Dialog::MPG123Frontend (void (*errhandler) (const char *format, ...),chtype hotkey)
{
   bool finished = FALSE;
   fd_set fdset;
   struct timeval tv;
   chtype ch;
   char tmp[256];
   recv_t recv;
   song_t song;
   WINDOW *curwin;
   Add (70,19,(COLS - 70) >> 1,(LINES - 19) >> 1,"MPG123 frontend",A_BOLD,WHITE,BLUE);
   curwin = GetWindow ();
   nodelay (curwin,TRUE);
   keypad (curwin,TRUE);
   mpg123_sendinput (FALSE);
   mvwaddstr (curwin,1,5,"n:Next   s:Stop    p:Pause / Resume");
   mvwaddstr (curwin,2,5,"f:Seek +100 frames   r:Seek -100 frames");
#if 0
   if (mpg123_poll_status.has_version) showversion (curwin);
   if (mpg123_poll_status.has_curtrack) showcurtrack (curwin);
#endif
   if (mpg123_poll_status.has_status) showstatus (curwin);
   if (mpg123_poll_status.has_stream) showstream (curwin);
   showplaystat (curwin);
   do
	 {
		/* parse input */
		if ((ch = wgetch (curwin)) != (unsigned int) ERR)
		  {
			 if (ch == 'n')
			   {
				  /* unpause */
				  if (track_paused)
					{
					   mpg123_pause ();
					   track_paused = FALSE;
					}
				  mpg123_sendskip (TRUE);
				  mpg123_stop ();
			   }
			 else if (ch == 's')
			   {
				  /* unpause */
				  if (track_paused)
					{
					   mpg123_pause ();
					   track_paused = FALSE;
					}
				  mpg123_sendskip (FALSE);
				  mpg123_stop ();
			   }
			 else if (ch == 'p')
			   {
				  mpg123_pause ();
				  track_paused = !track_paused;
			   }
			 else if (ch == 'f')
			   {
				  /* unpause */
				  if (track_paused)
					{
					   mpg123_pause ();
					   track_paused = FALSE;
					}
				  mpg123_seek (100,SEEK_FWD);
			   }
			 else if (ch == 'r')
			   {
				  /* unpause */
				  if (track_paused)
					{
					   mpg123_pause ();
					   track_paused = FALSE;
					}
				  mpg123_seek (100,SEEK_REW);
			   }
			 else if (ch == hotkey)
			   finished = TRUE;
			 else if (IsHotkey (ch))
			   {
				  flushinp ();
				  nodelay (curwin,FALSE);
				  keypad (curwin,FALSE);
				  mpg123_sendinput (TRUE);
				  execfunc (ch);
				  mpg123_sendinput (FALSE);
				  keypad (curwin,TRUE);
				  nodelay (curwin,TRUE);
				  hide (curwin);
#if 0
				  if (mpg123_poll_status.has_version) showversion (curwin);
				  if (mpg123_poll_status.has_curtrack) showcurtrack (curwin);
#endif
				  if (mpg123_poll_status.has_status) showstatus (curwin);
				  if (mpg123_poll_status.has_stream) showstream (curwin);
				  showplaystat (curwin);
				  finished = abortflag;
			   }
			 else beep ();
			 flushinp ();
		  }
        /* set the fd's to watch */
		FD_ZERO (&fdset);
		FD_SET (mpg123_fdrecv,&fdset);
		tv.tv_sec = 0;
		tv.tv_usec = 100000;
        /* wait for data or timeout */
		switch (select (mpg123_fdrecv + 1,&fdset,NULL,NULL,&tv))
		  {
		   case -1:
			 if (errno == EINTR) break;
			 errhandler ("polldata(): select(): %s",strerror (errno));
		   case 0:
			 break;
		   default:
			 if (mpg123_receive (&recv))
			   {
				  switch (recv.type)
					{
					 case VERSION:
					   mpg123_poll_status.has_version = TRUE;
					   safe_strcpy (mpg123_poll_status.version,recv.data.version);
					   /*showversion (win);*/
					   break;
                     case STATUS:
					   mpg123_poll_status.has_status = TRUE;
					   mpg123_poll_status.status.has_id3tag = recv.data.status.has_id3tag;
					   if (mpg123_poll_status.status.has_id3tag)
						 {
							safe_strcpy (mpg123_poll_status.status.info.tag.title,recv.data.status.info.tag.title);
							safe_strcpy (mpg123_poll_status.status.info.tag.artist,recv.data.status.info.tag.artist);
							safe_strcpy (mpg123_poll_status.status.info.tag.album,recv.data.status.info.tag.album);
							safe_strcpy (mpg123_poll_status.status.info.tag.year,recv.data.status.info.tag.year);
							safe_strcpy (mpg123_poll_status.status.info.tag.comment,recv.data.status.info.tag.comment);
							safe_strcpy (mpg123_poll_status.status.info.tag.genre,recv.data.status.info.tag.genre);
						 }
					   else safe_strcpy (mpg123_poll_status.status.info.filename,recv.data.status.info.filename);
					   while (!mpg123_poll_status.has_curtrack) ;   /* Any better way to do this? */
#if 0
					   showcurtrack (curwin);
#endif
					   safe_strcpy2 (tmp,mpg123_poll_status.curtrack);
					   mpg123_poll_status.status.has_desc = describe (&song,tmp);
					   if (mpg123_poll_status.status.has_desc)
						 {
							safe_strcpy (mpg123_poll_status.status.song.title,song.title);
							safe_strcpy (mpg123_poll_status.status.song.artist,song.artist);
							safe_strcpy (mpg123_poll_status.status.song.album,song.album);
						 }
					   showstatus (curwin);
					   break;
					 case STREAM:
					   mpg123_poll_status.has_stream = TRUE;
					   safe_strcpy (mpg123_poll_status.stream.mpegtype,recv.data.stream.mpegtype);
					   mpg123_poll_status.stream.layer = recv.data.stream.layer;
					   mpg123_poll_status.stream.freq = recv.data.stream.freq;
					   safe_strcpy (mpg123_poll_status.stream.mode,recv.data.stream.mode);
					   mpg123_poll_status.stream.mode_ext = recv.data.stream.mode_ext;
					   mpg123_poll_status.stream.framesize = recv.data.stream.framesize;
					   mpg123_poll_status.stream.stereo = recv.data.stream.stereo;
					   mpg123_poll_status.stream.copyright = recv.data.stream.copyright;
					   mpg123_poll_status.stream.errprot = recv.data.stream.errprot;
					   mpg123_poll_status.stream.emphasis = recv.data.stream.emphasis;
					   mpg123_poll_status.stream.bitrate = recv.data.stream.bitrate;
					   mpg123_poll_status.stream.extension = recv.data.stream.extension;
					   showstream (curwin);
					   break;
                     case FRAME:
					   showframe (curwin,&recv);
					   break;
					 case PLAYSTAT:
					   mpg123_poll_status.playstat = recv.data.playstat;
					   mpg123_sendplaystat ();
					   if ((mpg123_poll_status.playstat == 0) || (mpg123_poll_status.playstat == 3))
						 {
							mpg123_poll_status.has_curtrack = FALSE;
							mpg123_poll_status.has_status = FALSE;
							mpg123_poll_status.has_stream = FALSE;
							mpg123_poll_status.has_curtrack = FALSE;
							mpg123_poll_status.status.has_desc = FALSE;
							hide (curwin);
						 }
					   else
						 {
							if (mpg123_poll_status.playstat == 4)
							  {
								 while (!mpg123_poll_status.has_curtrack) ; /* Any better way to do this? */
#if 0
								 showcurtrack (curwin);
#endif
								 safe_strcpy2 (tmp,mpg123_poll_status.curtrack);
								 mpg123_poll_status.status.has_desc = describe (&song,tmp);
								 if (mpg123_poll_status.status.has_desc)
								   {
									  safe_strcpy (mpg123_poll_status.status.song.title,song.title);
									  safe_strcpy (mpg123_poll_status.status.song.artist,song.artist);
									  safe_strcpy (mpg123_poll_status.status.song.album,song.album);
								   }
							  }
						 }
					   showplaystat (curwin);
					   break;
					 case ERROR:
					   errhandler ("MPG123: %s",recv.data.errmsg);
					}
			   }
		  }
		Update ();
	 }
   while (!finished);
   mpg123_sendinput (TRUE);
   keypad (curwin,FALSE);
   nodelay (curwin,FALSE);
   Remove ();
   Update ();
}

#endif
