/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagTypeRegister;
import java.util.List;

public abstract class TagType {
    private final String description;
    private final String startDelimiter;
    private final char[] startDelimiterCharArray;
    private final String closingDelimiter;
    private final boolean isServerTag;
    private final String namePrefix;
    final String startDelimiterPrefix;

    TagType(String string, String string2, String string3, boolean bl, String string4) {
        this.description = string;
        this.startDelimiter = string2;
        this.startDelimiterCharArray = string2.toCharArray();
        this.closingDelimiter = string3;
        this.isServerTag = bl;
        this.namePrefix = string2.substring(string4.length());
        this.startDelimiterPrefix = string4;
    }

    public final void register() {
        TagTypeRegister.add(this);
    }

    public final void deregister() {
        TagTypeRegister.remove(this);
    }

    public static final List getRegisteredTagTypes() {
        return TagTypeRegister.getList();
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getStartDelimiter() {
        return this.startDelimiter;
    }

    public final String getClosingDelimiter() {
        return this.closingDelimiter;
    }

    public final boolean isServerTag() {
        return this.isServerTag;
    }

    protected final String getNamePrefix() {
        return this.namePrefix;
    }

    protected boolean isValidPosition(Source source, int n, int[] nArray) {
        if (this.isServerTag()) {
            return true;
        }
        if (nArray != null) {
            if (nArray[0] == Integer.MAX_VALUE) {
                if (this == EndTagType.NORMAL && source.getParseText().containsAt("</script", n)) {
                    nArray[0] = n;
                    return true;
                }
                return false;
            }
            return n >= nArray[0];
        }
        TagType[] tagTypeArray = TagType.getTagTypesIgnoringEnclosedMarkup();
        for (int i = 0; i < tagTypeArray.length; ++i) {
            TagType tagType = tagTypeArray[i];
            if (this == StartTagType.COMMENT && tagType == StartTagType.COMMENT || !tagType.tagEncloses(source, n)) continue;
            return false;
        }
        return true;
    }

    public static final TagType[] getTagTypesIgnoringEnclosedMarkup() {
        return TagTypesIgnoringEnclosedMarkup.array;
    }

    public static final void setTagTypesIgnoringEnclosedMarkup(TagType[] tagTypeArray) {
        if (tagTypeArray == null) {
            throw new IllegalArgumentException();
        }
        TagTypesIgnoringEnclosedMarkup.array = tagTypeArray;
    }

    protected abstract Tag constructTagAt(Source var1, int var2);

    protected final boolean tagEncloses(Source source, int n) {
        if (n == 0) {
            return false;
        }
        Tag tag = source.findEnclosingTag(n - 1, this);
        return tag != null && n != tag.getEnd();
    }

    public String toString() {
        return this.getDescription();
    }

    static final Tag getTagAt(Source source, int n, boolean bl, boolean bl2) {
        TagTypeRegister.ProspectiveTagTypeIterator prospectiveTagTypeIterator = new TagTypeRegister.ProspectiveTagTypeIterator(source, n);
        while (prospectiveTagTypeIterator.hasNext()) {
            TagType tagType = prospectiveTagTypeIterator.getNextTagType();
            if (bl && !tagType.isServerTag() || !bl2 && !tagType.isValidPosition(source, n, source.fullSequentialParseData)) continue;
            try {
                Tag tag = tagType.constructTagAt(source, n);
                if (tag == null) continue;
                return tag;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!source.logger.isInfoEnabled()) continue;
                source.logger.info(source.getRowColumnVector(n).appendTo(new StringBuffer(200).append("Tag at ")).append(" not recognised as type '").append(tagType.getDescription()).append("' because it has no end delimiter").toString());
            }
        }
        return null;
    }

    final char[] getStartDelimiterCharArray() {
        return this.startDelimiterCharArray;
    }

    private static final class TagTypesIgnoringEnclosedMarkup {
        public static TagType[] array = new TagType[]{StartTagType.COMMENT, StartTagType.CDATA_SECTION};

        private TagTypesIgnoringEnclosedMarkup() {
        }
    }
}

