#ifndef _BYTE_ORDER_C
#define _BYTE_ORDER_C

#include <stdint.h>
#include <string.h>
#include <netinet/in.h>
#include "config.h"

#ifdef WORDS_BIGENDIAN
inline uint16_t hton16 ( uint16_t n ) { return n ; }
inline uint16_t ntoh16 ( uint16_t n ) { return n ; }
inline uint32_t hton32 ( uint32_t n ) { return n ; }
inline uint32_t ntoh32 ( uint32_t n ) { return n ; }
inline uint64_t hton64 ( uint64_t n ) { return n ; }
inline uint64_t ntoh64 ( uint64_t n ) { return n ; }
#else /* ! WORDS_BIGENDIAN */
inline uint16_t hton16 ( uint16_t u ) { return htons ( u ) ; }
inline uint16_t ntoh16 ( uint16_t u ) { return ntohs ( u ) ; }
inline uint32_t hton32 ( uint32_t u ) { return htonl ( u ) ; }
inline uint32_t ntoh32 ( uint32_t u ) { return ntohl ( u ) ; }
inline uint64_t hton64 ( uint64_t n )
{
  return (uint64_t) hton32 ( n >> 32 ) | ( (uint64_t) hton32 ( n & 0x00000000FFFFFFFFUL ) << 32 ) ;
}
inline uint64_t ntoh64 ( uint64_t n )
{
  return (uint64_t) ntoh32 ( n >> 32 ) | ( (uint64_t) ntoh32 ( n & 0x00000000FFFFFFFFUL ) << 32 ) ;
}
#endif

#define GENERATE_NC_TO_BUF(proc,size)			\
void							\
proc##size##_to_buf ( char *buf , uint##size##_t n )	\
{							\
  n = proc##size ( n ) ;				\
  memcpy ( buf , &n , size/8 ) ;			\
}

GENERATE_NC_TO_BUF ( hton , 16 ) ;
GENERATE_NC_TO_BUF ( ntoh , 16 ) ;
GENERATE_NC_TO_BUF ( hton , 32 ) ;
GENERATE_NC_TO_BUF ( ntoh , 32 ) ;
GENERATE_NC_TO_BUF ( hton , 64 ) ;
GENERATE_NC_TO_BUF ( ntoh , 64 ) ;

#define GENERATE_NC_FROM_BUF(proc,size)		\
uint##size##_t					\
proc##size##_from_buf ( const char *buf )	\
{						\
  uint##size##_t n ;				\
  memcpy ( &n , buf , size/8 ) ;		\
  return proc##size ( n ) ;			\
}

GENERATE_NC_FROM_BUF ( hton , 16 ) ;
GENERATE_NC_FROM_BUF ( ntoh , 16 ) ;
GENERATE_NC_FROM_BUF ( hton , 32 ) ;
GENERATE_NC_FROM_BUF ( ntoh , 32 ) ;
GENERATE_NC_FROM_BUF ( hton , 64 ) ;
GENERATE_NC_FROM_BUF ( ntoh , 64 ) ;

#define GENERATE_NC_BUF(proc,size)			\
void							\
proc##size##_buf ( char *dst , const char *src )	\
{							\
  uint##size##_t n = proc##size##_from_buf ( src ) ;	\
  memcpy ( dst , &n , size/8 ) ;			\
}

GENERATE_NC_BUF ( hton , 16 ) ;
GENERATE_NC_BUF ( ntoh , 16 ) ;
GENERATE_NC_BUF ( hton , 32 ) ;
GENERATE_NC_BUF ( ntoh , 32 ) ;
GENERATE_NC_BUF ( hton , 64 ) ;
GENERATE_NC_BUF ( ntoh , 64 ) ;

typedef union 
{ 
  uint16_t u ;
  int16_t i ;
} 
number16_t ;

typedef float float32_t ;

typedef union 
{ 
  uint32_t u ;
  int32_t i ;
  float32_t f ;
} 
number32_t ;

typedef double float64_t ;

typedef union 
{ 
  uint64_t u ;
  int64_t i ;
  float64_t f ;
} 
number64_t ;

#define GENERATE_TNC_TO_BUF(proc,tag,size,mem)			\
void								\
proc##_##tag##size##_to_buf ( char *buf , tag##size##_t a )	\
{								\
  number##size##_t n ;						\
  n.mem = a ;							\
  proc##size##_to_buf ( buf , n.u ) ;				\
}

GENERATE_TNC_TO_BUF ( hton , uint , 16 , u ) ;
GENERATE_TNC_TO_BUF ( ntoh , uint , 16 , u ) ;
GENERATE_TNC_TO_BUF ( hton , int , 16 , i ) ;
GENERATE_TNC_TO_BUF ( ntoh , int , 16 , i ) ;
GENERATE_TNC_TO_BUF ( hton , uint , 32 , u ) ;
GENERATE_TNC_TO_BUF ( ntoh , uint , 32 , u ) ;
GENERATE_TNC_TO_BUF ( hton , int , 32 , i ) ;
GENERATE_TNC_TO_BUF ( ntoh , int , 32 , i ) ;
GENERATE_TNC_TO_BUF ( hton , float , 32 , f ) ;
GENERATE_TNC_TO_BUF ( ntoh , float , 32 , f ) ;
GENERATE_TNC_TO_BUF ( hton , uint , 64 , u ) ;
GENERATE_TNC_TO_BUF ( ntoh , uint , 64 , u ) ;
GENERATE_TNC_TO_BUF ( hton , int , 64 , i ) ;
GENERATE_TNC_TO_BUF ( ntoh , int , 64 , i ) ;
GENERATE_TNC_TO_BUF ( hton , float , 64 , f ) ;
GENERATE_TNC_TO_BUF ( ntoh , float , 64 , f ) ;

#define GENERATE_TNC_FROM_BUF(proc,tag,size,mem)	\
tag##size##_t						\
proc##_##tag##size##_from_buf ( const char *buf )	\
{							\
  number##size##_t n ;					\
  n.u  = proc##size##_from_buf ( buf ) ;		\
  return n.mem ;					\
}

GENERATE_TNC_FROM_BUF ( hton , uint , 16 , u ) ;
GENERATE_TNC_FROM_BUF ( ntoh , uint , 16 , u ) ;
GENERATE_TNC_FROM_BUF ( hton , int , 16 , i ) ;
GENERATE_TNC_FROM_BUF ( ntoh , int , 16 , i ) ;
GENERATE_TNC_FROM_BUF ( hton , uint , 32 , u ) ;
GENERATE_TNC_FROM_BUF ( ntoh , uint , 32 , u ) ;
GENERATE_TNC_FROM_BUF ( hton , int , 32 , i ) ;
GENERATE_TNC_FROM_BUF ( ntoh , int , 32 , i ) ;
GENERATE_TNC_FROM_BUF ( hton , float , 32 , f ) ;
GENERATE_TNC_FROM_BUF ( ntoh , float , 32 , f ) ;
GENERATE_TNC_FROM_BUF ( hton , uint , 64 , u ) ;
GENERATE_TNC_FROM_BUF ( ntoh , uint , 64 , u ) ;
GENERATE_TNC_FROM_BUF ( hton , int , 64 , i ) ;
GENERATE_TNC_FROM_BUF ( ntoh , int , 64 , i ) ;
GENERATE_TNC_FROM_BUF ( hton , float , 64 , f ) ;
GENERATE_TNC_FROM_BUF ( ntoh , float , 64 , f ) ;

#define GENERATE_TNC(proc,tag)			\
tag##_t						\
proc##_##tag ( tag##_t a )			\
{						\
  proc##_##tag##_to_buf ( (char *)&a , a ) ;	\
  return a ;					\
}  

GENERATE_TNC ( hton , uint16 ) ;
GENERATE_TNC ( hton , int16 ) ;
GENERATE_TNC ( ntoh , uint16 ) ;
GENERATE_TNC ( ntoh , int16 ) ;
GENERATE_TNC ( hton , uint32 ) ;
GENERATE_TNC ( hton , int32 ) ;
GENERATE_TNC ( hton , float32 ) ;
GENERATE_TNC ( hton , uint64 ) ;
GENERATE_TNC ( hton , int64 ) ;
GENERATE_TNC ( hton , float64 ) ;
GENERATE_TNC ( ntoh , uint32 ) ;
GENERATE_TNC ( ntoh , int32 ) ;
GENERATE_TNC ( ntoh , float32 ) ;
GENERATE_TNC ( ntoh , uint64 ) ;
GENERATE_TNC ( ntoh , int64 ) ;
GENERATE_TNC ( ntoh , float64 ) ;

#endif
