/*
 * This program is original work by San Mehat <nettwerk@valinux.com> .
 * This program is distributed under the GNU General Public License (GPL)
 * as outlined in the COPYING file.
 *
 * Copyright (C) 1999, San Mehat, and VA Linux Systems
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef _SEL_H
#define _SEL_H

typedef struct sel_reservation_resp
	{
  unsigned short res_id  __attribute__ ((packed));
	} SEL_RESERVATION_RESP;

typedef struct sel_clear_request
  {
  unsigned short res_id  __attribute__ ((packed));
  unsigned char  clr0    __attribute__ ((packed));
  unsigned char  clr1    __attribute__ ((packed));
  unsigned char  clr2    __attribute__ ((packed));
  unsigned char  op      __attribute__ ((packed));
  } SEL_CLEAR_REQ;

typedef struct sel_req
  {
  unsigned short resid;
  unsigned short recid;
  unsigned char  offset;
#define SEL_LENGTH_ALL 0xff
  unsigned char  length;
  } SEL_REQ;

typedef struct sel_resp
  {
  unsigned short	next_id         __attribute__ ((packed));
  unsigned short	recid           __attribute__ ((packed));
  unsigned char		type            __attribute__ ((packed));
  unsigned int		timestamp       __attribute__ ((packed));

	unsigned char		id_type			:1	__attribute__	((packed));
	unsigned char		id_data			:7	__attribute__	((packed));

	unsigned char		ipmb_lun		:2	__attribute__	((packed));
	unsigned char		res					:6	__attribute__	((packed));

  unsigned char		evmrev          __attribute__ ((packed));
  unsigned char		sensortype      __attribute__ ((packed));
  unsigned char		sensornum       __attribute__ ((packed));
  unsigned char		event_type      __attribute__ ((packed));
  unsigned char		event_data[3]   __attribute__ ((packed));
  } SEL_RESP;

typedef struct sel_info_resp
  {
  unsigned char   sel_ver                   __attribute__ ((packed));
  unsigned short  num_entries               __attribute__ ((packed));
  unsigned short  free_space                __attribute__ ((packed));
  unsigned int    most_recent_addition      __attribute__ ((packed));
  unsigned int    most_recent_erase         __attribute__ ((packed));
  unsigned char   alloc_info_supported:1;
  unsigned char   reserve_supported:1;
  unsigned char   partial_add_supported:1;
  unsigned char   delete_supported:1;
  unsigned char   reserved:3;
  unsigned char   overflow:1;
  } SEL_INFO_RESP;

typedef struct sel_alloc_resp
  {
  unsigned short  possible_allocation_units __attribute__ ((packed));
  unsigned short  allocation_unit_size      __attribute__ ((packed));
  unsigned short  free_allocation_units     __attribute__ ((packed));
  unsigned short  largest_free_block        __attribute__ ((packed));
  unsigned char   maximum_record_size       __attribute__ ((packed));
  } SEL_ALLOC_RESP;

#define CMD_GET_SEL_INFO                  0x40
#define CMD_GET_SEL_ALLOC_INFO            0x41
#define CMD_RESERVE_SEL                   0x42
#define CMD_GET_SEL_ENTRY                 0x43
#define CMD_DEL_SEL_ENTRY                 0x46
#define CMD_CLEAR_SEL                     0x47
#define CMD_GET_SEL_TIME                  0x48
#endif
