.TH IMGSIZER 1 "8 Mar 2000"
.AT 3
.SH NAME
imgsizer \- automatically splice in height and width params for HTML IMG tags
.SH SYNOPSIS
.B imgsizer [OPTIONS] [HTML File]
.PP
.SH OPTIONS
.TP
.B \-V, \-\-version
Display version information and exit.
.TP
.B \-h, \-\-help
Display usage information.
.TP
.B \-d <directory>, \-\-document\-root <directory>
Directory where aboslute image filenames (i.e, ones which contain
a leading "/") may be found.
.TP
.B \-n, \-\-no-overwwrite
.TP
.SH DESCRIPTION
The 
.B imgsizer
script automates away the tedious task of creating and updating the
extension HEIGHT and WIDTH parameters in HTML IMG tags.  These
parameters help many browsers (including Netscape) to multi-thread
image loading, instead of having to load images in strict sequence in
order to have each one's dimensions available so the next can be
placed.  This generally allows text on the remainder of the page
to load much faster.
.PP
This script will try create such attributes for any IMG tag that lacks
them.  It will correct existing HEIGHT and WIDTH tags unless either
contains a percent (%) sign, in which case the existing dimensuions
are presumed to be relative and left unaltered.
.PP
This script may be called with no arguments.  In this mode, it filters
HTML presented on stdin to HTML (unaltered except for added or
corrected HEIGHT and WIDTH attributes) on stdout.  If called with file
arguments, it will attempt to transform each file in place.  Each
argument file is not actually modified until the script completes a
successful conversion pass.
.PP
The \-d <directory> option sets the DocumentRoot, which images with an
absolute filename (i.e., ones which contain a leading "/") may be found.
If none is specified, the DocumentRoot defaults to the current working
directory.
.PP
The \-n (no-overwrite) opion prevents the program from overwriting 
existing width and height tags if both are present.
.PP
Additional options may also be specified in the environmental variable
"IMGSIZER".  For example, to avoid typing "imgsizer -d /var/www/docs" each
time imgsizer is invoked, you might tell sh (or one of its descendants):
.PP
.RS
IMGSIZER="\-d /var/www/docs"; export IMGSIZER
.RE
.PP
or, if you use csh:
.PP
.RS
setenv IMGSIZER "\-d /var/www/docs"
.RE
.PP
This script is written in Python, and thus requires a Python interpreter
on the host system.  It also requires either the 
.IR identify (1)
utility distributed in the open-source ImageMagick suite of image-display
and manipulation tools, or, with the \-\-no\-magick option, a modern
version of
.IR file (1)
and 
.IR rdjpgcom (1).
These  utilities are used to extract sizes from the images;
.B imgsizer
itself has no knowledge of graphics formats.  The script will handle any
image format known to 
.IR identify (1)
including PNG, GIF, JPEG, XBM, XPM, PostScript, BMP, TIFF, and anything else
even remotely likely to show up as an inline image.
.PP
.SH NOTE
The -q, -l, and -m options of the 1.0 versions are gone.  What they
used to do has been made unnecessary by smarter logic.
.SH AUTHOR
Originally created by Eric\ S.\ Raymond\ <esr@thyrsus.com>.  Additional code
contributed by Erik\ Rossen and Michael\ C.\ Toren\ <michael@toren.net>.
For updates, see <http://www.tuxedo.org/~esr>
.SH SEE ALSO
.IR identify (1),
.IR file (1),
.IR rdjpgcom(1).
