/*/////////////////////////////////////////Extcalc////////////////////////////////////////////
/////////////////////////////////Scientific Graphic Calculator////////////////////////////////

File:         statistics.h
Author:       Rainer Strobel
Email:        rainer1223@users.sourceforge.net
Homepage:     http://extcalc-linux.sourceforge.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Statistics window class of Extcalc.
The data table for statistical calculations is controlled by this class.
Graphical results were shown by the graphics window class.


////////////////////////////////////////////////////////////////////////////////////////////*/
#ifndef STATISTICS_H
#define STATISTICS_H


#include <qwidget.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qclipboard.h>
#include <qapplication.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qsplitter.h>
#include <qpushbutton.h>
#include <qtoolbar.h>
#include <qdockarea.h>
#include <qiconset.h>
#include <qpopupmenu.h>
#include <qtooltip.h>
#include "functiontable.h"
#include "buttons.h"
#include "catalog.h"

#define LISTCOUNT		5

/*
- approximation
  - const
  - line
  - e-function
  - log
  - sin
- interpolation (newton)
- Gaussian distribution
- bar graph
- points
- lines
- normal propability distribution calculations
*/




class StatisticsWidget :public QWidget
{
	Preferences pref;
	ThreadSync*threadData;
	Variable*vars;
	FunctionTable *functionTable;
	StandardButtons *standardButtons;
	QTable *lists;
	QSplitter *horzSplit,*vertSplit;
	QToolBar*toolBar;
	QDockArea*dockArea;
	QPixmap *minimizeIcon,*maximizeIcon,*printIcon,*catalogIcon;
	Catalog *catalog;
	QComboBox *typeBox, *functionTypeBox,*copyFunction,*listNumberBox;
	QSpinBox *listNumber,*stepsBox;
	QPushButton *calculateButton,*maximizeButton,*drawButton,*copyButton,*catalogButton;
	QLabel *listNumberLabel,*resultLabel,*copyFunctionLabel,*functionTypeLabel,*stepsLabel;
	QLineEdit * result,*inputLine;
	
	double xmin,xmax,ymin,ymax;
	bool print,functionChanged;
	bool fullscreen;
	int type,changedRow;
	int menuBottom;

	Q_OBJECT
	public:
		StatisticsWidget(QWidget*parent,Preferences p,Variable*va,ThreadSync*td,int mB) :QWidget(parent)
		{
			pref=p;
			threadData=td;
			vars=va;
			menuBottom=mB;
			fullscreen=false;
			functionChanged=false;
			type=STATAPPROX;
			print=false;
			changedRow=-1;

			horzSplit=new QSplitter(Qt::Horizontal,this);
			vertSplit=new QSplitter(Qt::Vertical,horzSplit);
			functionTable=new FunctionTable(vertSplit,pref);
			standardButtons=new StandardButtons(this);
			catalog=new Catalog(CATMATHSTD | CATMATHCOMPLEX,this);
		
			minimizeIcon=new QPixmap(INSTALLDIR+QString("/data/view_top_bottom.png"));
			maximizeIcon=new QPixmap(INSTALLDIR+QString("/data/view_remove.png"));
			printIcon=new QPixmap(INSTALLDIR+QString("/data/print.png"));
			catalogIcon=new QPixmap(INSTALLDIR+QString("/data/catalog.png"));
		
			dockArea=new QDockArea(Qt::Horizontal,QDockArea::Normal,this);
			toolBar=new QToolBar();
			dockArea->moveDockWindow(toolBar);
			
			drawButton=new QPushButton(*printIcon,STATISTICSH_STR14,toolBar);
			drawButton->setFixedHeight(25);
			maximizeButton=new QPushButton(*maximizeIcon,"",toolBar);
			lists=new QTable(horzSplit);
			lists->setNumRows(1);
			lists->setNumCols(2*LISTCOUNT);
			typeBox=new QComboBox(toolBar);
			functionTypeLabel=new QLabel(STATISTICSH_STR1,this);
			functionTypeBox=new QComboBox(this);
			listNumber=new QSpinBox(1,LISTCOUNT,1,this);
			listNumberLabel=new QLabel(STATISTICSH_STR2,this);
			resultLabel=new QLabel(STATISTICSH_STR3,this);
			result=new QLineEdit(this);
			inputLine=new QLineEdit(vertSplit);
			inputLine->setFixedHeight(25);
			for(int c=0; c<5; c++)
			{
				lists->horizontalHeader()->setLabel(2*c,"X"+QString::number(c+1));
				lists->horizontalHeader()->setLabel(2*c+1,"Y"+QString::number(c+1));
			}

			copyFunctionLabel=new QLabel(STATISTICSH_STR4,this);
			copyFunction=new QComboBox(this);
			copyButton=new QPushButton(STATISTICSH_STR5,this);
			for(int c=0; c<20; c++)
				copyFunction->insertItem("f"+QString::number(c+1)+"(x)");

			listNumberBox=new QComboBox(this);
			for(int c=0; c<LISTCOUNT; c++)
			{
				listNumberBox->insertItem("X"+QString::number(c+1));
				listNumberBox->insertItem("Y"+QString::number(c+1));
			}

			functionTypeBox->insertItem("const");
			functionTypeBox->insertItem("a*x+b");
			functionTypeBox->insertItem("a*x^2+b*x+c");
			functionTypeBox->insertItem("a*e^(b*x)");
			functionTypeBox->insertItem("a*b^x");

			typeBox->insertItem(STATISTICSH_STR6);
			typeBox->insertItem(STATISTICSH_STR7);
			typeBox->insertItem(STATISTICSH_STR8);
			typeBox->insertItem(STATISTICSH_STR9);
			typeBox->insertItem(STATISTICSH_STR10);

			stepsBox=new QSpinBox(1,100,1,this);
			stepsBox->setValue(10);
			stepsLabel=new QLabel(STATISTICSH_STR11,this);


			calculateButton=new QPushButton(STATISTICSH_STR12,this);
			catalogButton=new QPushButton(*catalogIcon,"",toolBar);
			catalogButton->setFixedWidth(30);
			maximizeButton->setFixedWidth(30);
			typeBox->setFixedWidth(120);
			
			readListsFile();

			typeBoxSlot(0);
			QObject::connect(functionTable,SIGNAL(prefChange(Preferences)),this,SLOT(getPref(Preferences)));
			QObject::connect(maximizeButton,SIGNAL(clicked()),this,SLOT(maximizeButtonSlot()));
			QObject::connect(calculateButton,SIGNAL(clicked()),this,SLOT(calculateButtonSlot()));
			QObject::connect(copyButton,SIGNAL(clicked()),this,SLOT(copyButtonSlot()));
			QObject::connect(drawButton,SIGNAL(clicked()),this,SLOT(printButtonSlot()));
			QObject::connect(typeBox,SIGNAL(activated(int)),this,SLOT(typeBoxSlot(int)));
			QObject::connect(lists,SIGNAL(valueChanged(int,int)),this,SLOT(itemChangedSlot(int,int)));
			QObject::connect(standardButtons,SIGNAL(emitText(QString)),this,SLOT(buttonInputSlot(QString)));
			QObject::connect(standardButtons,SIGNAL(prefChange(Preferences)),this,SLOT(getPref(Preferences)));
			QObject::connect(catalog,SIGNAL(menuSignal(QString)),this,SLOT(buttonInputSlot(QString)));
			QObject::connect(catalogButton,SIGNAL(clicked()),this,SLOT(catalogSlot()));
			QObject::connect(functionTable,SIGNAL(currentChanged(int,int)),this,SLOT(selectionChangedSlot(int,int)));
			QObject::connect(functionTable,SIGNAL(textEditStarted(QString)),this,SLOT(tableEditSlot(QString)));
			QObject::connect(inputLine,SIGNAL(returnPressed()),this,SLOT(inputTextFinished()));
			QObject::connect(inputLine,SIGNAL(textChanged(const QString&)),this,SLOT(inputTextChanged(const QString&)));
		}

		void setPref(Preferences);
		void writeListsFile();
		void readListsFile();
		void setCoordinateSystem();

	public slots:
		void getPref(Preferences);
		void maximizeButtonSlot();
		void typeBoxSlot(int);
		void calculateButtonSlot();
		void itemChangedSlot(int,int);
		void copyButtonSlot();
		void printButtonSlot();
		void buttonInputSlot(QString);
		void redrawGraphSlot();
		void dockWindowSlot();
		void catalogSlot();
		
		void selectionChangedSlot(int row,int col);
		void tableEditSlot(QString);
		void inputTextChanged(const QString&);
		void inputTextFinished();

	protected:
		void resizeEvent(QResizeEvent*);

	signals:
		void prefChange(Preferences);
		void printSignal();
		void changeTabSignal(int);
		void drawPointsSignal(long double*,int,bool);
		void removeLinesSignal();

};

#endif


