/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: get_number.c
 */

#ifndef _LVM_HELP_GET_NUMBER_
#define _LVM_HELP_GET_NUMBER_ 1

/* Function: get_number
 *
 *	This function is based on code from the lvm_check_number function in
 *	the LVM tools library, from Heinz Mauelshagen and Sistina Software
 *	(www.sistina.com).
 *
 *	It converts a string with an optional suffix (K,M,G,T)
 *	into the equivalent integer number (kilobyte-based). Default is 'M'.
 */
long get_number( char * number_str )
{
	char	buffer[80]	= {0};
	char	*ptr		= NULL;
	char	*dimensions	= "kmgtp";
	long	multiplier	= 1;
	int	c,i,j;

	strncpy(buffer, number_str, 79);
	ptr = buffer;
	
	// Read to the first non-numeric character
	for ( i = 0; ptr[i]; i++ ) {
		if ( ptr[i] == ',')
			ptr[i] = '.';
		if ( ! isdigit(ptr[i]) && ptr[i] != '.' )
			break;
	}

	if ( ptr[i] && ! ptr[i+1] ) {
		c = tolower(ptr[i]);
		for ( j = 0; dimensions[j]; j++) {
			if ( c == dimensions[j])
				break;
		}
		if ( dimensions[j] ) { /* wrong dimension given? */
			for ( ; j > 0; j--) {
				multiplier *= 1024;
			}
			ptr[i] = 0;
		}
		else {
			multiplier = 1024;
		}
	}
	else {
		multiplier = 1024;
	}

	return( atof(buffer) * multiplier );
}

#endif

