/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_dlist.h
 */

#ifndef _MD_DLIST_H_
#define _MD_DLIST_H_ 1

// Functions exported from md_dlist.c
int md_append_region_to_object(storage_object_t	* region,
			       storage_object_t	* object );
int md_remove_region_from_object(storage_object_t	* region,
				 storage_object_t	* object );
int md_clear_child_list( storage_object_t * region, dlist_t children );
int md_add_object_to_list( storage_object_t	* object,
			   dlist_t		objects );
int md_transfer_list( dlist_t	input,
		      dlist_t	output );

void md_remove_volume_from_list(md_volume_t * volume);
void md_add_volume_to_list(md_volume_t * volume);

void md_rediscover_volumes_for_region(storage_object_t * region);

int md_add_modify_object_to_list(md_volume_t * volume, int cmd, int major, int minor);

int md_process_modify_list(md_volume_t * volume, int cmd);
#endif

