#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Eric4 Re

This is the main Python script that performs the neccessary initialization
of the PyRegExp wizard module and starts the Qt event loop. This is a standalone 
version of the integrated PyRegExp wizard.
"""

import sys

if "--nokde" in sys.argv:
    del sys.argv[sys.argv.index("--nokde")]
    os.environ["e4nokde"] = "1"

from Utilities import Startup


def createMainWidget(argv):
    """
    Function to create the main widget.
    
    @param argv list of commandline parameters (list of strings)
    @return reference to the main widget (QWidget)
    """
    from Plugins.WizardPlugins.PyRegExpWizard.PyRegExpWizardDialog import \
        PyRegExpWizardDialog
    return PyRegExpWizardDialog(fromEric = False)

def main():
    """
    Main entry point into the application.
    """
    options = [\
        ("--nokde" , "don't use KDE widgets"),
    ]
    appinfo = Startup.makeAppInfo(sys.argv,
                                  "Eric4 RE",
                                  "",
                                  "Regexp editor for the Python re module",
                                  options)
    res = Startup.simpleAppStartup(sys.argv,
                                   appinfo,
                                   createMainWidget)
    sys.exit(res)

if __name__ == '__main__':
    main()
