# -*- coding: utf-8 -*-

# Copyright (c) 2005 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a CSS lexer with some additional methods.
"""

from PyQt4.Qsci import QsciLexerCSS
from PyQt4.QtCore import QString

from Lexer import Lexer
import Preferences

class LexerCSS(QsciLexerCSS, Lexer):
    """ 
    Subclass to implement some additional lexer dependant methods.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget of this lexer
        """
        QsciLexerCSS.__init__(self, parent)
        Lexer.__init__(self)
        
        self.commentString = QString("#")
        self.streamCommentString = {
            'start' : QString('/* '),
            'end'   : QString(' */')
        }
    
    def initProperties(self):
        """
        Public slot to initialize the properties.
        """
        self.setFoldComments(Preferences.getEditor("CssFoldComment"))
        self.setFoldCompact(Preferences.getEditor("AllFoldCompact"))
