# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE Printer instead of the Qt Printer.
"""

import os

import Preferences

try:
    raise ImportError
    # TODO: KDE 4
##    from qt import QPrinter
##    from kdeprint import KPrinter
##    class KQPrinter(KPrinter):
##        """
##        Compatibility class to use the KDE Printer instead of the Qt Printer.
##        """
##        ScreenResolution = QPrinter.ScreenResolution
##        PrinterResolution = QPrinter.PrinterResolution
##        HighResolution = QPrinter.HighResolution
##        Compatible = QPrinter.Compatible

except (ImportError, RuntimeError):
    os.environ["e4nokde"] = "1"

from PyQt4.QtGui import QPrinter
class __qtKQPrinter(QPrinter):
    """
    Compatibility class to use the Qt Printer.
    """
    pass
    # TODO: KDE 4
    # add the method setup() opening a print dialog, returns true if OK was pressed
    # def setup(self, parent = None, caption = QString()):

################################################################################

def KQPrinter(mode = QPrinter.ScreenResolution):
    """
    Public function to instantiate a printer object.
    
    @param mode printer mode (QPrinter.PrinterMode)
    @return reference to the printer object
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        return __kdeKQPrinter(mode)
    else:
        return __qtKQPrinter(mode)

Color = QPrinter.Color
GrayScale = QPrinter.GrayScale

FirstPageFirst = QPrinter.FirstPageFirst
LastPageFirst = QPrinter.LastPageFirst

Portrait = QPrinter.Portrait
Landscape = QPrinter.Landscape

ScreenResolution = QPrinter.ScreenResolution
PrinterResolution = QPrinter.PrinterResolution
HighResolution = QPrinter.HighResolution
