# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE Progress Dialog instead of the Qt Progress Dialog.
"""

try:
    import os
    if os.getenv("e3nokde"):
        raise ImportError
        
    from kdeui import KProgressDialog
    from qt import QString
    
    class KQProgressDialog(KProgressDialog):
        """
        Compatibility class to use the KDE Progress Dialog instead of the Qt Progress Dialog.
        """
        def __init__(self, labelText, cancelButtonText, totalSteps,
                     parent = None, name = None, modal = 0, f = 0):
            """
            Constructor
            
            @param labelText text to show in the progress dialog
            @param cancelButtonText text to show for the cancel button or
                None to disallow cancellation and to hide the cancel button
            @param totalSteps total number of steps for the progress bar
            @param parent parent of the progress dialog
            @param name name of the progress dialog
            @param modal flag setting the modal state
            @param f window flags (ignored)
            """
            KProgressDialog.__init__(self, parent, name, QString.null, labelText, modal)
            self.bar = self.progressBar()
            self.bar.setTotalSteps(totalSteps)
            if cancelButtonText is QString.null or unicode(cancelButtonText) == "":
                self.setAllowCancel(0)
            else:
                self.setButtonText(cancelButtonText)
            
        def setTotalSteps(self, totalSteps):
            """
            Public slot to set the total number of stepd for the progress bar.
            
            @param totalSteps total number of steps for the progress bar
            """
            self.bar.setTotalSteps(totalSteps)
        
        def setProgress(self, progress):
            """
            Public slot to set the current progress of the progress bar.
            
            @param progress progress value to set
            """
            self.bar.setProgress(progress)

except (ImportError, RuntimeError):
    from qt import QProgressDialog
    class KQProgressDialog(QProgressDialog):
        """
        Compatibility class to use the Qt Progress Dialog.
        """
        pass
