# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog showing a pixmap.
"""

import glob
import os

import sys

from qt import *
from qtcanvas import *

from PixmapCanvasView import PixmapCanvasView

class PixmapDiagram(QDialog):
    """
    Class implementing a dialog showing a pixmap.
    """
    def __init__(self,pixmap,parent = None,name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param pixmap filename of a graphics file to show (QString or string)
        @param parent parent widget of the view (QWidget)
        @param name name of the view widget (QString or string)
        @param modal flag indicating a modal dialog (boolean)
        @param flags the window flags to be passed to the view widget
        """
        QDialog.__init__(self,parent,name,modal,fl)

        if not name:
            self.setName("PixmapDiagram")

        PixmapFormLayout = QVBoxLayout(self,6,6,"PixmapFormLayout")

        self.canvas = QCanvas(800, 600)
        self.pixCanvas = PixmapCanvasView(self.canvas,self,"pixCanvas")
        self.pixCanvas.setGeometry(QRect(6,6,788,555))
        PixmapFormLayout.addWidget(self.pixCanvas)

        layout1 = QHBoxLayout(None,0,6,"layout1")
        spacer = QSpacerItem(40,20,QSizePolicy.Expanding,QSizePolicy.Minimum)
        layout1.addItem(spacer)

        self.closeButton = QPushButton(self,"closeButton")
        layout1.addWidget(self.closeButton)
        spacer_2 = QSpacerItem(40,20,QSizePolicy.Expanding,QSizePolicy.Minimum)
        layout1.addItem(spacer_2)
        PixmapFormLayout.addLayout(layout1)

        self.languageChange()

        self.resize(QSize(800,604).expandedTo(self.minimumSizeHint()))
        self.clearWState(Qt.WState_Polished)

        self.connect(self.closeButton,SIGNAL("clicked()"),self,SLOT("close()"))
        
        self.pixmapfile = pixmap
        self.status = self.pixCanvas.showPixmap(self.pixmapfile)


    def languageChange(self):
        """
        Private method used to show the localized strings for this dialog.
        """
        self.setCaption(self.__tr("Pixmap-Viewer"))
        self.closeButton.setText(self.__tr("&Close"))
        self.closeButton.setAccel(self.__tr("Alt+C"))


    def __tr(self,s,c = None):
        """
        Private method to translate the display strings.
        """
        return qApp.translate("PixmapDiagram",s,c)


    def getDiagramName(self):
        """
        Method to retrieve a name for the diagram.
        
        @return name for the diagram
        """
        return self.pixmapfile
        
    def getStatus(self):
        """
        Method to retrieve the status of the canvas.
        
        @return flag indicating a successful pixmap loading (boolean)
        """
        return self.status
