#include <string.h>
#include <stdlib.h>
#include <glib.h>

#include "entity.h"

static GHashTable *require_ht = NULL;

static gint
rend_require_file_already_loaded (gchar * filename)
{
    return (GPOINTER_TO_INT (g_hash_table_lookup (require_ht, filename)));
}

/* 
 * static void rend_require_loaded_file (gchar *filename) {
 * g_hash_table_insert (require_ht, filename, GINT_TO_POINTER (TRUE)); } */

static gint
rend_require_file_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    gchar *fpath;

    /* Initialize hash table if necessary */
    if (require_ht == NULL)
	require_ht = g_hash_table_new (g_str_hash, g_str_equal);


    if (ebuf_not_empty (value)) {
	EDEBUG (("requirerend", "filename = %s", value->str));
	fpath = eutils_file_search (node, value->str);

	if (fpath) {
	    /* Check to see if it's already been loaded */
	    if (rend_require_file_already_loaded (fpath)) {
		EDEBUG (
			("requirerend", "Not loading %s, already loaded.",
			 fpath));
		g_free (fpath);
		return (TRUE);
	    }

	    g_hash_table_insert (require_ht, fpath, GINT_TO_POINTER (1));

	    EDEBUG (("requirerend", "%s found, parseing...", fpath));

	    /* Set the filename in the require. */
	    enode_attrib_str (node, "__filename", fpath);
	    xml_parse_file (node, fpath);

            /* We don't free fpath because it is being used in the 
             * hash table */
	} else {
	    gchar *function = enode_attrib_str (node, "onerror", NULL);
	    if (function) {
		enode_call_ignore_return (node, function, "s",
					  "Error loading require file.");
	    }
	}
    }

    return (TRUE);
}

static void
rend_require_render (ENode * node)
{
    enode_attribs_sync (node);
}


static void
rend_require_parent (ENode * parent_node, ENode * child_node)
{
    erend_short_curcuit_parent (parent_node, child_node);
}

void
require_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->render_func = rend_require_render;
    element->parent_func = rend_require_parent;
    element->tag = "require";
    element->description =
	"Specify a file that must be loaded.  If the file is already loaded, it will not be loaded again.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "file";
    e_attr->description =
	"Path to XML file to require for use.  Specified file is only ever loaded once.";
    e_attr->value_desc = "string";
    e_attr->set_attr_func = rend_require_file_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onerror";
    e_attr->description = "Function to call when an error occurs";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(node, error_message)";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "__filename";
    e_attr->description = "The full path of the file that has been loaded.";
    e_attr->value_desc = "string";
    e_attr->set_attr_func = NULL;
    element_register_attrib (element, e_attr);
}
