#ifndef __LINE_H__
#define __LINE_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include <stdlib.h>

/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

typedef struct {
  char   *str;
  size_t  filled;
  size_t  size;
} line_t;


/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern line_t *line_create (int size);
extern void    line_destroy (line_t *line);
extern void    line_clear (line_t *line);
extern void    line_put_str_len (line_t *line, const char *str, size_t len);
extern void    line_put_str (line_t *line, const char *str);
extern void    line_add_str_len (line_t *line, const char *str, size_t len);
extern void    line_add_str_limit (line_t *line, const char *str, size_t limi);
extern void    line_add_str_pad (line_t *line, const char *str, size_t padlen);
extern void    line_add_str_end (line_t *line, const char *str);
extern void    line_add_str (line_t *line, const char *str);
extern void    line_add_str_dots (line_t *line, const char *str);
extern void    line_add_char (line_t *line, char c);
extern void    line_add_int (line_t *line, int x);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER line.h
 *
 ****************************************************************************/
#endif
