#include "ptg_chk.h"

#include <string.h>
#include "ptg_ana.h"
#include "deftbl.h"
#include "keyarray.h"
#include "err.h"

#include "pdl_gen.h"

#ifdef PROTO_OK
int Check_Types(POSITION *coord, KeyArray p1, KeyArray p2)
#else
int Check_Types(coord, p1, p2)
POSITION *coord;
KeyArray p1, p2;
#endif
{
                int i, j, s1, s2;
                DefTableKey ki, kj;
                ComponentKind comp_i, comp_j;                   
        
                s1 = KeyArraySize(p1);
                s2 = KeyArraySize(p2);
        
                for (i = 0; i < s1; i++)
                {
                        ki = FetchKeyFromArray(p1, i);
                        comp_i = GetKind(ki, NOCOMPONENT);
                        if (comp_i == INSPOINT || comp_i == FCTCALL) for (j = 0; j < s2; j++)
                        {
                                kj = FetchKeyFromArray(p2, j);
                                comp_j = GetKind(kj, NOCOMPONENT);
                                if (ki != kj && comp_i == INSPOINT && comp_j == INSPOINT)
                                {
                                        int xi, xj;
                                        NodeType ti, tj;
                                        xi = GetIndex(ki, -1);
                                        xj = GetIndex(kj, -1);
                                        ti = GetType(ki, UNDEF);
                                        tj = GetType(kj, UNDEF);
                                
                                        if (xi == xj && ti != tj)
                                        {
                                                char buffer[256];
                                                sprintf (buffer, "Conflicting types for $%d", xi);
                                                message(ERROR, buffer, 0, coord);
                                                return 1;
                                        }
                                }
                                if (comp_i == FCTCALL && j == 0)
                                {
                                        if (Check_Types(coord, p2, GetArguments(ki, NoKeyArray)))
                                                return 1;
                                }
                                
                                if (i == 0 && comp_j == FCTCALL)
                                {
                                        if (Check_Types(coord, p1, GetArguments(kj, NoKeyArray)))
                                                return 1;
                                }
                                
                        }
                }
        
        

        return 0;
}


int 
#ifdef PROTO_OK
ComparePattern(KeyArray p1, KeyArray p2)
#else
ComparePattern(p1, p2)
KeyArray p1, p2;
#endif
{
        int n = KeyArraySize(p1);
        int i;

        if (n != KeyArraySize(p2))
                return 0;
        for (i = 0; i < n; i++)
        {
                DefTableKey k1, k2;
                KeyArray args1, args2;
                
                k1 = FetchKeyFromArray(p1, i);
                k2 = FetchKeyFromArray(p2, i);

                /* Information for every Pattern Component */
                if (GetKind(k1, NOCOMPONENT) != GetKind(k2, NOCOMPONENT))
                        return 0;
                if (GetOptional(k1, -1) != GetOptional(k2, -1))
                        return 0;

                /* Information for Insertion points */
                if (GetIndex(k1, -1) != GetIndex(k2, -1))
                        return 0;
                if (GetType(k1, UNDEF) != GetType(k2, UNDEF))
                        return 0;

                /* Information for fixed strings */
                if (strcmp(GetString(k1, ""), GetString(k2, "")) != 0)
                        return 0;

                /* Information for function insertions */
                if (GetFunctionSym(k1, -1) != GetFunctionSym(k2, -1))
                        return 0;

                args1 = GetArguments(k1, NoKeyArray);
                args2 = GetArguments(k2, NoKeyArray);
                if (args1 != NoKeyArray && args2 != NoKeyArray)
                {
                        if (!ComparePattern(args1, args2))
                                return 0;
                }
                else if (args1 != NoKeyArray || args2 != NoKeyArray)
                        return 0;
        }

        return 1;
}


static PatternList pl = NULLPatternList;

static PatternListPtr pl_end = &pl;

static void 
#ifdef PROTO_OK
AppendPattern(POSITION *coord, int id, KeyArray pattern)
#else
AppendPattern(coord, id, pattern)
POSITION *coord; 
int id; 
KeyArray pattern;
#endif
{
        Pattern p;

        p.coord = coord;
        p.sym = id;
        p.pattern = pattern;

        pl_end = RefEndConsPatternList(pl_end, p);
}       


int
#ifdef PROTO_OK
CheckMultiplePatterns(POSITION *coord, int id, KeyArray pattern)
#else
CheckMultiplePatterns(coord, id, pattern)
POSITION *coord; 
int id; 
KeyArray pattern;
#endif
{
        PatternList curr = pl;
        int returnsym = 0;              /* Other symbol with same pattern */

        while (curr != NULLPatternList)
        {
                Pattern p;
                int equal;

                p = HeadPatternList(curr);
                equal = ComparePattern(pattern, p.pattern);

#ifdef DEBUG_PTG
                printf("Patterns for %s and %s are %s\n",
                        StringTable(id), StringTable(p.sym), equal ? "equal" : "not equal");
#endif
                if (id == p.sym)
                {
                        if (equal)
                        {
                                returnsym = id;
                        }
                        else
                        {
                                char msg[512];
                                sprintf(msg, "redeclaration of pattern '%s' exists", StringTable(id));
                                message(ERROR, msg, 0, coord);
                                message(ERROR, msg, 0, p.coord);
                        }
                }
                else if (equal && (returnsym == 0 || returnsym != id))
                        returnsym = p.sym;
                

                curr = TailPatternList(curr);
        }

        if (returnsym != id)
                AppendPattern(coord, id, pattern);
        return returnsym;
}               


static char *predefed[] = 
{ 
        "Node", "NULL", "Null", "Out", "OutFile", "OutFPtr", "Free", "Process", 0
};
        

#ifdef PROTO_OK
int IsPredefined(char *nodename)
#else
int IsPredefined(nodename) 
char *nodename;
#endif
{
        int i = 0;

        while(predefed[i])
        {
                if (strcmp(predefed[i++], nodename) == 0)
                        return 1;
        }

        if (strncmp(nodename, "_OUTPUT", 7) == 0)
                return 1;

        return 0;
}


int 
#ifdef PROTO_OK
CompareArguments(KeyArray p1, KeyArray p2)
#else
CompareArguments(p1, p2)
KeyArray p1, p2;
#endif
{
        int n = KeyArraySize(p1);
        int i;

        if (n != KeyArraySize(p2))
                return 0;
        for (i = 0; i < n; i++)
        {
                DefTableKey k1, k2;
                KeyArray args1, args2;
                
                k1 = FetchKeyFromArray(p1, i);
                k2 = FetchKeyFromArray(p2, i);

                /* Information for Insertion points */
                if (GetType(k1, UNDEF) != GetType(k2, UNDEF))
                        return 0;
        }

        return 1;
}

