/* 
    tree.cc for v4l devices

    Copyright (C) 2000 Marcus Metzler (mocm@metzlerbros.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "tree.hh"
#include "audio.hh"
#include "channel.hh"
#include "common.hh"
#include "interface.hh"

extern DVB dvb;
extern ChannelList chlist[NLIST];
extern GtkWidget *clists[NLIST];
extern int clistn;
extern GtkWidget *t_widget;
extern GtkAccelGroup *accel_group;
extern int no_crypt;

void show_dvb(GtkWidget * w, gpointer data)
{
	static int visible = 0;
	static int made = 0;
	GtkWidget *widget = GTK_WIDGET(data);

	if (!made){
		char buf[80];
		ostrstream str(buf, 80);
		str << _("Making new Tree. Please wait.") << ends;
		
		status_message(buf);
		make_tree();
		made = 1;
	}
	
	if (visible) {
		gtk_widget_hide(widget);
		visible = 0;
	} else {
		gtk_widget_show(widget);
		visible = 1;
	}
}

static void toggle_crypt(GtkWidget * w, gpointer data)
{
	GtkWidget *widget = GTK_WIDGET(data);
	
	if (no_crypt) no_crypt =0;
	else no_crypt = 1;

	gtk_widget_destroy(t_widget);
	t_widget = gtk_tree_new();
	make_tree();

	gtk_container_add(GTK_CONTAINER(widget), t_widget);
	
}


GtkWidget *item_to_tree(GtkWidget * tree, char *name1,
			char *name2 = NULL, int num = 0)
{
	char name[80];
	GtkWidget *item;

	if (!name1[0]) {
		ostrstream str(name, 80);
		str << name2 << num << ends;
	} else if (!name2)
		strcpy(name, name1);
	else {
		ostrstream str(name, 80);
		str << name1 << name2 << ends;
	}

	item = gtk_tree_item_new_with_label(name);

	gtk_tree_append(GTK_TREE(tree), item);
	gtk_widget_show(item);

	return item;
}

static void add_channel_dvb(GtkWidget * widget, int chnr)
{
	int k = 0, i = 0, j = 0;

	while (k < dvb.num[TRANS] &&
	       dvb.tps[k].id != dvb.chans[chnr].tpid)
		k++;
	while (i < dvb.num[SAT] &&
	       dvb.tps[k].satid != dvb.sats[i].id)
		i++;
	while (j < dvb.num[LNB] &&
	       dvb.sats[i].lnbid != dvb.lnbs[j].id)
		j++;


	gChannel ch(dvb.chans[chnr], dvb.tps[k], dvb.lnbs[j]);
	chlist[clistn].AddChannel(ch);

	set_list(clistn);
}

void set_channel_dvb(GtkWidget * widget,int chnr)
{

	char buf[80];
	ostrstream str(buf, 80);
	str << _("Setting ") 
	    << dvb.chans[chnr].name << " ("<< dvb.chans[chnr].pnr 
	    << ")" << ends;

	status_message(buf);

	dvb.SetChannel(chnr);
	set_audio_menu(&dvb.chans[chnr]);

#ifndef NAPI
	dvb.osd.Hide();
#endif
}

GtkWidget *channel_item_to_tree(GtkWidget * tree, int chanr)
{
	char name[80];
	GtkWidget *item, *nmenubar, *menu, *menuitem;
	char *name1 = dvb.chans[chanr].name;
	char *name2 = _("Channel ");
	int num = dvb.chans[chanr].pnr;

	ostrstream str(name, 80);
	if (!name1[0]) {
		str << name2 << num;
	} else
		str << name1;

	if (dvb.chans[chanr].type)
		str << " (s)";
	str << ends;

	item = gtk_tree_item_new();
	gtk_tree_append(GTK_TREE(tree), item);
	gtk_widget_show(item);

	nmenubar = gtk_menu_bar_new();
	gtk_container_add(GTK_CONTAINER(item), nmenubar);
	gtk_widget_show(nmenubar);
	menu = CreateBarSubMenu(nmenubar, name);
	menuitem = CreateMenuItem(menu, _("Set"), "", "set",
				  GTK_SIGNAL_FUNC(set_channel_dvb),
				  (void *) chanr,accel_group);

	menuitem = CreateMenuItem(menu, _("Add to favorite"), "", "add",
				  GTK_SIGNAL_FUNC(add_channel_dvb),
				  (void *) chanr,accel_group);

	return item;
}


char *fecs[9] =
    { "1/2", "2/3", "3/4", "4/5", "5/6", "6/7", "7/8", "8/9", "Auto" };
char *pols[2] = { "V", "H" };
char *mods[6] = { "QPSK", "QAM 16", "QAM 32", "QAM 64", "QAM 128", "QAM 256"};
char *fecs2[7] = { "Auto", "1/2", "2/3", "3/4", "5/6", "7/8", "None" };
char *hier[4] = {"none","1","2","4"};
char *guards[4] = {"1-32","1-16","1-8","1-4"};

static void channel_leaves(GtkWidget * subtree, int j, int k)
{
	if (dvb.chans[j].type & no_crypt)
		return;


	GtkWidget *item1 = channel_item_to_tree(subtree, j);

	GtkWidget *subtree1 = gtk_tree_new();
	gtk_widget_show(subtree1);
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(item1), subtree1);

	GtkWidget *sstree1 = subtree1;
	item1 = item_to_tree(sstree1, "\0", "PNR: ", 
			     dvb.chans[j].pnr);
	item1 = item_to_tree(sstree1, "\0", "Freq.: ", 
			     dvb.tps[k].freq / 1000);
	switch(dvb.front_type){

	case FE_QPSK:
		item1 = item_to_tree(sstree1, "Pol.: ", 
				     pols[dvb.tps[k].pol]);
		item1 = item_to_tree(sstree1, "\0", "SR: ", 
				     dvb.tps[k].srate / 1000);
		item1 = item_to_tree(sstree1, "FEC: ", 
				     fecs[dvb.tps[k].fec]);
		break;

	case FE_QAM:
		item1 = item_to_tree(sstree1, "\0", "SR: ", 
				     dvb.tps[k].srate / 1000);
		item1 = item_to_tree(sstree1, "FEC: ", 
				     fecs[dvb.tps[k].fec]);
		item1 = item_to_tree(sstree1, "QAM: ", 
				     mods[dvb.tps[k].qam]);
		break;

	case FE_OFDM:
		item1 = item_to_tree(sstree1, "\0","Bandw.: ", 
				     8-dvb.tps[k].band);
		item1 = item_to_tree(sstree1, "HP: ", 
				     fecs2[dvb.tps[k].hp_rate]);
		item1 = item_to_tree(sstree1, "LP: ", 
				     fecs2[dvb.tps[k].lp_rate]);
		item1 = item_to_tree(sstree1, "Mod: ", 
				     mods[dvb.tps[k].transmode]);
		item1 = item_to_tree(sstree1, "Hiera.: ", 
				     hier[dvb.tps[k].hierarchy]);
		item1 = item_to_tree(sstree1, "Guard: ", 
				     guards[dvb.tps[k].guard]);

	}
	if (dvb.chans[j].vpid != NOPID && dvb.chans[j].vpid != 0) {
		item1 = item_to_tree(sstree1, "\0", "VPID: ",
				     dvb.chans[j].vpid);
		item1 = item_to_tree(sstree1, "\0", "PMT: ",
				     dvb.chans[j].pmtpid);
	}
	item1 = item_to_tree(sstree1, "\0", "PCR: ", 
			     dvb.chans[j].pcrpid);
	if (!dvb.chans[j].ac3pid == NOPID && !dvb.chans[j].ac3pid == 0)
		item1 = item_to_tree(sstree1, "\0", "AC3PID: ",
				     dvb.chans[j].ac3pid);
	
	if (dvb.chans[j].apidnum > 1) {
		item1 = item_to_tree(sstree1, "APID");
		subtree1 = gtk_tree_new();
		gtk_widget_show(subtree1);
		gtk_tree_item_set_subtree(GTK_TREE_ITEM(item1), subtree1);
		for (int l = 0; l < dvb.chans[j].apidnum; l++)
			item1 = item_to_tree(subtree1, "\0", "APID: ",
					     dvb.chans[j].apids[l]);
	} else
		item1 =
		    item_to_tree(sstree1, "\0", "APID: ",
				 dvb.chans[j].apids[0]);
}


static void channel_tree(GtkWidget * tree, unsigned int tpid = NOPID, 
			 unsigned int satid = NOPID, 
			 unsigned int onid = NOPID, 
			 unsigned int bid = NOPID)
{

	GtkWidget *item = item_to_tree(tree, _("Channels"));
	GtkWidget *subtree = gtk_tree_new();
	gtk_widget_show(subtree);
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(item), subtree);

	GtkWidget *item1 = item_to_tree(subtree, "TV");
	GtkWidget *subtree1 = gtk_tree_new();
	gtk_widget_show(subtree1);
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(item1), subtree1);

	GtkWidget *item2 = item_to_tree(subtree, _("Radio"));
	GtkWidget *subtree2 = gtk_tree_new();
	gtk_widget_show(subtree2);
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(item2), subtree2);

	int k = 0;
	int tv = 0;
	int radio = 0;

	if ( tpid == NOPID && satid == NOPID && onid == NOPID && 
	     bid == NOPID) {
		int *sort;
		int nch = dvb.num[CHAN];

		sort = new int [nch];
		memset(sort,0,nch);

		sort[0] = 0;
		for (int j = 1; j < nch; j++) {
			sort[j] = j;

			for (int l = 0; l < j ; l++){
				int scmp = 0;
				scmp = strcmp(dvb.chans[j].name,
						  dvb.chans[sort[l]].name);
					
				if (scmp <= 0){ 
					for (int i=j; i>l; i--) 
						sort[i]=sort[i-1];
					sort[l] = j;
					break;
				} 
			}

		}

		for (int j = 0; j < nch; j++) {
			k = 0;
			while (k < dvb.num[TRANS] &&
			       dvb.tps[k].id != dvb.chans[sort[j]].tpid)
				k++;
			if (dvb.chans[sort[j]].apidnum == 0
			    || dvb.chans[sort[j]].vpid != NOPID) {
				channel_leaves(subtree1, sort[j], k);
				tv++;
			} else {
				channel_leaves(subtree2, sort[j], k);
				radio++;
			}
		}		
		delete [] sort;
	} else for (int j = 0; j < dvb.num[CHAN]; j++) {
		
		int add = 0;
		while (k < dvb.num[TRANS] &&
		       dvb.tps[k].id != dvb.chans[j].tpid)
			k++;
		
		if (tpid != NOPID && dvb.chans[j].tpid == tpid)
			add = 1;
		if (satid != NOPID && dvb.tps[k].satid == satid)
			add = 1;
		if (onid != NOPID && dvb.chans[j].onid == onid)
			add = 1;
		if (bid != NOPID && dvb.chans[j].bid == bid)
			add = 1;
	
	
		if (add) {
			if (dvb.chans[j].apidnum == 0 || 
			    dvb.chans[j].vpid != 0) {
				channel_leaves(subtree1, j, k);
				tv++;
			} else {
				channel_leaves(subtree2, j, k);
				radio++;
			}
		}
	}
	if (!tv)
		gtk_tree_item_remove_subtree(GTK_TREE_ITEM(item1));

	if (!radio)
		gtk_tree_item_remove_subtree(GTK_TREE_ITEM(item2));
}

static void transponder_tree(GtkWidget * tree, unsigned int satid)
{

	GtkWidget *item = item_to_tree(tree, _("Transponders"));
	GtkWidget *subtree = gtk_tree_new();
	gtk_widget_show(subtree);
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(item), subtree);



	for (int k = 0; k < dvb.num[TRANS]; k++) {
		if (dvb.tps[k].satid == satid) {
			GtkWidget *item2 =
			    item_to_tree(subtree, dvb.tps[k].name,
					 _("Transponder "), dvb.tps[k].id);

			GtkWidget *subtree2 = gtk_tree_new();
			gtk_widget_show(subtree2);
			gtk_tree_item_set_subtree(GTK_TREE_ITEM(item2),
						  subtree2);

			item2 = item_to_tree(subtree2, _("Info"));
			GtkWidget *sstree2 = gtk_tree_new();
			gtk_widget_show(sstree2);
			gtk_tree_item_set_subtree(GTK_TREE_ITEM(item2),
						  sstree2);
			item2 =
			    item_to_tree(sstree2, "\0", "Freq: ",
					 dvb.tps[k].freq / 1000);
			item2 =
			    item_to_tree(sstree2, "\0", "Pol: ",
					 dvb.tps[k].pol);
			item2 =
			    item_to_tree(sstree2, "\0", "SR: ",
					 dvb.tps[k].srate / 1000);
			item2 =
			    item_to_tree(sstree2, "\0", "FEC: ",
					 dvb.tps[k].fec);

			channel_tree(subtree2, dvb.tps[k].id);

		}
	}
}


void make_tree()
{
	if (dvb.num[SAT] > 0) {
		GtkWidget *item0 = item_to_tree(t_widget, _("Satellites"));
		GtkWidget *subtree0 = gtk_tree_new();
		gtk_widget_show(subtree0);
		gtk_tree_item_set_subtree(GTK_TREE_ITEM(item0), subtree0);

		for (int k = 0; k < dvb.num[SAT]; k++) {
			GtkWidget *item1 =
			    item_to_tree(subtree0, dvb.sats[k].name,
					 "Satellite ", dvb.sats[k].id);

			GtkWidget *subtree1 = gtk_tree_new();
			gtk_widget_show(subtree1);
			gtk_tree_item_set_subtree(GTK_TREE_ITEM(item1),
						  subtree1);

			item1 = item_to_tree(subtree1, _("Info"));
			GtkWidget *sstree1;
			sstree1 = gtk_tree_new();
			gtk_widget_show(sstree1);
			gtk_tree_item_set_subtree(GTK_TREE_ITEM(item1),
						  sstree1);
			item1 =
			    item_to_tree(sstree1, "\0", "Fmin: ",
					 dvb.sats[k].fmin / 1000);
			item1 =
			    item_to_tree(sstree1, "\0", "Fmax: ",
					 dvb.sats[k].fmax / 1000);

			transponder_tree(subtree1, dvb.sats[k].id);

			channel_tree(subtree1, NOPID, dvb.sats[k].id);

		}
		gtk_widget_show(t_widget);
	}
	channel_tree(t_widget);
	
}




GtkWidget *make_tree_dialog()
{

	GtkWidget *dialog1;
	GtkWidget *dialog_vbox1;
	GtkWidget *scrolledwindow1;
	GtkWidget *viewport1;
	GtkWidget *dialog_action_area1;
	GtkWidget *hbuttonbox1;
	GtkWidget *button1;
	GtkWidget *button2;

	dialog1 = gtk_dialog_new();
	gtk_object_set_data(GTK_OBJECT(dialog1), "dialog1", dialog1);
	gtk_window_set_title(GTK_WINDOW(dialog1), "dialog1");
	gtk_window_set_policy(GTK_WINDOW(dialog1), TRUE, TRUE, FALSE);
	gtk_widget_set_usize(dialog1, 200, 600);
	gtk_accel_group_attach(accel_group, GTK_OBJECT(dialog1));

	dialog_vbox1 = GTK_DIALOG(dialog1)->vbox;
	gtk_object_set_data(GTK_OBJECT(dialog1), "dialog_vbox1",
			    dialog_vbox1);
	gtk_widget_show(dialog_vbox1);

	scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow1);
	gtk_box_pack_start(GTK_BOX(dialog_vbox1), scrolledwindow1, TRUE,
			   TRUE, 0);

	viewport1 = gtk_viewport_new(NULL, NULL);
	gtk_widget_show(viewport1);
	gtk_container_add(GTK_CONTAINER(scrolledwindow1), viewport1);

	gtk_container_add(GTK_CONTAINER(viewport1), t_widget);

	dialog_action_area1 = GTK_DIALOG(dialog1)->action_area;
	gtk_object_set_data(GTK_OBJECT(dialog1), "dialog_action_area1",
			    dialog_action_area1);
	gtk_widget_show(dialog_action_area1);
	gtk_container_set_border_width(GTK_CONTAINER(dialog_action_area1),
				       10);

	hbuttonbox1 = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox1);
	gtk_box_pack_start(GTK_BOX(dialog_action_area1),
			   hbuttonbox1, TRUE, TRUE, 0);

	
	button1 = gtk_button_new_with_label(_("Toggle Crypt"));
		gtk_widget_show(button1);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog1)->action_area),
			   button1, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button1), "clicked",
			   (GtkSignalFunc) toggle_crypt, (gpointer) viewport1);


	button2 = gtk_button_new_with_label(_("Cancel"));
	gtk_widget_show(button2);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog1)->action_area),
			   button2, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button2), "clicked",
			   (GtkSignalFunc) show_dvb, (gpointer) dialog1);


	return dialog1;
}
