/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

// ----------------------------------------------------------------------------------
//
// testfilter, skeleton code for building plugins.
//
// 14-03-2002 - Jarl van Katwijk
//
// ----------------------------------------------------------------------------------
//
// Howto code a new plugin:
//
// 1) Define the name of the new plugin, and replace all occurances of 'testfilter'
//    by '{newname}filter'. (Also the C filename).
//    NOTE: check the exsisting filters there aint one with the same name already.
//
// 2) Define the filter type: Audio of Video. Change UNKNOWNT in the type function
//    to the type of the new filter.
// 3) Define the phase where the filter is applied: PRE, NORMAL or POST. For audio
//    filter this is just a sequence: 1st all PRE phase filters are applied, than
//    NORMAL, than POST. For video filters PRE phase filters get unzoomed frames,
//    NORMAL and POST get zoomed frames.
// 4) Implement the filter code. Initialisation in the init function, cleanup\reset
//    code in the destruct function, and the actual filtering in the apply function.
// 5) Edit ./plug-ins/Makefile.am and add the new plugin. And add the new plugin to 
//    ./encoder/plugin-loader.cpp in the function init_plugins(). (Yeah, crappy yet,
//    this will change very soon). Compile, install, and run...
//
//
// ----------------------------------------------------------------------------------


#include "../config.h"
#include "../src/drip.h"
#include "../encoder/plugin-loader.hh"
#include <gmodule.h>

// Custom includes:
// none

#undef DEBUG


static gboolean init_done = FALSE;                 // Plugin initialised flag
static gint width,height;                          // Input Width\Height sizes
static gint xoff,yoff,xlen,ylen;                   // Offset and lenght values
static gdouble framerate;                           // Framerate (25.00, 29.97, etc)
static gdouble value1,value2,value3,value4,value5;  // Plugin defined values - these are loaded\saved by Drip
static guint8 *src_planes[3];                      // Input data planes (I420 colour space)
static guint8 *dst_planes[3];                      // Output data planes
// Custom vari's
// none

extern "C" {





/* ----------------------------------- */
/* FILTER TYPES:  AUDIO, VIDEO, SPU(?) */
/* FILTER PHASE:  PRE, NORMAL, POST    */
/* ----------------------------------- */


/* Return type (SPU,AUDIO,VIDEO) of filter */
G_MODULE_EXPORT module_type_e testfilter_type(void) {                                        /* DEFINE! */
    return UNKNOWNT;                                                                         /* DEFINE! */
}


/* Return phase (PRE,NORMAL,POST) of filter */
G_MODULE_EXPORT module_phase_e testfilter_phase(void) {                                      /* DEFINE! */
    return UNKNOWNP;                                                                         /* DEFINE! */
}





/* ---------------------------------- */
/* FILTER FUNCTIONS TO BE IMPLEMENTED */
/* ---------------------------------- */

/* Function which implements a GtkPlug to let user configure this plugin */
G_MODULE_EXPORT GtkWidget* testfilter_gui(void) {                                            /* DEFINE! */
    static GtkWidget *gui = NULL;
    #ifdef DEBUG
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: testfilter gui");
    #endif


    /* Build the gtk user interface for this plugins here. Also implement the callbacks */
    gui = gtk_label_new("\n\n\ntestfilter\n\nThis is just a test filter,\ndoesn't do anything\n");

    /* Clean & Exit */
    return gui;
}


/* This function is called for every (audio\video) frame.
   NOTE: Incoming pixel data is in I420 YUV format
   Here the actual filtering is done. */

G_MODULE_EXPORT guint8** testfilter_apply(guint8** src, glong size, gulong SCR, gulong PTS) {  /* DEFINE! */
    #ifdef DEBUG
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: testfilter apply (PTS=%lu,SCR=%lu)",PTS,SCR);
    #endif


    /* -------------------------- */                                                         /* DEFINE! */
    /* IMPLEMENT FILTER CODE HERE */
    /* -------------------------- */


    /* Clean & Exit */
    return src;             // returning input data, here dst=src, but dst!=src is OK too
                            // NOTE: returned pixel map must be in I420 YUV format!
}


G_MODULE_EXPORT void testfilter_init(gint w, gint h,                                         /* DEFINE! */
                                     gint xo, gint yo, gint xl, gint yl,
                                     gdouble fr) {
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: testfilter init");
    /* Copy values */
    width = w; height = h;
    xoff = xo; yoff = yo; xlen = xl; ylen = yl;
    framerate = fr;
    /* Filter specific initialisation */
                                                                                             /* DEFINE! */
    /* Set init flag */
    init_done = TRUE;
    /* Clean & Exit */
    return;
}


/* Called when parameters need tobe reset to default, auto called when plugin used for 1st time */
G_MODULE_EXPORT void testfilter_default(void) {                                             /* DEFINE! */
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: testfilter default");
    /* Set value's to default */
    value1 = 0;
    value2 = 0;
    value3 = 0;
    value4 = 0;
    value5 = 0;
    /* Clean & Exit */
    return;
}


/* Called after encoding has ended. Variable can be reset etc. */
G_MODULE_EXPORT void testfilter_destruct(void) {                                             /* DEFINE! */
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: testfilter destruct");
    /* Clean & Exit */
    return;
}






/* ------------------------------------------------------------------------ */
/* FIXED FUNCTIONS AFTER THIS POINT, DONT EDIT, ONLY CHANGE FUNCTION NAMES! */
/* ------------------------------------------------------------------------ */


/* Return values of plugin (value1,value2,... value5) */
G_MODULE_EXPORT void testfilter_values(gdouble* values) {                                    /* DEFINE! */
    values[0] = value1;
    values[1] = value2;
    values[2] = value3;
    values[3] = value4;
    values[4] = value5;
    // etc, there are [VALUES] values loaded\saved, see ./encoder/plugin-loader.hh
    return;
}

/* Set plugins values */
G_MODULE_EXPORT void testfilter_values_function(gdouble *v) { /* DEFINE */
    value1 = v[0];
    value2 = v[1];
    value3 = v[2];
    value4 = v[3];
    value5 = v[4];
    return;
}

/* g_module_check_init is automatically executed upon loading */
G_MODULE_EXPORT const gchar* g_module_check_init(GModule *module) {
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: testfilter selftest passed");                   /* DEFINE! */
    return NULL;
}

} //extern "C"


