/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "main.hh"
#include <glib.h>
#include "encoder.hh"
#include <stream.h>
#include <iostream>
#include <vector>
#include <dirent.h>
#include <dlfcn.h>
#include <videoencoder.h>
#include <avifile.h>
#include <aviplay.h>
#include <version.h>

#include <ostream.h>
#include <fstream>
#include <sstream>
#include <cstdlib>
#include <cstdio>
#include <string.h>
#include <dirent.h>
#include <dlfcn.h>
#include <string>
#include <pthread.h>
// Avifile
#include <avm_default.h>
#include <avm_fourcc.h>
#include <creators.h>

using namespace std;

extern "C" {
    codecS **list;
    drip_config Config;


    void encoder_start(const char *parameters,glong nice) {
        /* start encoding */
        gint count = 0;
        gint result;
        gchar **param;
        arg_parmS arg_parm;
        gpointer temp,returned;

        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Encoder got activated");
        /* already encoding? */
        if (encoding) {
            g_log(DRIP_LD,G_LOG_LEVEL_WARNING,"Already encoding.");
            return;
        }
        encoding = TRUE;

        /* split parameters */
        #ifndef STANDALONE
        drip_lock("encoder_start1");
        #endif
        param = g_strsplit(parameters," ",0);
        #ifndef STANDALONE
        drip_unlock("encoder_start1");
        #endif
        while (param[count]!=NULL) {
            count++;
        }
        arg_parm.argc = count;
        arg_parm.argv = param;
        arg_parm.nice = nice;

//        /* Do the encoding */
//        temp = &arg_parm; //keep compiler happy about next line :
//        encoderthread_id = pthread_create(&encoderthread,NULL,encode,temp);
//        /* TODO : spawn multiple threads to make SMP machines happy */
//
//        // Hmm.. enabling this wont allow encoding\caching at the same time
//        /* wait for encoding to be ready */
//        result = pthread_join(encoderthread,NULL);

        temp = &arg_parm;
        returned = encode(temp);
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Encoder ended");
        /* free & exit */
        return;
    }

    void encoder_refresh_progress(gboolean lock) {
        gchar *domain;

        if (lock) domain = DRIP_LD;
        else domain = DRIP_CB_LD;

        writeout_frames_countdown = 1;
        /* remove ior file */
        return;
    }

    void encoder_quit(gboolean lock) {
        gchar *domain;

        if (lock) domain = DRIP_LD;
        else domain = DRIP_CB_LD;
        g_log(domain,G_LOG_LEVEL_MESSAGE,"dripencoder about to exit");

        /* TODO: cleanup before exit */
        if (encoding) {
            pthread_cancel(encoderthread);
            encoding = FALSE;
        }
        g_log(domain,G_LOG_LEVEL_MESSAGE,"dripencoder exiting.");
        return;
    }
    void encoder_stop(gboolean lock) {
        gchar *domain;

        if (lock) domain = DRIP_LD;
        else domain = DRIP_CB_LD;

        if (encoding) {
            stopped = TRUE;
            encoding = FALSE;
            g_log(domain,G_LOG_LEVEL_DEBUG,"Stopped encoding");
        } else {
            g_log(domain,G_LOG_LEVEL_DEBUG,"Not encoding, couldn't stop");
        }
        return;
    }

    void encoder_pause(gboolean lock) {
        gchar *domain;

        if (lock) domain = DRIP_LD;
        else domain = DRIP_CB_LD;

        if (encoding) {
            encoding_paused = TRUE;
            g_log(domain,G_LOG_LEVEL_MESSAGE,"Paused encoding ...");
        } else {
            g_log(domain,G_LOG_LEVEL_DEBUG,"Not encoding, couldn't pause");
        }
        return;
    }

    void encoder_resume(gboolean lock) {
        gchar *domain;

        if (lock) domain = DRIP_LD;
        else domain = DRIP_CB_LD;

        if (encoding && encoding_paused) {
            encoding_paused = FALSE;
            g_log(domain,G_LOG_LEVEL_MESSAGE,"... Resumed proces");
        } else {
            g_log(domain,G_LOG_LEVEL_DEBUG,"Not paused, couldn't resume");
        }
        return;
    }

    codecS** encoder_codecs() {
        avm::vector<CodecInfo>::iterator it;
        gint codec_nr = 0,i;
        gint codec=0x55;
        GString *temp = g_string_new("");

        /* Set an attribute so codecs are loaded */
        const CodecInfo* codecInfo;
        codecInfo = CodecInfo::match(codec);
        /* Scan for amount of plugins */
        for (it = video_codecs.begin(); it != video_codecs.end(); it++) {
             if (it->direction & CodecInfo::Encode) {
                 avm::vector<fourcc_t>::const_iterator iv;
                 for (iv = it->fourcc_array.begin(); iv != it->fourcc_array.end(); iv++) {
                     codec_nr++;
                 }
             }
        }
        for (it = audio_codecs.begin(); it != audio_codecs.end(); it++) {
              avm::vector<fourcc_t>::const_iterator ia;
              for (ia = it->fourcc_array.begin(); ia != it->fourcc_array.end(); ia++) {
                  codec_nr++;
              }
        }

        /* Build codec list */
        list = (codecS**)malloc(sizeof(codecS*) * codec_nr);
        list[0] = (codecS*)malloc(sizeof(codecS));
        /* Alloc list */
        for (i=1;i<codec_nr;i++) {
            list[i] = (codecS*)malloc(sizeof(codecS));
        }

        codec_nr = 0;
        for (it = video_codecs.begin(); it != video_codecs.end(); it++) {
            if ((it->direction == CodecInfo::Encode) || (it->direction == CodecInfo::Both)) {
                avm::vector<fourcc_t>::const_iterator iv;
                for (iv = it->fourcc_array.begin(); iv != it->fourcc_array.end(); iv++) {
                    #ifndef STANDALONE
                    drip_lock("encoder_resume1");
                    #endif
                    list[codec_nr]->ctype = g_string_new("    ");
                    list[codec_nr]->ctype->str[0] = ((const char*)&(*iv))[0];
                    list[codec_nr]->ctype->str[1] = ((const char*)&(*iv))[1];
                    list[codec_nr]->ctype->str[2] = ((const char*)&(*iv))[2];
                    list[codec_nr]->ctype->str[3] = ((const char*)&(*iv))[3];
                    list[codec_nr]->ccodec = *iv;
                    list[codec_nr]->cmodule = g_string_new(it->privatename.c_str());
                    list[codec_nr]->cdescription = g_string_new(list[codec_nr]->ctype->str);
                    list[codec_nr]->cdescription = g_string_append(list[codec_nr]->cdescription,": ");
                    list[codec_nr]->cdescription = g_string_append(list[codec_nr]->cdescription,it->GetName());
                    list[codec_nr]->cav = (enum codecT)0;
                    list[codec_nr]->ci = (gpointer)it;
                    codec_nr++;
                    #ifndef STANDALONE
                    drip_unlock("encoder_resume1");
                    #endif
                    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Video codec %s (%s) added",it->privatename.c_str(),it->GetName());
                }
            }  else {
                g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Video codec %s (%s) can only decode",it->privatename.c_str(),it->GetName());            }
        }
        for (it = audio_codecs.begin(); it != audio_codecs.end(); it++) {
            if (it->direction & CodecInfo::Encode) {
                avm::vector<fourcc_t>::const_iterator ia;
                for (ia = it->fourcc_array.begin(); ia != it->fourcc_array.end(); ia++) {
                    #ifndef STANDALONE
                    drip_lock("encoder_resume2");
                    #endif
                    list[codec_nr]->ctype = g_string_new("    ");
                    list[codec_nr]->ctype->str[0] = ((const char*)&(*ia))[0];
                    list[codec_nr]->ctype->str[1] = ((const char*)&(*ia))[1];
                    list[codec_nr]->ctype->str[2] = ((const char*)&(*ia))[2];
                    list[codec_nr]->ctype->str[3] = ((const char*)&(*ia))[3];
                    list[codec_nr]->ccodec = *ia;
                    list[codec_nr]->cmodule = g_string_new(it->privatename.c_str());
                    list[codec_nr]->cdescription = g_string_new(it->GetName());
                    list[codec_nr]->cav = (enum codecT)1;
                    list[codec_nr]->ci = (gpointer)it;
                    codec_nr++;
                    #ifndef STANDALONE
                    drip_unlock("encoder_resume2");
                    #endif
                    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Audio codec %s (%s) added",it->privatename.c_str(),it->GetName());
                }
            } else {
                g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Audio codec %s (%s) can only decode",it->privatename.c_str(),it->GetName());
            }
        }

        list[0]->length = codec_nr;
        #ifndef STANDALONE
        drip_lock("encoder_resume3");
        #endif
        g_string_free(temp,TRUE);
        #ifndef STANDALONE
        drip_unlock("encoder_resume3");
        #endif
        return list;
    }

} // extern "C"
