### Copyright (C) 1995 Jeppe Buk (buk@imada.sdu.dk)
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

proc getColors {} {
  set names {}
  set path [auto_execok showrgb]
  if {$path != 0 && $path != ""} {
    set lines [split [exec showrgb] "\n"]
    foreach line $lines {
      if {[llength $line] == 4} {
	lappend names [lindex $line 3]
      }
    }
  }
  return [lsort $names]
}

proc getFonts {} {
  set result {}
  set path [auto_execok xlsfonts]
  if {$path != 0 && $path != ""} {
    set result [exec xlsfonts]
  }
  return [lsort $result]
}

proc makeContextOrModifier {contextList} {
  set result {}
  foreach var $contextList {
    append result [string index $var 0]
  }
  return $result
}

proc removeNonIntegers {shouldBeNumbersList} {
  set result {}
  foreach shouldBeNumber $shouldBeNumbersList {
    if {[regexp {[0-9]+} $shouldBeNumber]} {
      lappend result $shouldBeNumber
    }
  }
  return $result
}
