# -*- coding: utf-8 -*-
"""This module provides a time class in Python. It is typically used for
problems involving time stepping ."""

# Copyright (C) 2008-2010 Garth N. Wells
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2008-08-29
# Last changed: 2010-04-30

__all__ = ["Time"]

class Time:
    def  __init__(self, value):
        self.value = value

    def __iadd__(self, value):
        self.value += value
        return self

    def __isub__(self, value):
        self.value -= value
        return self

    def __idiv__(self, value):
        self.value /= value
        return self

    def __imul__(self, value):
        self.value *= value
        return self

    def __mul__(self, value):
        return self.value*value

    def __div__(self, value):
        return self.value/value

    def __lt__(self, value):
        return self.value < value

    def __gt__(self, value):
        return self.value > value

    def __call__(self):
        return self.value

    def __float__(self):
        return self.value

    def __str__(self):
        return str(self.value)
