/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dummy_test_data.ts.cpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta]
 */


#include <diagnostics/util/dummy_test_data.ts.hpp>

#include <diagnostics/unittest/test_exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

Dummy_Test_Data::Dummy_Test_Data()
{
    // be aware: Test_Cases depend on exactly this content...
    m_data["1"]="A";
    m_data["2"]="B";
    m_data["3"]="C";
    m_data["4"]="D";

    m_data["01"]="0A";
    m_data["02"]="0B";
    m_data["03"]="0C";
    m_data["04"]="0D";

    m_data["101"]="10A";
    m_data["102"]="10B";
    m_data["103"]="10C";
    m_data["104"]="10D";
}


::std::string const & Dummy_Test_Data::get(::std::string const & id) const
{
    Data_t::const_iterator iter(m_data.find(id));
    if(iter==m_data.end()) throw Test_Exception("could not find id '" + id + "'");
    return iter->second;
}

bool Dummy_Test_Data::compare(::std::string const & id,::std::string const & data) const
{
    Data_t::const_iterator iter(m_data.find(id));
    if(iter==m_data.end()) throw Test_Exception("could not find id '" + id + "'");
    return iter->second==data;
}



TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
