/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdio.h>

#include "detect.h"
#include "utils.h"
#include "serial.h"

int verbose_report = 0;

/**********************************************************************/
/* print version information                                          */
/**********************************************************************/
extern void version(){
  printf("%s %s\t%s\n", PACKAGE, VERSION, _("(c)2000 MandrakeSoft"));
}/*enfunc version*/


/**********************************************************************/
/* print usage informations                                           */
/**********************************************************************/
extern void usage(){
  version();
  /* Note to translators: Next strings will be the explanations for   */
  /* the commandline options:                                         */
  printf(_("\nUsage: %s [OPTION]\n\n"), PACKAGE);
  /* --help */
  printf("  --help\t\t%s\n", _("Show this help and exit"));
  /* --serial-modem */
  printf("  --serial-modem\t%s\n", _("Detect serial modem and exit"));
  /* --debug*/
  printf("  --debug\t\t%s\n", _("Show debug message"));
  /* --version */
  printf("  --version\t\t%s\n", _("Show version info and exit"));
  /* --verbose */
  printf("  --verbose\t\t%s\n", _("Create a more user readable report "
                                  "file"));
  /* How to report bugs (like awfull english strings ;-)              */
  printf("\n%s\n", _("Report bugs to <harddrake@mandrakesoft.com>.")); 
}/*enfunc usage*/


/**********************************************************************/
/* parse the detect command line                                      */
/**********************************************************************/
extern int parseCommandLine(int argc, char *argv[]){
  int i;

  verbose_report = 0;
  debug = 0;
  
  /*Parse command line*/
  for(i = 1; i < argc; i++){
    if(!strcmp(argv[i], "--help")) {
      usage();
      _exit(0);
    }else if(!strcmp(argv[i], "--serial-modem")) {
      print_serial_modem();
      _exit(0);
    }else if(!strcmp(argv[i], "--debug")) {
      debug = 1;
    }else if(!strcmp(argv[i], "--version")) {
      version();
      _exit(0);
    }else if(!strcmp(argv[i], "--verbose")){
      verbose_report = 1;
    }/*endif*/
  }/*next i*/
  return 0;
}/*endfunc parseCommandLine*/

/**********************************************************************/
/* print_serial_modem:  Detect serial modems and produce mail output  */
/**********************************************************************/
extern void print_serial_modem(){
  struct cards_lst *lst = (struct cards_lst *)NULL;
  struct serial_info *serial = (struct serial_info *)NULL;
  int extensions_exist;
  int revision_temp;
  struct cards_lst *bkup_lst;
  char *dev_id;
  int i;
  int fd;
  int test, found;
  int serial_attr;
  struct termios origattr;
  struct pnp_com_id pnp_id;
  char *string;
  
  /* sync before all                                                  */
  /* Shoudl be called in all programs linked with detect ...          */
  sync();
 
  /* Initialize hardware device list                                  */
  lst = init_lst(PATH_ISA_LST, PATH_PCI_LST, PATH_PCMCIA_LST, PATH_USB_LST);
  /********************************************************************/
  /********************* SERIAL MODEM DETECTION ***********************/
  /********************************************************************/
  for(serial = serial_detect(lst); serial; serial=serial->next){
    if((serial->type == UNKNOWN_DEVICE) || (serial->type == MODEM)){
      if((fd = open_serial_port(serial->device)) < 0){
        continue;
      }/*endif*/
      serial_attr = get_serial_attr(fd, &origattr);
      if(serial_attr < 0){
        continue;
      }/*endif*/
      test = find_legacy_modem(fd);
      if(test == 3){  /* we found a modem */
        string = modem_response(fd, "ATI9\r");
        if(parse_pnp_string(string, strlen(string), &pnp_id) == 0){
          dev_id = (char *)my_malloc(9);
          sprintf(dev_id, "%3s%4s", pnp_id.eisa_id, 
                                    pnp_id.product_id);
          found = 0;
          for(bkup_lst = lst; bkup_lst; bkup_lst = bkup_lst->next){
            if(bkup_lst->bus == SERIAL){
              if(!strcmp(dev_id, bkup_lst->dev_id)){
                fprintf(stdout, _("Your Modem has been detected:\n"));
                fprintf(stdout, _("\t%s: %s\n"), _("vendor"), 
                                bkup_lst->vendor);
                fprintf(stdout, _("\t%s: %s\n"), _("model"), 
                                bkup_lst->model);
               if(strcmp(bkup_lst->modulename, s_ignore)){
                  fprintf(stdout, _("\t%s: %s\n"), _("module"), 
                                  bkup_lst->modulename);
                }/*endif*/
                fprintf(stdout, _("\t%s: %s\n"), _("device"), 
                                serial->device);
                found = 1;
              }/*endif*/
            }/*endif*/
          }/*next bkup_lst*/
          if(!found){
            if(pnp_id.other_len != 0){
              fprintf(stdout, "Detected non-PnP data stream at start.\n");
              fprintf(stdout, "  Length   = 0x%x\n",pnp_id.other_len);
              fprintf(stdout, "  Contents =");
              for(i=0; i<pnp_id.other_len; i++){
                fprintf(stdout, " 0x%x",pnp_id.other_id[i]);
              }/*next i*/
              printf("\n");
            }else{
              fprintf(stdout, "Non-PnP data stream not detected at start.\n");
            }/*endif*/
            
            /* parse PnP revision bytes into a string values (eg. "1.00") */
            revision_temp = ((pnp_id.pnp_rev[0]&0x3f) << 6)+(pnp_id.pnp_rev[1]&0x3f);
            sprintf(pnp_id.pnp_rev_str, "%d.%d", revision_temp/100,
                                                 revision_temp % 100);
            fprintf(stdout, "\nPnP Required fields:\n");
            fprintf(stdout, "    Revision       = %s\n", 
                            pnp_id.pnp_rev_str);
            fprintf(stdout, "    Manufacturer   = %s\n", 
                            pnp_id.eisa_id);
            fprintf(stdout, "    Product ID     = %s\n", 
                            pnp_id.product_id);
            extensions_exist = pnp_id.serial_number[0] || 
                               pnp_id.class_name[0]    || 
                               pnp_id.driver_id[0]     || 
                               pnp_id.user_name[0];
            if(extensions_exist){
              fprintf(stdout, "\nPnP extension field(s) exist:\n");
              if(pnp_id.serial_number[0]){
                fprintf(stdout, "    Serial Number   = %s\n", 
                                pnp_id.serial_number);
              }/*endif*/
              if(pnp_id.class_name[0]){
                fprintf(stdout, "    PnP class name  = %s\n", 
                                pnp_id.class_name);
              }/*endif*/
              if(pnp_id.driver_id[0]){
                fprintf(stdout, "    PnP Compatible  = %s\n", 
                                pnp_id.driver_id);
              }/*endif*/
              if(pnp_id.user_name[0]){
                fprintf(stdout, "    PnP Description = %s\n", 
                                pnp_id.user_name);
              }/*endif*/
            }/*endif*/
            fprintf(stdout, "\nOther usefull information:\n");
            for(i=0; i<9; i++){
              sprintf(dev_id, "ATI%d\r", i);
              string = modem_response(fd, dev_id);
              fprintf(stdout, "\nATI%d answered:\n<%s>\n", i, string);
            }/*next i*/
          }/*endif*/
        }/*endif*/
      }/*endif*/
      close_serial_port(fd);
    }/*endif*/
  }/*next serial*/
}/*endfunc print_serial_modem*/

