/* scoreops.cpp
 * functions dealing with the whole score

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000-2005 Matthew Hiller, Adam Tee*/

#include <denemo/denemo.h>
#include <stdio.h>
#include "staffops.h"
#include "scoreops.h"
#define INITIAL_WHOLEWIDTH 160
#define INITIAL_STAFFHEIGHT 100


/**
 * Initialise scoreinfo structure 
 *
 * @param si pointer to the scoreinfo structure to initialise
 */
void
init_score (struct scoreinfo *si)
{
  si->readonly = 0;
  si->leftmeasurenum = si->rightmeasurenum = 1;
  si->top_staff = si->bottom_staff = 1;
  si->measurewidth = INITIAL_WHOLEWIDTH;
  si->measurewidths = NULL;
  si->staffspace = INITIAL_STAFFHEIGHT;
	si->config = NULL;
  si->thescore = NULL;
  si->currentstaffnum = 1;
  si->currentmeasurenum = 1;
  si->currentobject = NULL;
  si->cursor_x = 0;
  si->cursor_y = 0;
  si->staffletter_y = 0;
  si->cursor_appending = TRUE;
  si->mode = INPUTNORMAL;
  si->cursoroffend = FALSE;
  si->markstaffnum = 0;
  si->markmeasurenum = 0;
  si->markcursor_x = 0;
  si->maxkeywidth = 0;
  si->haschanged = FALSE;
  si->is_grace_mode = FALSE;
  si->has_figures = FALSE;
  /*playback purposes */
  si->tempo = 60;
  si->start = 0;
  si->end = 0;
  si->stafftoplay = 0;

  si->savebuffer = NULL;
  si->plugins = NULL;
  si->plugincounter = 0;
  si->bookmarks = NULL;

  si->headerinfo = new_mudela_header ();

  si->filename = g_string_new ("");
  si->autosavename = NULL;
  si->textbuffer = 0;		/* text of lily input string corresponding to curobj */
  si->textwindow = 0;		/* top level window containing lily text */
  si->curlilynode = 0;		/* the node of the lily parse tree on display in 
				   textwindow */
  si->lily_file = 0;		/* root of lily file parse, see lilyparser.y etc  */
  si->sconfig = new_score_config();
  /* Undo/redo initialisation */
  si->undodata = g_queue_new();
  si->undo_level = 0;
  si->redodata = g_queue_new();
  si->redo_level = 0;
  si->undo_redo_mode = 1;
}


/**
 * removes the data from the current scoreinfo stucture 
 * and reinitialises it
 * @param si pointer to the scoreinfo structure to initialise
 */
void
free_score (struct scoreinfo *si)
{
  gint final = (gint) (g_list_length (si->thescore));
  if (si->lily_file != NULL)
    abandon_lily_tree (si);
  for (; final == 0; --final)
    {
      si->currentstaffnum = final;
      si->currentstaff = g_list_nth (si->thescore, final - 1);
      removestaff (si, final, 1);
    }
  /*g_string_free (si->title, FALSE);
     g_string_free (si->subtitle, FALSE);
     g_string_free (si->composer, FALSE);
     g_string_free (si->filename, FALSE); */
  /* what's up with this ? dlp wants to know... */
  init_score (si);
}

/**
 * Destroy the lilypond mode text view of the score
 */
void
abandon_lily_tree (scoreinfo * si)
{

  if (si->textwindow)
    gtk_widget_destroy (si->textwindow);
  /* FIXME memory leak */
  si->lily_file = NULL;
  si->textwindow = NULL;
  si->scoreblocks = NULL;	/* FIXME memory leak */
}

/**
 * Creates and initialises the mudela header struture
 * 
 * @return the newly created mudela_header structure
 */
struct mudelaheaderinfo *
new_mudela_header ()
{
  struct mudelaheaderinfo *head;

  head = (struct mudelaheaderinfo *)
    g_malloc0 (sizeof (struct mudelaheaderinfo));

  /* Header info */
  head->title = g_string_new ("");
  head->subtitle = g_string_new ("");
  head->poet = g_string_new ("");
  head->composer = g_string_new ("");
  head->meter = g_string_new ("");
  head->opus = g_string_new ("");
  head->arranger = g_string_new ("");
  head->instrument = g_string_new ("");
  head->dedication = g_string_new ("");
  head->piece = g_string_new ("");
  head->head = g_string_new ("");
  head->copyright = g_string_new ("");
  head->footer = g_string_new ("");
  head->tagline = g_string_new ("");
/*  head-> = g_string_new (""); */

  return head;

}

/**
 * Create and initialise the score config struture
 *
 * @return the newly created score config structure
 */
scoreconfig *
new_score_config()
{
	scoreconfig *config = (scoreconfig *) g_malloc0(sizeof(scoreconfig));
	
	config->papersize = g_string_new("a4"); //A4 default
	config->fontsize = 16;
	config->lilyversion = g_string_new("2.6.0");
	config->orientation = TRUE;  //portrait

   return config;
}
