/* playbackprops.c
 * callback that creates a "Playback Properties" dialog box asking
 * the user to change the properties of the playback for the current 
 * score
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002 Adam Tee, Matthew Hiller */

#include <stdlib.h>
#include <string.h>
#include <denemo/denemo.h>
#include "utils.h"

struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *play_measure;
  GtkWidget *from_measure;
  GtkWidget *to_measure;
  GtkWidget *play_only;
  GtkWidget *staves;
};


/**
 * Callback: "Play all staves" was toggled
 */
static void toggle_play_staves(GtkWidget* radio_button, struct callbackdata *cbdata)
{
  gtk_widget_set_sensitive(cbdata->staves,
			   gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_button)));
}

/**
 * Callback: "Play measure" was toggled
 */
static void toggle_play_measure(GtkWidget* radio_button, struct callbackdata *cbdata)
{
  gboolean enabled = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_button));
  gtk_widget_set_sensitive(cbdata->from_measure, enabled);
  gtk_widget_set_sensitive(cbdata->to_measure, enabled);
}

void playback_properties_change
(GtkAction *action, gpointer callback_data)
{
  scoreinfo *si = (struct scoreinfo *) callback_data;
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *hbox;
  GtkWidget *tempo;
  GtkWidget *play_entire_pice;
  GtkWidget *play_measure;
  GtkWidget *from_measure;
  GtkWidget *to_measure;
  GtkWidget *play_all_staves;
  GtkWidget *play_only;
  GtkWidget *staves;
  static struct callbackdata cbdata;

  dialog = gtk_dialog_new_with_buttons (_("Playback properties"),
					GTK_WINDOW(si->window),
					(GtkDialogFlags)(GTK_DIALOG_MODAL |
							 GTK_DIALOG_DESTROY_WITH_PARENT),
					GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
					GTK_STOCK_CANCEL, GTK_STOCK_CANCEL,
					 NULL );

  table = gtk_table_new (8, 2, FALSE);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->vbox), table, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table), 12);
  gtk_table_set_row_spacings (GTK_TABLE (table), 8);
  gtk_table_set_col_spacings (GTK_TABLE (table), 8);

  label = gtk_label_new (_("<b>Tempo</b>"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  // spacer
  label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (label, 12, -1);

  hbox = gtk_hbox_new (FALSE, 8);
  gtk_table_attach (GTK_TABLE (table), hbox, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  tempo = gtk_spin_button_new_with_range(10.0, 250.0, 1.0);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(tempo), (gdouble)si->tempo);
  gtk_box_pack_start (GTK_BOX (hbox), tempo, FALSE, FALSE, 0);

  label = gtk_label_new (_("BPM"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);


  label = gtk_label_new (_("<b>Play measures</b>"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);


  // spacer
  label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (label, 12, -1);


  play_entire_pice = gtk_radio_button_new_with_label (NULL, _("Play the entire pice"));
  gtk_table_attach (GTK_TABLE (table), play_entire_pice, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  // spacer
  label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (label, 12, -1);

  hbox = gtk_hbox_new (FALSE, 8);
  gtk_table_attach (GTK_TABLE (table), hbox, 1, 2, 4, 5,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  play_measure = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(play_entire_pice),
					      _("Play measure"));
  gtk_box_pack_start (GTK_BOX (hbox), play_measure, FALSE, FALSE, 0);

  gint max_mesure = g_list_length(((staff*)(si->thescore->data))->measures);

  from_measure = gtk_spin_button_new_with_range(1.0, (gdouble)max_mesure, 1.0);
  gtk_box_pack_start (GTK_BOX (hbox), from_measure, TRUE, TRUE, 0);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(from_measure), (gdouble)si->start);

  label = gtk_label_new (_("to"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  to_measure = gtk_spin_button_new_with_range(1.0, (gdouble)max_mesure, 1.0);
  gtk_box_pack_start (GTK_BOX (hbox), to_measure, TRUE, TRUE, 0);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(to_measure), (gdouble)si->end);

  if (si->start == 0)
    {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(play_entire_pice), TRUE);
      gtk_widget_set_sensitive(from_measure, FALSE);
      gtk_widget_set_sensitive(to_measure, FALSE);
    }
  else
    {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(play_measure), TRUE);
    }

  label = gtk_label_new (_("<b>Play staves</b>"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  // spacer
  label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (label, 12, -1);

  play_all_staves = gtk_radio_button_new_with_label (NULL, _("Play all staves"));
  gtk_table_attach (GTK_TABLE (table), play_all_staves, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  // spacer
  label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (label, 12, -1);

  hbox = gtk_hbox_new (FALSE, 8);
  gtk_table_attach (GTK_TABLE (table), hbox, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  play_only = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(play_all_staves),
							  _("Play only"));
  gtk_box_pack_start (GTK_BOX (hbox), play_only, FALSE, FALSE, 0);

  staves = gtk_combo_box_new_text ();
  gtk_box_pack_start (GTK_BOX (hbox), staves, TRUE, TRUE, 0);
  for (staffnode* n = si->thescore; n != NULL; n = g_list_next(n))
    {
      gchar* staff_label = NULL;
      staff* s = (staff*)n->data;
      if (s->staff_name != NULL)
	{
          staff_label = s->staff_name->str;
	}
      else if (s->denemo_name != NULL)
	{
	  staff_label = s->denemo_name->str;
	}

      if (staff_label == NULL)
	{
	  staff_label = _("Unnamed staff");
	}
      gtk_combo_box_append_text (GTK_COMBO_BOX (staves), staff_label);
    }

  if (si->stafftoplay == 0)
    {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(play_all_staves), TRUE);
      gtk_widget_set_sensitive(staves, FALSE);
      gtk_combo_box_set_active(GTK_COMBO_BOX(staves), 0);
    }
  else
    {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(play_only), TRUE);
      gtk_combo_box_set_active(GTK_COMBO_BOX(staves), si->stafftoplay -1);
    }

  /* Set up the callback data */
  cbdata.si = si;
  cbdata.play_measure = play_measure;
  cbdata.from_measure = from_measure;
  cbdata.to_measure = to_measure;
  cbdata.play_only = play_only;
  cbdata.staves = staves;

  g_signal_connect(play_only, "toggled", G_CALLBACK (toggle_play_staves), &cbdata);
  g_signal_connect(play_measure, "toggled", G_CALLBACK(toggle_play_measure), &cbdata);

  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_widget_show_all (dialog);


  if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
    {
      si->tempo = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tempo));

      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(play_measure)))
	{
	  si->start = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(from_measure));
	  si->end = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(to_measure));
	}
      else
	{
	  si->start = 0;
          si->end = 0;
	}

      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(play_only)))
	{
	  si->stafftoplay = 1 + gtk_combo_box_get_active(GTK_COMBO_BOX(staves));
	}
      else
	{
	  si->stafftoplay = 0;
	}
    }

  gtk_widget_destroy(dialog);

}
