/* staffpropdialog.c
 * callback that creates a "Staff Properties" dialog box asking
 * the user to change the properties of the current staff

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999 Matthew Hiller */

#include <gtk/gtk.h>
#include "calculatepositions.h"
#include "chordops.h"
#include "contexts.h"
#include "datastructures.h"
#include "processstaffname.h"
#include "staffops.h"
#include "utils.h"
#include <stdlib.h>
#include <string.h>

struct callbackdata
{
  struct scoreinfo *si;
  staff *staffstruct;
  GtkWidget *nameentry;
  GtkWidget *aboveentry;
  GtkWidget *belowentry;
  GtkWidget *numlinesentry;
  GtkWidget *transposeentry;
  GtkWidget *posinhalflinesentry;
  GtkWidget *midientry;
};

/* Actually sets staff properties */

static void
set_properties (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = data;
  staff *staffstruct = cbdata->staffstruct;
  gint n;

  canonicalize_denemo_name
    (gtk_entry_get_text (GTK_ENTRY (cbdata->nameentry)),
     staffstruct->denemo_name);
  set_lily_name (staffstruct->denemo_name, staffstruct->lily_name);

  /* !!!! Insert advisory function for detecting colliding staff names
   * here */

  g_string_assign (staffstruct->midi_instrument,
		   gtk_entry_get_text (GTK_ENTRY (cbdata->midientry)));
  if (n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->aboveentry))))
    staffstruct->space_above = n;
  if (n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->belowentry))))
    staffstruct->space_below = n;
  if (n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->numlinesentry))))
    staffstruct->no_of_lines = n;
  if (n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->transposeentry))))
    staffstruct->transposition = n;
  if (n = atoi (gtk_entry_get_text (GTK_ENTRY (cbdata->posinhalflinesentry))))
    staffstruct->pos_in_half_lines = n;
  beamsandstemdirswholestaff (staffstruct);
  find_xes_in_all_measures (cbdata->si);
  /* (To adjust the stem directions of the notes, if necessary) */

  gtk_widget_draw (cbdata->si->scorearea, NULL);
}

void staff_properties_change
  (gpointer callback_data, guint callback_action, GtkWidget * widget)
{
  struct scoreinfo *si = callback_data;
  staff *staffstruct;
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *nameentry;
  GtkWidget *aboveentry;
  GtkWidget *belowentry;
  GtkWidget *numlinesentry;
  GtkWidget *transposeentry;
  GtkWidget *posinhalflinesentry;
  GtkWidget *midientry;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  static GString *entrycontent;
  static struct callbackdata cbdata;

  if (callback_action)
    staffstruct = g_list_nth (si->thescore, callback_action - 1)->data;
  else
    staffstruct = si->currentstaff->data;

  if (!entrycontent)
    {
      entrycontent = g_string_new (NULL);
    }

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Staff Properties"));

  table = gtk_table_new (4, 5, TRUE);

  label = gtk_label_new (_("Staff name:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  gtk_widget_show (label);
  nameentry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (nameentry), staffstruct->denemo_name->str);
  gtk_table_attach_defaults (GTK_TABLE (table), nameentry, 1, 2, 0, 1);
  gtk_widget_show (nameentry);

  label = gtk_label_new (_("Space above:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  gtk_widget_show (label);
  aboveentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->space_above);
  gtk_entry_set_text (GTK_ENTRY (aboveentry), entrycontent->str);
  gtk_table_attach_defaults (GTK_TABLE (table), aboveentry, 1, 2, 1, 2);
  gtk_widget_show (aboveentry);

  label = gtk_label_new (_("Space below:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  belowentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->space_below);
  gtk_entry_set_text (GTK_ENTRY (belowentry), entrycontent->str);
  gtk_table_attach_defaults (GTK_TABLE (table), belowentry, 1, 2, 2, 3);
  gtk_widget_show (belowentry);

  label = gtk_label_new (_("Number of lines:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 0, 1);
  gtk_widget_show (label);
  numlinesentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->no_of_lines);
  gtk_entry_set_text (GTK_ENTRY (numlinesentry), entrycontent->str);
  gtk_table_attach_defaults (GTK_TABLE (table), numlinesentry, 3, 4, 0, 1);
  gtk_widget_show (numlinesentry);

  label = gtk_label_new (_("Transposition:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 1, 2);
  gtk_widget_show (label);
  transposeentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->transposition);
  gtk_entry_set_text (GTK_ENTRY (transposeentry), entrycontent->str);
  gtk_table_attach_defaults (GTK_TABLE (table), transposeentry, 3, 4, 1, 2);
  gtk_widget_show (transposeentry);

  label = gtk_label_new (_("Position in half-lines:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 2, 3);
  gtk_widget_show (label);
  posinhalflinesentry = gtk_entry_new ();
  g_string_sprintf (entrycontent, "%d", staffstruct->pos_in_half_lines);
  gtk_entry_set_text (GTK_ENTRY (posinhalflinesentry), entrycontent->str);
  gtk_table_attach_defaults (GTK_TABLE (table), posinhalflinesentry,
			     3, 4, 2, 3);
  gtk_widget_show (posinhalflinesentry);

  label = gtk_label_new (_("MIDI Instrument:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 2, 3, 4);
  gtk_widget_show (label);
  midientry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (midientry),
		      staffstruct->midi_instrument->str);
  gtk_table_attach_defaults (GTK_TABLE (table), midientry, 2, 4, 3, 4);
  gtk_widget_show (midientry);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      table, TRUE, TRUE, 0);
  gtk_widget_show (table);

  /* Set up the callback data */

  cbdata.si = si;
  cbdata.staffstruct = staffstruct;
  cbdata.nameentry = nameentry;
  cbdata.aboveentry = aboveentry;
  cbdata.belowentry = belowentry;
  cbdata.numlinesentry = numlinesentry;
  cbdata.transposeentry = transposeentry;
  cbdata.posinhalflinesentry = posinhalflinesentry;
  cbdata.midientry = midientry;

  /* Also set things up so that the callback'll run when you hit enter
   * in the text entries */
  processenter (nameentry, set_properties, cbdata, dialog);
  processenter (aboveentry, set_properties, cbdata, dialog);
  processenter (belowentry, set_properties, cbdata, dialog);
  processenter (numlinesentry, set_properties, cbdata, dialog);
  processenter (transposeentry, set_properties, cbdata, dialog);
  processenter (posinhalflinesentry, set_properties, cbdata, dialog);
  processenter (midientry, set_properties, cbdata, dialog);

  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      okbutton, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (set_properties), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);

  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
  gtk_widget_grab_focus (nameentry);
}
