/* objops.c
 * functions that do operations to mudela objects
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller
 */

#include "datastructures.h"
#include "chordops.h"
#include "utils.h"

void
freeobject (mudelaobject * mudobj)
{
  if (mudobj)
    switch (mudobj->type)
      {
      case CHORD:
	freechord (mudobj);	/* Which also frees mudobj itself */
	break;
      default:
	g_free (mudobj);
	break;
      }
}

mudelaobject *
newtimesigobj (gint time1, gint time2)
{
  mudelaobject *ret;

  ret = g_malloc (sizeof (mudelaobject));
  ret->type = TIMESIG;
  ret->u.timeval.time1 = time1;
  ret->u.timeval.time2 = time2;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

mudelaobject *
newclefobj (gint type)
{
  mudelaobject *ret;

  ret = g_malloc (sizeof (mudelaobject));
  ret->type = CLEF;
  ret->u.clefval.type = type;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

/* This function initializes the accidental-context array associated with
 * a key signature or a staff to that appropriate for _number_ */

void
initkeyaccs (gint * accs, gint number)
{
  int index;

  memset (accs, 0, SEVENGINTS);
  if (number > 0)
    for (index = 3; number; number--, index = (index + 4) % 7)
      accs[index] = 1;
  else if (number < 0)
    for (index = 6; number; number++, index = (index + 3) % 7)
      accs[index] = -1;
}

mudelaobject *
newkeyobj (gint number, gboolean isminor)
{
  mudelaobject *ret;

  ret = g_malloc (sizeof (mudelaobject));
  ret->type = KEYSIG;
  ret->u.keyval.number = number;
  ret->u.keyval.isminor = isminor;
  initkeyaccs (ret->u.keyval.accs, number);
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

mudelaobject *
newmeasurebreakobject ()
{
  mudelaobject *ret;

  ret = g_malloc (sizeof (mudelaobject));
  ret->type = MEASUREBREAK;
  return ret;
}

mudelaobject *
clone_object (mudelaobject * orig)
{
  mudelaobject *ret;

  switch (orig->type)
    {
    case CHORD:
      ret = clone_chord (orig);
      break;
    default:
      ret = g_malloc (sizeof (mudelaobject));
      memcpy (ret, orig, sizeof (mudelaobject));
      break;
    }
  return ret;
}

mudelaobject *
stem_directive_new (gint type)
{
  mudelaobject *ret;

  ret = g_malloc (sizeof (mudelaobject));
  ret->type = STEMDIRECTIVE;
  ret->u.stemval.type = type;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

mudelaobject *
lily_directive_new (gchar * type)
{
  mudelaobject *ret;

  ret = g_malloc (sizeof (mudelaobject));
  ret->type = LILYDIRECTIVE;
  ret->u.lilyval.directive = g_string_new (type);
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

mudelaobject *
dynamic_new (gchar * type)
{
  mudelaobject *ret;

  ret = g_malloc (sizeof (mudelaobject));
  ret->type = DYNAMIC;
  ret->u.dynval.type = g_string_new (type);
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}
