/* drawstemdir.c
 *
 * Functions for drawing stemming directives
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller
 */

#include "utils.h"		/* Includes <gdk.h> */
#include "datastructures.h"

void
draw_stem_directive (GdkPixmap * pixmap, GdkGC * gc, GdkFont * font,
		     gint xx, gint y, mudelaobject * theobj)
{
  static GdkFont *stem_directive_font = NULL;

  if (!stem_directive_font)
    {
      stem_directive_font =
	gdk_fontset_load
	("-*-helvetica-medium-r-normal-*-12-*-*-*-*-*-iso8859-*");
      if (!stem_directive_font)
	stem_directive_font = font;
    }
  switch (theobj->u.stemval.type)
    {
    case STEMUP:
      gdk_draw_text (pixmap, stem_directive_font, gc, xx, y - 4,
		     _("stemup"), 6);
      break;
    case STEMBOTH:
      gdk_draw_text (pixmap, stem_directive_font, gc, xx, y - 4,
		     _("stemboth"), 8);
      break;
    case STEMDOWN:
      gdk_draw_text (pixmap, stem_directive_font, gc, xx, y - 4,
		     _("stemdown"), 8);
      break;
    }
}
