/* $Id: print.c,v 1.1.1.1 2000/10/13 06:45:03 kitame Exp $

  print functions for DEdit

  Copyright (C) 1999  Takuo KITAME

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License with
  the Debian GNU/Linux distribution in file /usr/doc/copyright/GPL;
  if not, write to the Free Software Foundation, Inc., 59 Temple Place,
  Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>

#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>

#include "dedit.h"
#include "mdi.h"
#include "file.h"
#include "print.h"

static void print_destroy(GtkWidget *widget, gpointer data);
static void file_print_execute(GtkWidget *widget, gpointer data);
static gchar *generate_temp_file(DEdit *doc);
static gchar *get_filename(DEdit *data);

static GtkWidget *AskDialog;
static GtkWidget *print_dialog = NULL;
static GtkWidget *print_cmd_entry = NULL;

static GtkWidget *file_sel;
gchar *print_cmd;

/*  */
void
dedit_print_cb(GtkWidget *widget, gpointer data)
{
    DEdit *printdoc;
    GtkWidget *hbox;
    GtkWidget *vbox;
    GtkWidget *tmp;

#ifdef TRACE_FUNC
    printf("dedit_print_cb()\n");
#endif

    printdoc = get_doc_from_mdi_child();
    if(!printdoc || print_dialog) return;

    print_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_modal(GTK_WINDOW(print_dialog), TRUE);
    gtk_window_set_title(GTK_WINDOW(print_dialog), _("Print"));
    gtk_window_position(GTK_WINDOW(print_dialog), GTK_WIN_POS_MOUSE);
    gtk_signal_connect(GTK_OBJECT(print_dialog), "destroy",
                       GTK_SIGNAL_FUNC(print_destroy), printdoc);


    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(print_dialog), vbox);
    gtk_container_border_width(GTK_CONTAINER(print_dialog), 6);
    gtk_widget_show(vbox);
  
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 10);
    gtk_widget_show(hbox);
  
    tmp = gtk_label_new(_("Enter print command below\nRemember to include '%s'"));
    gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, TRUE, 5);
    gtk_widget_show(tmp);
  
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 5);
    gtk_widget_show(hbox);
  
    tmp = gtk_label_new(_("Print Command:"));
    gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, TRUE, 5);
    gtk_widget_show(tmp);
  
    print_cmd_entry = gtk_entry_new_with_max_length(255);
    if (print_cmd)
        gtk_entry_set_text(GTK_ENTRY(print_cmd_entry),
                           print_cmd);
    else {
        print_cmd = g_strdup("lpr %s");
        gtk_entry_set_text(GTK_ENTRY(print_cmd_entry),
                       print_cmd);
    }

    gtk_box_pack_start(GTK_BOX(hbox), print_cmd_entry, FALSE, TRUE, 10);
    gtk_widget_show(print_cmd_entry);
		
    tmp = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, TRUE, 10);
    gtk_widget_show(tmp);
  
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 5);
    gtk_widget_show(hbox);
  
    tmp = gnome_stock_button(GNOME_STOCK_BUTTON_OK);
    gtk_box_pack_start(GTK_BOX(hbox), tmp, TRUE, TRUE, 15);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
                       GTK_SIGNAL_FUNC(file_print_execute), printdoc);
    gtk_widget_show(tmp);
		
    tmp = gnome_stock_button(GNOME_STOCK_BUTTON_CANCEL);
    gtk_box_pack_start(GTK_BOX(hbox), tmp, TRUE, TRUE, 15);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
                       GTK_SIGNAL_FUNC(print_destroy), printdoc);
    
    gtk_signal_connect(GTK_OBJECT(print_dialog), "destroy",
                       GTK_SIGNAL_FUNC(print_destroy), printdoc);

    gtk_widget_show(tmp);
    gtk_widget_show(print_dialog);

    return;
}

/*  */
static void
print_destroy(GtkWidget *widget, gpointer data)
{

#ifdef TRACE_FUNC
    printf("print_destroy()\n");
#endif

    if (print_dialog) {
        gtk_widget_destroy(print_dialog);
        print_dialog = NULL;
    }
    if (AskDialog) {
        gtk_widget_destroy(AskDialog);
        AskDialog = NULL;
    }
    if(file_sel) {
        gtk_grab_remove(file_sel);
        gtk_widget_destroy(file_sel);
        file_sel = NULL;
    }

    return;
}

/*  */
static void
file_print_execute(GtkWidget *widget, gpointer data)
{
    gchar *scmd, *pcmd, *tmp, *fname;
    DEdit *printdoc = (DEdit *)data;
    gint buf_size = 0;
    
#ifdef TRACE_FUNC
    printf("file_print_execute()\n");
#endif

    g_assert(printdoc != NULL);

    if(!print_cmd)
        print_cmd = g_strdup(gtk_entry_get_text(GTK_ENTRY(print_cmd_entry)));

    if ((pcmd = gtk_entry_get_text(GTK_ENTRY(print_cmd_entry))) == NULL)
        return;
	
    if ((tmp = strstr(pcmd, "%s")) == NULL)
        return;

    *tmp = '\0';
    tmp += 2;
  
    if ((fname = get_filename(printdoc)) == NULL) {
        print_destroy(NULL, printdoc);
        return;	
    }
    
    buf_size = strlen(pcmd) + strlen(fname) + 1;
    scmd = (gchar *)g_malloc(buf_size);
    g_snprintf(scmd, buf_size, "%s%s%s", pcmd, fname, tmp);
    
    if (system(scmd) == -1)
        perror("file_print_execute: system() error");
	
	g_free(scmd);
  
	if (strncmp(fname, "/tmp", 4) == 0)
        if (unlink(fname))
            perror("file_print_execute: unlink() error");
    
	g_free(fname);
    
	print_destroy(NULL, printdoc);
	
    return;
}

static gchar *
get_filename(DEdit *data)
{
    gchar *fname = NULL;
    gchar *buttons[] =
    { _("Print anyway"), _(" Save, then print "), GNOME_STOCK_BUTTON_CANCEL };
    gchar *title, *msg;
    gint buf_size = 0;

#ifdef TRACE_FUNC
    printf("get_filename()\n");
#endif
  
    g_assert(data != NULL);
  
    if(!data->modified && data->filename) {
    /*
      if (data->sb == NULL)
      data->sb = g_malloc(sizeof(struct stat));
      if (stat(data->filename, data->sb) == -1) {
      g_free(data->sb);
      data->sb = NULL;
      fname = generate_temp_file(data);
      } else
    */
        fname = g_strdup(data->filename);
    } else {
        gint ret;
    
        title = g_strdup(N_("Save before printing?"));
        if (data->filename)
            buf_size = strlen(_("has not been saved!")) + 
                strlen(data->filename) + 6;
        else
            buf_size = strlen(_("has not been saved!")) +
                strlen(_("Untitled")) + 6;
        
        msg = (gchar *)g_malloc(buf_size);
        g_snprintf(msg, buf_size, " '%s' %s ", 
                   (data->filename) ? data->filename : _("Untitled"),
                   _("has not been saved!"));
        
        AskDialog = gnome_message_box_new(msg, GNOME_MESSAGE_BOX_QUESTION, 
                                          buttons[0], buttons[1], buttons[2], NULL);
        
        gtk_window_position(GTK_WINDOW(AskDialog), GTK_WIN_POS_MOUSE);
        ret = gnome_dialog_run_and_close((GnomeDialog *)AskDialog) + 1;
    
        AskDialog = NULL;
        g_free(msg);
        g_free(title);

        switch (ret) {
        case 1 :
            fname = generate_temp_file(data);
            break;
        case 2 :
            save_cb(NULL, data);
            fname = g_strdup(data->filename);
            break;
        case 3 :
            fname = NULL;
            break;
        default:
            fname = NULL;
        }
    } 
  
    return fname;
}

/* Ƥݤ */
static gchar *
generate_temp_file(DEdit *doc)
{
    FILE *fp;
    gchar *fname;

#ifdef TRACE_FUNC
    printf("generate_temp_file()\n");
#endif
    
    fname = (gchar *)g_malloc(STRING_LENGTH_MAX);
    
    g_snprintf(fname, STRING_LENGTH_MAX, "/tmp/.dedit_print.%d%d", (gint)time(NULL), getpid());
    if ((fp = fopen(fname, "w")) == NULL) {
        g_error("generate_temp_file: unable to open '%s'\n", fname);
        g_free(fname);
        return NULL;
    }
  
    if (fputs(gtk_editable_get_chars(GTK_EDITABLE(doc->text), 0,
                                     gtk_text_get_length(GTK_TEXT(doc->text))), fp) == EOF) {
        
        perror("generate_temp_file: can't write to tmp file");
        g_free(fname);
        fclose(fp);
        return NULL;
    }
    fflush(fp);
    fclose(fp);
  
    return fname;
} /* generate_temp_file */
