#ifndef __tree_h__
#define __tree_h__


/** Maximum number of children per node. */
#define MAX_CHILDREN 16


/** Parse tree. */
typedef struct Tree {
	/** Data. */
	int data;
	/** Number of children. */
	int count;
	/** Children. */
	struct Tree* children[MAX_CHILDREN];
} Tree;


Tree* create_node( int data);
void destroy_tree( Tree* tree);
void print_tree( Tree* tree);


#endif
